/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee.packets.in;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketIn;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class RunScriptPacketIn
extends BungeePacketIn {
    @Override
    public String getName() {
        return "RunScript";
    }

    @Override
    public void process(ByteBuf data) {
        if (data.readableBytes() < 24) {
            BungeeBridge.instance.handler.fail("Invalid RunScriptPacket (bytes available: " + data.readableBytes() + ")");
            return;
        }
        String scriptName = this.readString(data, "scriptName");
        String defs = this.readString(data, "defs");
        if (scriptName == null || defs == null) {
            return;
        }
        long uuidMost = data.readLong();
        long uuidLeast = data.readLong();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            ScriptTag script;
            PlayerTag linkedPlayer = null;
            if (uuidMost != 0L || uuidLeast != 0L) {
                UUID uuid = new UUID(uuidMost, uuidLeast);
                linkedPlayer = new PlayerTag(Bukkit.getOfflinePlayer((UUID)uuid));
            }
            String scrName = scriptName;
            String path = null;
            int dotIndex = scrName.indexOf(46);
            if (dotIndex != -1) {
                path = scrName.substring(dotIndex + 1);
                scrName = scrName.substring(0, dotIndex);
            }
            if ((script = ScriptTag.valueOf((String)scrName, (TagContext)CoreUtilities.basicContext)) == null) {
                Debug.echoError((String)("Invalid Depenizen bungeerun script '" + scrName + "': script does not exist."));
                return;
            }
            if (!(script.getContainer() instanceof TaskScriptContainer)) {
                Debug.echoError((String)("Invalid Depenizen bungeerun script '" + scrName + "': script is not a 'task' script."));
                return;
            }
            BukkitTagContext context = new BukkitTagContext(linkedPlayer, null, script);
            ScriptUtilities.createAndStartQueue((ScriptContainer)script.getContainer(), (String)path, (ScriptEntryData)new BukkitScriptEntryData(linkedPlayer, null), null, null, null, (String)("BUNGEERUN_" + scrName), (ListTag)ListTag.valueOf((String)defs, (TagContext)context), (Debuggable)script.getContainer());
        });
    }
}

