/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.bungee;

import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ExecuteCommandPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ExecutePlayerCommandPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.KeepAlivePacketOut;

public class BungeeExecuteCommand
extends AbstractCommand {
    public BungeeExecuteCommand() {
        this.setName("bungeeexecute");
        this.setSyntax("bungeeexecute [<command>] (as:<player>)");
        this.setRequiredArguments(1, 2);
        this.autoCompile();
    }

    public static void autoExecute(@ArgLinear @ArgName(value="command") String command, @ArgPrefixed @ArgName(value="as") @ArgDefaultNull String asPlayer) {
        BungeePacketOut packet;
        if (!BungeeBridge.instance.connected) {
            Debug.echoError((String)"Cannot BungeeExecute: bungee is not connected!");
            return;
        }
        if (asPlayer == null || asPlayer.length() == 0) {
            packet = new ExecuteCommandPacketOut(command);
        } else {
            if (asPlayer.startsWith("p@")) {
                asPlayer = asPlayer.substring("p@".length());
            }
            if (asPlayer.length() != 36) {
                Debug.echoError((String)("Invalid UUID '" + asPlayer + "'!"));
                return;
            }
            packet = new ExecutePlayerCommandPacketOut(asPlayer, command);
        }
        BungeeBridge.instance.sendPacket(packet);
        BungeeBridge.instance.sendPacket(new KeepAlivePacketOut());
    }
}

