/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.mythicmobs;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bridges.MythicMobsBridge;
import com.denizenscript.depenizen.bukkit.objects.mythicmobs.MythicMobsMobTag;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class MythicSpawnCommand
extends AbstractCommand {
    public MythicSpawnCommand() {
        this.setName("mythicspawn");
        this.setSyntax("mythicspawn [<name>] [<location>] (level:<#>)");
        this.setRequiredArguments(2, 3);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", (Object)arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("level") && arg.matchesPrefix(new String[]{"level", "l"}) && arg.matchesInteger()) {
                scriptEntry.addObject("level", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("name")) {
                scriptEntry.addObject("name", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location") || !scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException("Must specify a name and location.");
        }
        scriptEntry.defaultObject("level", new Object[]{new ElementTag(1)});
    }

    public void execute(ScriptEntry scriptEntry) {
        ElementTag name = scriptEntry.getElement("name");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag level = scriptEntry.getElement("level");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{name, location, level});
        }
        try {
            MythicMob mob = MythicMobsBridge.getMythicMob(name.asString());
            if (mob == null) {
                Debug.echoError((String)("MythicMob does not exist: " + name.asString()));
                return;
            }
            Entity entity = mob.spawn(BukkitAdapter.adapt((Location)location), level.asDouble()).getEntity().getBukkitEntity();
            scriptEntry.saveObject("spawned_mythicmob", (ObjectTag)new MythicMobsMobTag(MythicMobsBridge.getActiveMob(entity)));
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
    }
}

