/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.worldguard;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import com.denizenscript.depenizen.bukkit.bridges.WorldGuardBridge;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionType;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WorldGuardRegionTag
implements ObjectTag {
    String regionId;
    World world;
    private String prefix = "Region";
    public static Warning oldCuboidTag = new SlowWarning("worldguardregionCuboid", "The tag 'WorldGuardRegionTag.cuboid' is deprecated in favor of the '.area' equivalent.");
    public static ObjectTagProcessor<WorldGuardRegionTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="region")
    public static WorldGuardRegionTag valueOf(String string, TagContext context) {
        int lastComma;
        if (string == null) {
            return null;
        }
        if (string.startsWith("region@")) {
            string = string.substring("region@".length());
        }
        if ((lastComma = string.lastIndexOf(44)) == -1) {
            return null;
        }
        String regionId = string.substring(0, lastComma);
        String worldName = string.substring(lastComma + 1);
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf WorldGuardRegionTag returning null: Invalid world '" + worldName + "'."));
            }
            return null;
        }
        if (!WorldGuardBridge.getManager(world).hasRegion(regionId)) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf WorldGuardRegionTag returning null: Invalid region '" + regionId + "' for world '" + worldName + "'."));
            }
            return null;
        }
        return new WorldGuardRegionTag(regionId, world);
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("region@")) {
            return true;
        }
        return WorldGuardRegionTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public WorldGuardRegionTag(ProtectedRegion region, World world) {
        this(region.getId(), world);
    }

    public WorldGuardRegionTag(String regionId, World world) {
        this.regionId = regionId;
        this.world = world;
    }

    public ProtectedRegion getRegion() {
        return WorldGuardBridge.getManager(this.world).getRegion(this.regionId);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "region@" + this.regionId + "," + this.world.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void register() {
        tagProcessor.registerTag(ObjectTag.class, "area", (attribute, object) -> {
            ProtectedRegion region = object.getRegion();
            if (region.getType() == RegionType.POLYGON) {
                ProtectedPolygonalRegion polyRegion = (ProtectedPolygonalRegion)region;
                PolygonTag poly = new PolygonTag(new WorldTag(object.world));
                for (BlockVector2 corner : polyRegion.getPoints()) {
                    poly.corners.add(new PolygonTag.Corner((double)corner.getX(), (double)corner.getZ()));
                }
                poly.yMin = polyRegion.getMinimumPoint().getY();
                poly.yMax = polyRegion.getMaximumPoint().getY();
                poly.recalculateBox();
                return poly;
            }
            return new CuboidTag(BukkitAdapter.adapt((World)object.world, (BlockVector3)region.getMinimumPoint()), BukkitAdapter.adapt((World)object.world, (BlockVector3)region.getMaximumPoint()));
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "cuboid", (attribute, object) -> {
            oldCuboidTag.warn(attribute.context);
            ProtectedRegion region = object.getRegion();
            if (region.getType() != RegionType.CUBOID) {
                attribute.echoError("<WorldGuardRegionTag.cuboid> requires a Cuboid-shaped region!");
                return null;
            }
            return new CuboidTag(BukkitAdapter.adapt((World)object.world, (BlockVector3)region.getMinimumPoint()), BukkitAdapter.adapt((World)object.world, (BlockVector3)region.getMaximumPoint()));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "id", (attribute, object) -> new ElementTag(object.regionId), new String[0]);
        tagProcessor.registerTag(WorldGuardRegionTag.class, "parent", (attribute, object) -> {
            ProtectedRegion parent = object.getRegion().getParent();
            return parent != null ? new WorldGuardRegionTag(parent, object.world) : null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "children", (attribute, object) -> {
            ListTag children = new ListTag();
            ProtectedRegion region = object.getRegion();
            for (ProtectedRegion child : WorldGuardBridge.getManager(object.world).getRegions().values()) {
                if (child.getParent() != region) continue;
                children.addObject((ObjectTag)new WorldGuardRegionTag(child, object.world));
            }
            return children;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "members", (attribute, object) -> {
            ListTag members = new ListTag();
            for (UUID member : object.getRegion().getMembers().getUniqueIds()) {
                members.addObject((ObjectTag)new PlayerTag(member));
            }
            return members;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "owners", (attribute, object) -> {
            ListTag owners = new ListTag();
            for (UUID owner : object.getRegion().getOwners().getUniqueIds()) {
                owners.addObject((ObjectTag)new PlayerTag(owner));
            }
            return owners;
        }, new String[0]);
        tagProcessor.registerTag(WorldTag.class, "world", (attribute, object) -> new WorldTag(object.world), new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }
}

