/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.shopkeepers;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.ShopkeepersBridge;
import com.nisovin.shopkeepers.api.ShopkeepersAPI;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import com.nisovin.shopkeepers.api.shopkeeper.player.PlayerShopkeeper;
import com.nisovin.shopkeepers.api.shopobjects.ShopObject;
import com.nisovin.shopkeepers.api.shopobjects.entity.EntityShopObject;
import com.nisovin.shopkeepers.api.ui.UISession;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.entity.Entity;

public class ShopKeeperTag
implements ObjectTag {
    Shopkeeper shopkeeper;
    public static final ObjectTagProcessor<ShopKeeperTag> tagProcessor = new ObjectTagProcessor();
    private String prefix;

    @Fetchable(value="shopkeeper")
    public static ShopKeeperTag valueOf(String string, TagContext context) {
        if (string.startsWith("shopkeeper@")) {
            string = string.substring("shopkeeper@".length());
        }
        try {
            UUID uuid = UUID.fromString(string);
            Shopkeeper keeper = ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperByUniqueId(uuid);
            if (keeper == null) {
                if (context == null || context.showErrors()) {
                    Debug.echoError((String)("valueOf ShopKeeperTag returning null: UUID '" + string + "' is valid, but doesn't match any shopkeeper."));
                }
                return null;
            }
            return new ShopKeeperTag(keeper);
        }
        catch (IllegalArgumentException e) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf ShopKeeperTag returning null: Invalid UUID '" + string + "' specified."));
            }
            return null;
        }
    }

    public static boolean matches(String string) {
        if (string.startsWith("shopkeeper@")) {
            return true;
        }
        return ShopKeeperTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public static boolean isShopKeeper(EntityTag entity) {
        return entity != null && ShopkeepersAPI.getShopkeeperRegistry().isShopkeeper(entity.getBukkitEntity());
    }

    public static ShopKeeperTag fromEntity(EntityTag entity) {
        if (entity == null) {
            return null;
        }
        Shopkeeper shopkeeper = ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperByEntity(entity.getBukkitEntity());
        return shopkeeper != null ? new ShopKeeperTag(shopkeeper) : null;
    }

    public ShopKeeperTag(Shopkeeper shopkeeper) {
        if (shopkeeper != null) {
            this.shopkeeper = shopkeeper;
        } else {
            Debug.echoError((String)"Shopkeeper referenced is null!");
        }
    }

    public Shopkeeper getShopkeeper() {
        return this.shopkeeper;
    }

    public EntityTag getDenizenEntity() {
        Entity entity = this.getBukkitEntity();
        return entity != null ? new EntityTag(entity) : null;
    }

    public Entity getBukkitEntity() {
        Entity entity;
        ShopObject shopObject = this.shopkeeper.getShopObject();
        if (shopObject instanceof EntityShopObject) {
            EntityShopObject entityShopObject = (EntityShopObject)shopObject;
            entity = entityShopObject.getEntity();
        } else {
            entity = null;
        }
        return entity;
    }

    public static void register() {
        tagProcessor.registerTag(ElementTag.class, "is_active", (attribute, object) -> new ElementTag(object.shopkeeper.getShopObject().isActive()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_ui_active", (attribute, object) -> new ElementTag(object.shopkeeper.getUISessions().stream().anyMatch(UISession::isUIActive)), new String[0]);
        tagProcessor.registerTag(ListTag.class, "trades", (attribute, object) -> new ListTag((Collection)object.shopkeeper.getTradingRecipes(null), ShopkeepersBridge::tradingRecipeToList), new String[]{"recipes"});
        tagProcessor.registerTag(EntityTag.class, "entity", (attribute, object) -> object.getDenizenEntity(), new String[0]);
        tagProcessor.registerTag(PlayerTag.class, "owner", (attribute, object) -> {
            PlayerTag playerTag;
            Shopkeeper patt0$temp = object.shopkeeper;
            if (patt0$temp instanceof PlayerShopkeeper) {
                PlayerShopkeeper playerShopkeeper = (PlayerShopkeeper)patt0$temp;
                playerTag = new PlayerTag(playerShopkeeper.getOwnerUUID());
            } else {
                playerTag = null;
            }
            return playerTag;
        }, new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public Shopkeeper getJavaObject() {
        return this.shopkeeper;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "shopkeeper@" + String.valueOf(this.shopkeeper.getUniqueId());
    }

    public String debuggable() {
        return "<LG>shopkeeper@<Y>" + String.valueOf(this.shopkeeper.getUniqueId());
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

