/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.coreprotect;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.depenizen.bukkit.bridges.CoreProtectBridge;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.Location;

public class CoreProtectLocationProperties
implements Property {
    public static final String[] handledMechs = new String[]{"coreprotect_log_placement", "coreprotect_log_removal", "coreprotect_log_interaction"};
    public LocationTag location;

    public static boolean describes(ObjectTag object) {
        return object instanceof LocationTag;
    }

    public static CoreProtectLocationProperties getFrom(ObjectTag object) {
        if (!CoreProtectLocationProperties.describes(object)) {
            return null;
        }
        return new CoreProtectLocationProperties((LocationTag)object);
    }

    public CoreProtectLocationProperties(LocationTag location) {
        this.location = location;
    }

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "CoreProtectLocation";
    }

    public static void register() {
        PropertyParser.registerTag(CoreProtectLocationProperties.class, ListTag.class, (String)"coreprotect_logs", (attribute, property) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            DurationTag duration = (DurationTag)attribute.paramAsType(DurationTag.class);
            if (duration == null) {
                attribute.echoError("Invalid duration.");
                return null;
            }
            ListTag logs = new ListTag();
            for (String[] logEntry : CoreProtectBridge.apiInstance.blockLookup(property.location.getBlock(), duration.getSecondsAsInt())) {
                CoreProtectAPI.ParseResult parsed = CoreProtectBridge.apiInstance.parseResult(logEntry);
                MapTag entry = new MapTag();
                entry.putObject("action", (ObjectTag)new ElementTag(parsed.getActionString(), true));
                entry.putObject("is_rolled_back", (ObjectTag)new ElementTag(parsed.isRolledBack()));
                entry.putObject("material", (ObjectTag)(parsed.getBlockData() == null ? new MaterialTag(parsed.getType()) : new MaterialTag(parsed.getBlockData())));
                entry.putObject("player_name", (ObjectTag)new ElementTag(parsed.getPlayer()));
                entry.putObject("time", (ObjectTag)new TimeTag(parsed.getTimestamp()));
                logs.addObject((ObjectTag)entry);
            }
            return logs;
        }, (String[])new String[0]);
    }

    public void adjust(Mechanism mechanism) {
        MaterialTag material;
        ElementTag user;
        MapTag map;
        if (mechanism.matches("coreprotect_log_placement") && mechanism.requireObject(MapTag.class)) {
            map = (MapTag)mechanism.valueAsType(MapTag.class);
            user = map.getElement("user");
            material = (MaterialTag)map.getObjectAs("material", MaterialTag.class, mechanism.context);
            if (user == null) {
                mechanism.echoError("Missing required input, check meta docs.");
                return;
            }
            if (material == null || !material.getMaterial().isBlock()) {
                mechanism.echoError("Invalid block material input.");
                return;
            }
            CoreProtectBridge.apiInstance.logPlacement(user.asString(), (Location)this.location.clone(), material.getMaterial(), material.getModernData());
        }
        if (mechanism.matches("coreprotect_log_removal") && mechanism.requireObject(MapTag.class)) {
            map = (MapTag)mechanism.valueAsType(MapTag.class);
            user = map.getElement("user");
            material = (MaterialTag)map.getObjectAs("material", MaterialTag.class, mechanism.context);
            if (user == null) {
                mechanism.echoError("Missing required input, check meta docs.");
                return;
            }
            if (material == null || !material.getMaterial().isBlock()) {
                mechanism.echoError("Invalid block material input.");
                return;
            }
            CoreProtectBridge.apiInstance.logRemoval(user.asString(), (Location)this.location.clone(), material.getMaterial(), material.getModernData());
        }
        if (mechanism.matches("coreprotect_log_interaction") && mechanism.hasValue()) {
            CoreProtectBridge.apiInstance.logInteraction(mechanism.getValue().asString(), (Location)this.location.clone());
        }
    }
}

