/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.jobs;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.JobsBridge;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import java.util.Collection;
import java.util.UUID;

public class JobsJobTag
implements ObjectTag,
Adjustable {
    Job job;
    JobProgression jobProgression = null;
    JobsPlayer jobOwner = null;
    public static ObjectTagProcessor<JobsJobTag> tagProcessor = new ObjectTagProcessor();
    private String prefix = "Job";

    @Fetchable(value="job")
    public static JobsJobTag valueOf(String string, TagContext context) {
        Job job;
        if (string.startsWith("job@")) {
            string = string.substring("job@".length());
        }
        int comma = string.indexOf(44);
        UUID playerUUID = null;
        if (comma > 0) {
            try {
                playerUUID = UUID.fromString(string.substring(0, comma));
                string = string.substring(comma + 1);
            }
            catch (IllegalArgumentException iae) {
                if (context == null || context.showErrors()) {
                    Debug.echoError((String)("valueOf JobsJobTag returning null: Invalid UUID '" + string.substring(0, comma) + "' specified."));
                }
                return null;
            }
        }
        if ((job = Jobs.getJob((String)string)) == null) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf JobsJobTag returning null: Invalid job '" + string + "' specified."));
            }
            return null;
        }
        JobsJobTag jobTag = new JobsJobTag(job);
        if (playerUUID != null) {
            jobTag.setOwner(playerUUID);
            if (!jobTag.hasOwner()) {
                Debug.echoError((String)"Player specified in JobsJobTag is not valid");
            }
        }
        return jobTag;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("job@")) {
            return true;
        }
        return JobsJobTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public JobsJobTag(Job job) {
        this.job = job;
    }

    public JobsJobTag(Job job, JobsPlayer jobOwner) {
        this.job = job;
        this.jobProgression = jobOwner.getJobProgression(job);
        this.jobOwner = jobOwner;
    }

    public Job getJob() {
        return this.job;
    }

    public JobsJobTag setJobProgression(JobProgression jobProgression) {
        this.jobProgression = jobProgression;
        return this;
    }

    public boolean hasOwner() {
        return this.jobOwner != null;
    }

    public UUID getOwner() {
        if (this.jobOwner == null) {
            return null;
        }
        return this.jobOwner.getUniqueId();
    }

    public void setOwner(UUID playerUUID) {
        this.jobOwner = Jobs.getPlayerManager().getJobsPlayer(playerUUID);
        if (this.jobOwner == null) {
            return;
        }
        this.jobProgression = this.jobOwner.getJobProgression(this.job);
    }

    public static void register() {
        tagProcessor.registerTag(ElementTag.class, "description", (attribute, object) -> {
            JobsBridge.jobsSingleLineDescription.warn(attribute.context);
            return new ElementTag(object.getJob().getDescription(), true);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "full_description", (attribute, object) -> new ListTag((Collection)object.getJob().getFullDescription(), true), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> {
            if (attribute.startsWith("short", 2)) {
                JobsBridge.jobsNameShort.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getJob().getShortName(), true);
            }
            return new ElementTag(object.getJob().getName(), true);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "short_name", (attribute, object) -> new ElementTag(object.getJob().getShortName(), true), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "xp", (attribute, object) -> {
            if (object.jobProgression == null) {
                return null;
            }
            if (attribute.startsWith("max", 2)) {
                JobsBridge.jobsXpMax.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.jobProgression.getMaxExperience());
            }
            if (attribute.startsWith("level", 2)) {
                JobsBridge.jobsXpLevel.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.jobProgression.getLevel());
            }
            return new ElementTag(object.jobProgression.getExperience());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "level", (attribute, object) -> object.jobProgression != null ? new ElementTag(object.jobProgression.getLevel()) : null, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "max_xp", (attribute, object) -> {
            if (object.jobProgression == null) {
                return null;
            }
            if (attribute.hasParam()) {
                return new ElementTag(object.jobProgression.getMaxExperience(attribute.getIntParam()));
            }
            return new ElementTag(object.jobProgression.getMaxExperience());
        }, new String[0]);
        tagProcessor.registerTag(PlayerTag.class, "player", (attribute, object) -> {
            UUID ownerUUID = object.getOwner();
            return ownerUUID != null ? new PlayerTag(ownerUUID) : null;
        }, new String[0]);
        tagProcessor.registerMechanism("xp", false, ElementTag.class, (object, mechanism, input) -> {
            if (!mechanism.requireDouble()) {
                return;
            }
            if (object.jobProgression == null) {
                mechanism.echoError("This mechanism requires the object to be linked to a player.");
                return;
            }
            object.jobProgression.setExperience(input.asDouble());
        }, new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism((ObjectTag)this, mechanism);
    }

    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply Properties to a Jobs Job!");
    }

    public String identify() {
        return this.identify("job@", ",");
    }

    public String debuggable() {
        return this.identify("<LG>job@<Y>", "<LG>,<Y>");
    }

    public String identify(String prefix, String separator) {
        if (this.jobOwner != null) {
            return prefix + String.valueOf(this.jobOwner.getUniqueId()) + separator + this.job.getName();
        }
        return prefix + this.job.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public boolean advancedMatches(String matcher) {
        String lowerMatcher = CoreUtilities.toLowerCase((String)matcher);
        if (lowerMatcher.equals("job")) {
            return true;
        }
        return ScriptEvent.createMatcher((String)lowerMatcher).doesMatch(this.getJob().getName());
    }

    public boolean isUnique() {
        return true;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

