/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class Controllable
extends Trait
implements Toggleable {
    private boolean enabled;
    private static final double AIR_SPEED = 1.5;
    private static final double GROUND_SPEED = 4.0;
    private static final double JUMP_VELOCITY = 0.6;

    public Controllable() {
        super("controllable");
    }

    private EntityLiving getHandle() {
        return ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle();
    }

    private void jump() {
        boolean allowed = this.getHandle().onGround;
        if (!allowed) {
            return;
        }
        this.getHandle().motY = 0.6;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.enabled = key.getBoolean("");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)event.getPlayer()).getHandle();
        Action performed = event.getAction();
        if (performed == Action.PHYSICAL || !handle.equals((Object)this.getHandle().passenger)) {
            return;
        }
        if (performed == Action.LEFT_CLICK_AIR || performed == Action.LEFT_CLICK_BLOCK) {
            this.jump();
        }
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        if (!(this.enabled && this.npc.isSpawned() && event.getNPC().equals(this.npc))) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)event.getClicker()).getHandle();
        if (this.getHandle().passenger != null) {
            if (this.getHandle().passenger == handle) {
                event.getClicker().leaveVehicle();
            }
            return;
        }
        handle.setPassengerOf((Entity)this.getHandle());
    }

    @Override
    public void run() {
        if (!this.enabled || !this.npc.isSpawned() || this.getHandle().passenger == null) {
            return;
        }
        EntityLiving handle = this.getHandle();
        boolean onGround = handle.onGround;
        handle.motX = handle.motX + handle.passenger.motX * (onGround ? 4.0 : 1.5);
        handle.motZ = handle.motZ + handle.passenger.motZ * (onGround ? 4.0 : 1.5);
        handle.e(this.npc.getNavigator().getSpeed());
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("enabled", this.enabled);
    }

    @Override
    public boolean toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (!this.enabled && this.getHandle().passenger != null) {
            this.getHandle().passenger.getBukkitEntity().leaveVehicle();
        }
        return this.enabled;
    }
}

