/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;

public class Age
extends Trait
implements Toggleable {
    private int age = 0;
    private boolean ageable = false;
    private boolean locked = true;

    public Age() {
        super("age");
    }

    public void describe(CommandSender sender) {
        Messaging.sendF(sender, "%s's age is %s and %s locked.", StringHelper.wrap(this.npc.getName()), StringHelper.wrap(this.age), StringHelper.wrap(this.locked ? "is" : "isn't"));
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (this.npc.isSpawned() && !(this.npc.getBukkitEntity() instanceof Ageable)) {
            throw new NPCLoadException("NPC must be ageable");
        }
        this.age = key.getInt("age");
        this.locked = key.getBoolean("locked");
    }

    @Override
    public void onSpawn() {
        if (this.npc instanceof Ageable) {
            Ageable entity = (Ageable)this.npc.getBukkitEntity();
            entity.setAge(this.age);
            entity.setAgeLock(this.locked);
            this.ageable = true;
        } else {
            this.ageable = false;
        }
    }

    @Override
    public void run() {
        if (!this.locked && this.ageable) {
            this.age = ((Ageable)this.npc.getBukkitEntity()).getAge();
        }
    }

    @Override
    public void save(DataKey key) {
        key.setInt("age", this.age);
        key.setBoolean("locked", this.locked);
    }

    public void setAge(int age) {
        this.age = age;
        if (this.ageable) {
            ((Ageable)this.npc.getBukkitEntity()).setAge(age);
        }
    }

    @Override
    public boolean toggle() {
        boolean bl = this.locked = !this.locked;
        if (this.ageable) {
            ((Ageable)this.npc.getBukkitEntity()).setAgeLock(this.locked);
        }
        return this.locked;
    }

    public String toString() {
        return "Age{age=" + this.age + ",locked=" + this.locked + "}";
    }
}

