/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Navigation;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet18ArmAnimation;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;

public class MCTargetStrategy
implements PathStrategy,
EntityTarget {
    private final boolean aggro;
    private int attackTicks;
    private CancelReason cancelReason;
    private final EntityLiving handle;
    private final EntityLiving target;
    private final Navigation navigation;
    private final NavigatorParameters parameters;
    private static final int ATTACK_DELAY_TICKS = 20;
    private static final double ATTACK_DISTANCE = 3.0625;

    public MCTargetStrategy(CitizensNPC handle, LivingEntity target, boolean aggro, NavigatorParameters params) {
        this.handle = handle.getHandle();
        this.target = ((CraftLivingEntity)target).getHandle();
        this.navigation = this.handle.getNavigation();
        this.aggro = aggro;
        this.parameters = params;
        this.navigation.a(this.parameters.avoidWater());
    }

    private boolean canAttack() {
        return this.attackTicks == 0 && this.handle.boundingBox.e > this.target.boundingBox.b && this.handle.boundingBox.b < this.target.boundingBox.e && this.distanceSquared() <= 3.0625 && this.handle.l((Entity)this.target);
    }

    private double distanceSquared() {
        return this.handle.getBukkitEntity().getLocation().distanceSquared(this.target.getBukkitEntity().getLocation());
    }

    @Override
    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    public LivingEntity getTarget() {
        return (LivingEntity)this.target.getBukkitEntity();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.getTarget().getLocation();
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.ENTITY;
    }

    public boolean isAggressive() {
        return this.aggro;
    }

    @Override
    public void stop() {
        this.navigation.g();
    }

    @Override
    public boolean update() {
        if (this.target == null) {
            return true;
        }
        if (this.target.dead) {
            this.cancelReason = CancelReason.TARGET_DIED;
            return true;
        }
        this.navigation.a(this.target, this.parameters.speed());
        this.handle.getControllerLook().a((Entity)this.target, 10.0f, (float)this.handle.bf());
        if (this.aggro && this.canAttack()) {
            if (this.handle instanceof EntityMonster) {
                ((EntityMonster)this.handle).k((Entity)this.target);
            } else if (this.handle instanceof EntityPlayer) {
                EntityPlayer humanHandle = (EntityPlayer)this.handle;
                humanHandle.attack((Entity)this.target);
                Util.sendPacketNearby(this.handle.getBukkitEntity().getLocation(), (Packet)new Packet18ArmAnimation((Entity)humanHandle, 1), 64.0);
            }
            this.attackTicks = 20;
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        return false;
    }
}

