/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import net.citizensnpcs.trait.text.StartPrompt;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;

public class PageChangePrompt
extends NumericPrompt {
    private Text text;

    public PageChangePrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptValidatedInput(ConversationContext context, Number input) {
        Player player = (Player)context.getForWhom();
        if (!this.text.sendPage(player, input.intValue())) {
            Messaging.sendError((CommandSender)player, "Invalid page number.");
            return new StartPrompt(this.text);
        }
        return (Prompt)context.getSessionData((Object)"previous");
    }

    public String getFailedValidationText(ConversationContext context, String input) {
        return ChatColor.RED + "Invalid page number.";
    }

    public String getPromptText(ConversationContext context) {
        return StringHelper.parseColors("<a>Enter a page number to view more text entries.");
    }
}

