/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import net.citizensnpcs.EventListen;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public abstract class CitizensNPC
extends AbstractNPC {
    protected EntityLiving mcEntity;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private static final String NPC_METADATA_MARKER = "NPC";

    protected CitizensNPC(int id, String name) {
        super(id, name);
    }

    protected abstract EntityLiving createHandle(Location var1);

    @Override
    public boolean despawn() {
        if (!this.isSpawned()) {
            Messaging.debug(String.format("The NPC with the ID '%d' is already despawned.", this.getId()));
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCDespawnEvent(this));
        boolean keepSelected = this.getTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        this.getBukkitEntity().remove();
        this.mcEntity = null;
        return true;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        if (this.getHandle() == null) {
            return null;
        }
        return (LivingEntity)this.getHandle().getBukkitEntity();
    }

    public EntityLiving getHandle() {
        return this.mcEntity;
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public Trait getTraitFor(Class<? extends Trait> clazz) {
        return CitizensAPI.getTraitFactory().getTrait(clazz);
    }

    @Override
    public boolean isSpawned() {
        return this.getHandle() != null;
    }

    public void load(DataKey root) {
        Location spawnLoc;
        this.metadata.loadFrom(root.getRelative("metadata"));
        for (DataKey traitKey : root.getRelative("traits").getSubKeys()) {
            Trait trait;
            if (traitKey.keyExists("enabled") && !traitKey.getBoolean("enabled")) continue;
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
            if (this.hasTrait(clazz)) {
                trait = this.getTrait(clazz);
            } else {
                trait = CitizensAPI.getTraitFactory().getTrait(traitKey.name());
                if (trait == null) {
                    Messaging.severeF("Skipped broken or missing trait '%s' while loading ID '%d'. Has the name changed?", traitKey.name(), this.getId());
                    continue;
                }
                this.addTrait(trait);
            }
            try {
                trait.load(traitKey);
            }
            catch (NPCLoadException ex) {
                Messaging.logF("The trait '%s' failed to load for NPC ID: '%d'.", traitKey.name(), this.getId(), ex.getMessage());
            }
        }
        if (this.getTrait(Spawned.class).shouldSpawn() && (spawnLoc = this.getTrait(CurrentLocation.class).getLocation()) != null) {
            this.spawn(spawnLoc);
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    public void save(DataKey root) {
        root.setString("name", this.getFullName());
        this.metadata.saveTo(root.getRelative("metadata"));
        this.navigator.save(root.getRelative("navigator"));
        for (Trait trait : this.traits.values()) {
            trait.save(root.getRelative("traits." + trait.getName()));
        }
    }

    @Override
    public boolean spawn(Location loc) {
        Validate.notNull((Object)loc, (String)"location cannot be null");
        if (this.isSpawned()) {
            Messaging.debug("NPC (ID: " + this.getId() + ") is already spawned.");
            return false;
        }
        this.mcEntity = this.createHandle(loc);
        boolean couldSpawn = this.mcEntity.world.addEntity((Entity)this.mcEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        if (!couldSpawn) {
            this.mcEntity = null;
            EventListen.add(loc, this.getId());
            return true;
        }
        if (this.mcEntity instanceof EntityPlayer && Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()) {
            this.mcEntity.world.players.remove(this.mcEntity);
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, loc);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            this.mcEntity = null;
            return false;
        }
        this.getBukkitEntity().setMetadata(NPC_METADATA_MARKER, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        this.getTrait(CurrentLocation.class).setLocation(loc);
        this.getTrait(Spawned.class).setSpawned(true);
        this.navigator.onSpawn();
        for (Trait trait : this.traits.values()) {
            trait.onSpawn();
        }
        return true;
    }

    @Override
    public void update() {
        try {
            super.update();
            if (this.isSpawned()) {
                this.navigator.update();
            }
        }
        catch (Exception ex) {
            Messaging.logF("Exception while updating %d: %s.", this.getId(), ex.getMessage());
            ex.printStackTrace();
        }
    }
}

