/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.Random;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class WanderingWaypointProvider
implements WaypointProvider {
    private WanderGoal currentGoal;
    private NPC npc;
    private boolean paused;
    private int xrange;
    private int yrange;
    private static final int DEFAULT_XRANGE = 3;
    private static final int DEFAULT_YRANGE = 25;

    @Override
    public Editor createEditor(Player player) {
        return new Editor(){

            @Override
            public void begin() {
            }

            @Override
            public void end() {
            }
        };
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey key) {
        this.xrange = key.getInt("xrange", 3);
        this.yrange = key.getInt("yrange", 25);
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new WanderGoal();
            CitizensAPI.registerEvents(this.currentGoal);
        }
        npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
    }

    @Override
    public void save(DataKey key) {
        key.setInt("xrange", this.xrange);
        key.setInt("yrange", this.yrange);
    }

    @Override
    public void setPaused(boolean paused) {
    }

    private class WanderGoal
    implements Goal {
        private final Random random = new Random();
        private GoalSelector selector;

        private WanderGoal() {
        }

        private Location findRandomPosition() {
            Location base = WanderingWaypointProvider.this.npc.getBukkitEntity().getLocation();
            Location found = null;
            int range = 50;
            int yrange = 3;
            for (int i = 0; i < 10; ++i) {
                int x = base.getBlockX() + this.random.nextInt(2 * range) - range;
                int y = base.getBlockY() + this.random.nextInt(2 * yrange) - yrange;
                int z = base.getBlockZ() + this.random.nextInt(2 * range) - range;
                Block block = base.getWorld().getBlockAt(x, y, z);
                if (!block.isEmpty() || !block.getRelative(BlockFace.DOWN).isEmpty()) continue;
                found = block.getLocation();
                break;
            }
            return found;
        }

        @EventHandler
        public void onFinish(NavigationCompleteEvent event) {
            if (this.selector != null) {
                this.selector.finish();
            }
        }

        @Override
        public void reset() {
            this.selector = null;
        }

        @Override
        public void run(GoalSelector selector) {
        }

        @Override
        public boolean shouldExecute(GoalSelector selector) {
            if (!WanderingWaypointProvider.this.npc.isSpawned() || WanderingWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return false;
            }
            Location dest = this.findRandomPosition();
            if (dest == null) {
                return false;
            }
            WanderingWaypointProvider.this.npc.getNavigator().setTarget(dest);
            this.selector = selector;
            return true;
        }
    }
}

