/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.trait.text.StartPrompt;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.Paginator;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Text
extends Trait
implements Runnable,
Toggleable,
Listener,
ConversationAbandonedListener {
    private final Map<String, Date> cooldowns = new HashMap<String, Date>();
    private int currentIndex;
    private final Plugin plugin;
    private boolean randomTalker = Settings.Setting.DEFAULT_RANDOM_TALKER.asBoolean();
    private double range = Settings.Setting.DEFAULT_TALK_CLOSE_RANGE.asDouble();
    private boolean realisticLooker = Settings.Setting.DEFAULT_REALISTIC_LOOKING.asBoolean();
    private boolean talkClose = Settings.Setting.DEFAULT_TALK_CLOSE.asBoolean();
    private final List<String> text = new ArrayList<String>();

    public Text() {
        super("text");
        this.plugin = CitizensAPI.getPlugin();
    }

    public void add(String string) {
        this.text.add(string);
    }

    public void conversationAbandoned(ConversationAbandonedEvent event) {
        Bukkit.dispatchCommand((CommandSender)((Player)event.getContext().getForWhom()), (String)"npc text");
    }

    public void edit(int index, String newText) {
        this.text.set(index, newText);
    }

    public Editor getEditor(final Player player) {
        final Conversation conversation = new ConversationFactory(this.plugin).addConversationAbandonedListener((ConversationAbandonedListener)this).withLocalEcho(false).withEscapeSequence("/npc text").withEscapeSequence("exit").withModality(false).withFirstPrompt((Prompt)new StartPrompt(this)).buildConversation((Conversable)player);
        return new Editor(){

            @Override
            public void begin() {
                Messaging.send((CommandSender)player, "<b>Entered the text editor!");
                conversation.begin();
            }

            @Override
            public void end() {
                Messaging.send((CommandSender)player, "<a>Exited the text editor.");
            }
        };
    }

    public boolean hasIndex(int index) {
        return index >= 0 && this.text.size() > index;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        for (DataKey sub : key.getIntegerSubKeys()) {
            this.text.add(sub.getString(""));
        }
        for (DataKey sub : key.getRelative("text").getIntegerSubKeys()) {
            this.text.add(sub.getString(""));
        }
        if (this.text.isEmpty()) {
            this.populateDefaultText();
        }
        this.talkClose = key.getBoolean("talk-close", this.talkClose);
        this.realisticLooker = key.getBoolean("realistic-looking", this.realisticLooker);
        this.randomTalker = key.getBoolean("random-talker", this.randomTalker);
        this.range = key.getDouble("range", this.range);
    }

    @Override
    public void onAttach() {
        if (this.text.isEmpty()) {
            this.populateDefaultText();
        }
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        if (!event.getNPC().equals(this.npc)) {
            return;
        }
        if (Util.isSettingFulfilled(event.getClicker(), Settings.Setting.TALK_ITEM) && !this.shouldTalkClose()) {
            this.sendText(event.getClicker());
        }
    }

    private void populateDefaultText() {
        this.text.addAll(Settings.Setting.DEFAULT_TEXT.asList());
    }

    public void remove(int index) {
        this.text.remove(index);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        EntityHuman search = null;
        EntityLiving handle = ((CitizensNPC)this.npc).getHandle();
        search = handle.world.findNearbyPlayer((Entity)handle, this.range);
        if (search != null && this.talkClose) {
            Player player = (Player)search.getBukkitEntity();
            if (this.cooldowns.get(player.getName()) != null) {
                if (!new Date().after(this.cooldowns.get(player.getName()))) {
                    return;
                }
                this.cooldowns.remove(player.getName());
            }
            if (this.sendText(player)) {
                Date wait = new Date();
                int secondsDelta = new Random().nextInt(Settings.Setting.TALK_CLOSE_MAXIMUM_COOLDOWN.asInt()) + Settings.Setting.TALK_CLOSE_MINIMUM_COOLDOWN.asInt();
                long millisecondsDelta = TimeUnit.MILLISECONDS.convert(secondsDelta, TimeUnit.SECONDS);
                wait.setTime(wait.getTime() + millisecondsDelta);
                this.cooldowns.put(player.getName(), wait);
            }
        }
    }

    @Override
    public void save(DataKey key) {
        int i;
        key.setBoolean("talk-close", this.talkClose);
        key.setBoolean("random-talker", this.randomTalker);
        key.setBoolean("realistic-looking", this.realisticLooker);
        key.setDouble("range", this.range);
        for (i = 0; i < 100; ++i) {
            key.removeKey(String.valueOf(i));
        }
        key.removeKey("text");
        for (i = 0; i < this.text.size(); ++i) {
            key.setString("text." + String.valueOf(i), this.text.get(i));
        }
    }

    public boolean sendPage(Player player, int page) {
        Paginator paginator = new Paginator().header(this.npc.getName() + "'s Text Entries");
        for (int i = 0; i < this.text.size(); ++i) {
            paginator.addLine("<a>" + i + " <7>- <e>" + this.text.get(i));
        }
        return paginator.sendPage((CommandSender)player, page);
    }

    public boolean sendText(Player player) {
        if (!player.hasPermission("citizens.admin") && !player.hasPermission("citizens.npc.talk")) {
            return false;
        }
        if (this.text.size() == 0) {
            return false;
        }
        int index = 0;
        if (this.randomTalker) {
            index = new Random().nextInt(this.text.size());
        } else {
            if (this.currentIndex > this.text.size() - 1) {
                this.currentIndex = 0;
            }
            index = this.currentIndex++;
        }
        Messaging.sendWithNPC((CommandSender)player, Settings.Setting.CHAT_PREFIX.asString() + this.text.get(index), this.npc);
        return true;
    }

    public boolean shouldTalkClose() {
        return this.talkClose;
    }

    @Override
    public boolean toggle() {
        this.talkClose = !this.talkClose;
        return this.talkClose;
    }

    public boolean toggleRandomTalker() {
        this.randomTalker = !this.randomTalker;
        return this.randomTalker;
    }

    public boolean toggleRealisticLooking() {
        this.realisticLooker = !this.realisticLooker;
        return this.realisticLooker;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Text{talk-close=" + this.talkClose + ",text=");
        for (String line : this.text) {
            builder.append(line + ",");
        }
        builder.append("}");
        return builder.toString();
    }
}

