/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Arg {
    public String[] completions() default {};

    public Class<? extends CompletionsProvider> completionsProvider() default CompletionsProvider.Identity.class;

    public String defValue() default "";

    public Class<? extends FlagValidator<?>> validator() default FlagValidator.Identity.class;

    public int value();

    public static interface FlagValidator<T> {
        public T validate(CommandContext var1, CommandSender var2, NPC var3, String var4) throws CommandException;

        public static class Identity
        implements FlagValidator<String> {
            @Override
            public String validate(CommandContext args, CommandSender sender, NPC npc, String input) throws CommandException {
                return input;
            }
        }
    }

    public static interface CompletionsProvider {
        public Collection<String> getCompletions(CommandContext var1, CommandSender var2, NPC var3);

        public static class OptionalKeyedCompletions
        implements CompletionsProvider {
            private Collection<String> completions = Collections.emptyList();

            public OptionalKeyedCompletions(String className) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (SpigotUtil.isRegistryKeyed(clazz)) {
                        Class<?> cast = clazz;
                        this.completions = Bukkit.getRegistry(cast).stream().map(k -> k.getKey().getKey()).collect(Collectors.toList());
                    } else {
                        Class<?> eclazz = clazz;
                        if (eclazz.getEnumConstants() != null) {
                            this.completions = Lists.transform(Arrays.asList((Enum[])eclazz.getEnumConstants()), Enum::name);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public Collection<String> getCompletions(CommandContext args, CommandSender sender, NPC npc) {
                return this.completions;
            }
        }

        public static class Identity
        implements CompletionsProvider {
            @Override
            public Collection<String> getCompletions(CommandContext args, CommandSender sender, NPC npc) {
                return Collections.emptyList();
            }
        }
    }
}

