/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PermissionAction
extends NPCShopAction {
    @Persist
    public List<String> permissions = Lists.newArrayList();

    public PermissionAction() {
    }

    public PermissionAction(List<String> permissions) {
        this.permissions = permissions;
    }

    @Override
    public String describe() {
        String description = this.permissions.size() + " permissions";
        for (int i = 0; i < this.permissions.size(); ++i) {
            description = description + "\n" + this.permissions.get(i);
            if (i != 3) continue;
            description = description + "...";
            break;
        }
        return description;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventory) {
        return -1;
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        Permission perm = (Permission)Bukkit.getServicesManager().getRegistration(Permission.class).getProvider();
        return NPCShopAction.Transaction.create(() -> true, () -> {
            for (String permission : this.permissions) {
                perm.playerAdd(null, (OfflinePlayer)player, Placeholders.replace(permission, (OfflinePlayer)player));
            }
        }, () -> {
            for (String permission : this.permissions) {
                perm.playerRemove(null, (OfflinePlayer)player, Placeholders.replace(permission, (OfflinePlayer)player));
            }
        });
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        Permission perm = (Permission)Bukkit.getServicesManager().getRegistration(Permission.class).getProvider();
        return NPCShopAction.Transaction.create(() -> {
            for (String permission : this.permissions) {
                if (perm.playerHas(player, Placeholders.replace(permission, (OfflinePlayer)player))) continue;
                return false;
            }
            return true;
        }, () -> {
            for (String permission : this.permissions) {
                perm.playerRemove(null, (OfflinePlayer)player, Placeholders.replace(permission, (OfflinePlayer)player));
            }
        }, () -> {
            for (String permission : this.permissions) {
                perm.playerAdd(null, (OfflinePlayer)player, Placeholders.replace(permission, (OfflinePlayer)player));
            }
        });
    }

    public static class PermissionActionGUI
    implements NPCShopAction.GUI {
        private Boolean supported;

        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            return new PermissionActionEditor(previous == null ? new PermissionAction() : (PermissionAction)previous, callback);
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            if (this.supported == null) {
                try {
                    this.supported = Bukkit.getServicesManager().getRegistration(Permission.class) != null && Bukkit.getServicesManager().getRegistration(Permission.class).getProvider() != null;
                }
                catch (Throwable t) {
                    this.supported = false;
                }
            }
            if (!this.supported.booleanValue()) {
                return null;
            }
            String description = null;
            if (previous != null) {
                PermissionAction old = (PermissionAction)previous;
                description = old.describe();
            }
            return Util.createItem(Material.PAPER, "Permission", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof PermissionAction;
        }
    }

    @Menu(title="Permissions editor", dimensions={3, 9})
    public static class PermissionActionEditor
    extends InventoryMenuPage {
        private PermissionAction base;
        private Consumer<NPCShopAction> callback;

        public PermissionActionEditor() {
        }

        public PermissionActionEditor(PermissionAction base, Consumer<NPCShopAction> callback) {
            this.base = base;
            this.callback = callback;
        }

        @Override
        public void initialise(MenuContext ctx) {
            for (int i = 0; i < 27; ++i) {
                int idx = i;
                ctx.getSlot(i).clear();
                if (i < this.base.permissions.size()) {
                    ctx.getSlot(i).setItemStack(new ItemStack(Material.FEATHER), "<f>Set permission", "Right click to remove\nCurrently: " + this.base.permissions.get(i));
                }
                ctx.getSlot(i).setClickHandler(event -> {
                    if (event.isRightClick()) {
                        event.setCancelled(true);
                        if (idx < this.base.permissions.size()) {
                            this.base.permissions.remove(idx);
                            ctx.getSlot(idx).setItemStack(null);
                        }
                        return;
                    }
                    ctx.getMenu().transition(InputMenus.stringSetter(() -> idx < this.base.permissions.size() ? this.base.permissions.get(idx) : "", res -> {
                        if (res == null) {
                            if (idx < this.base.permissions.size()) {
                                this.base.permissions.remove(idx);
                            }
                            return;
                        }
                        if (idx < this.base.permissions.size()) {
                            this.base.permissions.set(idx, (String)res);
                        } else {
                            this.base.permissions.add((String)res);
                        }
                    }));
                });
            }
        }

        @Override
        public void onClose(HumanEntity player) {
            this.callback.accept(this.base.permissions.isEmpty() ? null : this.base);
        }
    }
}

