/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.stream.Collectors;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.Template;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;

@Requirements(selected=true, ownership=true)
public class TemplateCommands {
    private final TemplateRegistry registry;

    public TemplateCommands(Citizens plugin) {
        this.registry = plugin.getTemplateRegistry();
    }

    @Command(aliases={"template", "tpl"}, usage="apply (template namespace:)[template name]", desc="", modifiers={"apply"}, min=2, permission="citizens.templates.apply")
    public void apply(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completionsProvider=TemplateCompletions.class) String templateKey) throws CommandException {
        Template template = null;
        if (templateKey.contains(":")) {
            template = this.registry.getTemplateByKey(SpigotUtil.getKey(templateKey));
        } else {
            Collection<Template> templates = this.registry.getTemplates(templateKey);
            if (templates.isEmpty()) {
                throw new CommandException("citizens.commands.template.missing");
            }
            if (templates.size() > 1) {
                throw new CommandException("citizens.commands.template.qualified-template-required", templateKey, Joiner.on((String)", ").join((Iterable)templates.stream().map(t -> t.getKey()).collect(Collectors.toList())));
            }
            template = templates.iterator().next();
        }
        if (template == null) {
            throw new CommandException("citizens.commands.template.missing");
        }
        template.apply(npc);
        Messaging.sendTr(sender, "citizens.commands.template.applied", template.getKey().getKey(), npc.getName());
    }

    @Command(aliases={"template", "tpl"}, usage="generate (template namespace:)[name]", desc="", modifiers={"generate"}, min=2, max=2, permission="citizens.templates.generate")
    public void generate(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completionsProvider=TemplateCompletions.class) String templateName) throws CommandException {
        NamespacedKey key = SpigotUtil.getKey(templateName, "generated");
        if (this.registry.getTemplateByKey(key) != null) {
            throw new CommandException("citizens.commands.template.conflict");
        }
        this.registry.generateTemplateFromNPC(key, npc);
        Messaging.sendTr(sender, "citizens.commands.template.generate.generated", npc.getName());
    }

    @Command(aliases={"template", "tpl"}, usage="list", desc="", modifiers={"list"}, min=1, max=1, permission="citizens.templates.list")
    public void list(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Messaging.sendTr(sender, "citizens.commands.template.list.header", new Object[0]);
        for (Template template : this.registry.getAllTemplates()) {
            Messaging.send(sender, "[[-]]    " + template.getKey());
        }
    }

    public static class TemplateCompletions
    implements Arg.CompletionsProvider {
        private final TemplateRegistry templateRegistry;

        public TemplateCompletions(Citizens plugin) {
            this.templateRegistry = plugin.getTemplateRegistry();
        }

        @Override
        public Collection<String> getCompletions(CommandContext args, CommandSender sender, NPC npc) {
            return this.templateRegistry.getAllTemplates().stream().map(t -> t.getKey().toString()).collect(Collectors.toList());
        }
    }
}

