/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R3.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.datafixers.util.Pair;
import com.mojang.util.UndashedUuid;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.pathfinder.DoorExaminer;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCMoveEvent;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R3.entity.AllayController;
import net.citizensnpcs.nms.v1_21_R3.entity.ArmadilloController;
import net.citizensnpcs.nms.v1_21_R3.entity.ArmorStandController;
import net.citizensnpcs.nms.v1_21_R3.entity.AxolotlController;
import net.citizensnpcs.nms.v1_21_R3.entity.BatController;
import net.citizensnpcs.nms.v1_21_R3.entity.BeeController;
import net.citizensnpcs.nms.v1_21_R3.entity.BlazeController;
import net.citizensnpcs.nms.v1_21_R3.entity.BoggedController;
import net.citizensnpcs.nms.v1_21_R3.entity.BreezeController;
import net.citizensnpcs.nms.v1_21_R3.entity.CamelController;
import net.citizensnpcs.nms.v1_21_R3.entity.CatController;
import net.citizensnpcs.nms.v1_21_R3.entity.CaveSpiderController;
import net.citizensnpcs.nms.v1_21_R3.entity.ChickenController;
import net.citizensnpcs.nms.v1_21_R3.entity.CodController;
import net.citizensnpcs.nms.v1_21_R3.entity.CowController;
import net.citizensnpcs.nms.v1_21_R3.entity.CreakingController;
import net.citizensnpcs.nms.v1_21_R3.entity.CreeperController;
import net.citizensnpcs.nms.v1_21_R3.entity.DolphinController;
import net.citizensnpcs.nms.v1_21_R3.entity.DrownedController;
import net.citizensnpcs.nms.v1_21_R3.entity.EnderDragonController;
import net.citizensnpcs.nms.v1_21_R3.entity.EndermanController;
import net.citizensnpcs.nms.v1_21_R3.entity.EndermiteController;
import net.citizensnpcs.nms.v1_21_R3.entity.EvokerController;
import net.citizensnpcs.nms.v1_21_R3.entity.FoxController;
import net.citizensnpcs.nms.v1_21_R3.entity.FrogController;
import net.citizensnpcs.nms.v1_21_R3.entity.GhastController;
import net.citizensnpcs.nms.v1_21_R3.entity.GiantController;
import net.citizensnpcs.nms.v1_21_R3.entity.GlowSquidController;
import net.citizensnpcs.nms.v1_21_R3.entity.GoatController;
import net.citizensnpcs.nms.v1_21_R3.entity.GuardianController;
import net.citizensnpcs.nms.v1_21_R3.entity.GuardianElderController;
import net.citizensnpcs.nms.v1_21_R3.entity.HoglinController;
import net.citizensnpcs.nms.v1_21_R3.entity.HorseController;
import net.citizensnpcs.nms.v1_21_R3.entity.HorseDonkeyController;
import net.citizensnpcs.nms.v1_21_R3.entity.HorseMuleController;
import net.citizensnpcs.nms.v1_21_R3.entity.HorseSkeletonController;
import net.citizensnpcs.nms.v1_21_R3.entity.HorseZombieController;
import net.citizensnpcs.nms.v1_21_R3.entity.HumanController;
import net.citizensnpcs.nms.v1_21_R3.entity.IllusionerController;
import net.citizensnpcs.nms.v1_21_R3.entity.IronGolemController;
import net.citizensnpcs.nms.v1_21_R3.entity.LlamaController;
import net.citizensnpcs.nms.v1_21_R3.entity.MagmaCubeController;
import net.citizensnpcs.nms.v1_21_R3.entity.MushroomCowController;
import net.citizensnpcs.nms.v1_21_R3.entity.OcelotController;
import net.citizensnpcs.nms.v1_21_R3.entity.PandaController;
import net.citizensnpcs.nms.v1_21_R3.entity.ParrotController;
import net.citizensnpcs.nms.v1_21_R3.entity.PhantomController;
import net.citizensnpcs.nms.v1_21_R3.entity.PigController;
import net.citizensnpcs.nms.v1_21_R3.entity.PigZombieController;
import net.citizensnpcs.nms.v1_21_R3.entity.PiglinBruteController;
import net.citizensnpcs.nms.v1_21_R3.entity.PiglinController;
import net.citizensnpcs.nms.v1_21_R3.entity.PillagerController;
import net.citizensnpcs.nms.v1_21_R3.entity.PolarBearController;
import net.citizensnpcs.nms.v1_21_R3.entity.PufferFishController;
import net.citizensnpcs.nms.v1_21_R3.entity.RabbitController;
import net.citizensnpcs.nms.v1_21_R3.entity.RavagerController;
import net.citizensnpcs.nms.v1_21_R3.entity.SalmonController;
import net.citizensnpcs.nms.v1_21_R3.entity.SheepController;
import net.citizensnpcs.nms.v1_21_R3.entity.ShulkerController;
import net.citizensnpcs.nms.v1_21_R3.entity.SilverfishController;
import net.citizensnpcs.nms.v1_21_R3.entity.SkeletonController;
import net.citizensnpcs.nms.v1_21_R3.entity.SkeletonStrayController;
import net.citizensnpcs.nms.v1_21_R3.entity.SkeletonWitherController;
import net.citizensnpcs.nms.v1_21_R3.entity.SlimeController;
import net.citizensnpcs.nms.v1_21_R3.entity.SnifferController;
import net.citizensnpcs.nms.v1_21_R3.entity.SnowmanController;
import net.citizensnpcs.nms.v1_21_R3.entity.SpiderController;
import net.citizensnpcs.nms.v1_21_R3.entity.SquidController;
import net.citizensnpcs.nms.v1_21_R3.entity.StriderController;
import net.citizensnpcs.nms.v1_21_R3.entity.TadpoleController;
import net.citizensnpcs.nms.v1_21_R3.entity.TraderLlamaController;
import net.citizensnpcs.nms.v1_21_R3.entity.TropicalFishController;
import net.citizensnpcs.nms.v1_21_R3.entity.TurtleController;
import net.citizensnpcs.nms.v1_21_R3.entity.VexController;
import net.citizensnpcs.nms.v1_21_R3.entity.VillagerController;
import net.citizensnpcs.nms.v1_21_R3.entity.VindicatorController;
import net.citizensnpcs.nms.v1_21_R3.entity.WanderingTraderController;
import net.citizensnpcs.nms.v1_21_R3.entity.WardenController;
import net.citizensnpcs.nms.v1_21_R3.entity.WitchController;
import net.citizensnpcs.nms.v1_21_R3.entity.WitherController;
import net.citizensnpcs.nms.v1_21_R3.entity.WolfController;
import net.citizensnpcs.nms.v1_21_R3.entity.ZoglinController;
import net.citizensnpcs.nms.v1_21_R3.entity.ZombieController;
import net.citizensnpcs.nms.v1_21_R3.entity.ZombieHuskController;
import net.citizensnpcs.nms.v1_21_R3.entity.ZombieVillagerController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.AreaEffectCloudController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.BlockDisplayController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.BoatController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.BreezeWindChargeController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ChestBoatController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ChestRaftController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.DragonFireballController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.EggController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.EnderCrystalController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.EnderPearlController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.EvokerFangsController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ExperienceOrbController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.EyeOfEnderController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.FallingBlockController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.FireworkController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.FishingHookController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.GlowItemFrameController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.InteractionController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ItemController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ItemDisplayController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.LargeFireballController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.LeashController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.LlamaSpitController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MarkerController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MinecartChestController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MinecartCommandController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MinecartFurnaceController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MinecartHopperController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MinecartRideableController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MinecartSpawnerController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.MinecartTNTController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.OminousItemSpawnerController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.PaintingController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.RaftController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ShulkerBulletController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.SmallFireballController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.SnowballController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.SpectralArrowController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.TNTPrimedController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.TextDisplayController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ThrownExpBottleController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ThrownPotionController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.ThrownTridentController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.TippedArrowController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.WindChargeController;
import net.citizensnpcs.nms.v1_21_R3.entity.nonliving.WitherSkullController;
import net.citizensnpcs.nms.v1_21_R3.util.CitizensBlockBreaker;
import net.citizensnpcs.nms.v1_21_R3.util.CitizensEntityTracker;
import net.citizensnpcs.nms.v1_21_R3.util.CustomEntityRegistry;
import net.citizensnpcs.nms.v1_21_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R3.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R3.util.MobAI;
import net.citizensnpcs.nms.v1_21_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R3.util.PlayerAnimationImpl;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.versioned.AllayTrait;
import net.citizensnpcs.trait.versioned.AreaEffectCloudTrait;
import net.citizensnpcs.trait.versioned.ArmadilloTrait;
import net.citizensnpcs.trait.versioned.AxolotlTrait;
import net.citizensnpcs.trait.versioned.BeeTrait;
import net.citizensnpcs.trait.versioned.BoatTrait;
import net.citizensnpcs.trait.versioned.BossBarTrait;
import net.citizensnpcs.trait.versioned.CamelTrait;
import net.citizensnpcs.trait.versioned.CatTrait;
import net.citizensnpcs.trait.versioned.DisplayTrait;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.trait.versioned.FoxTrait;
import net.citizensnpcs.trait.versioned.FrogTrait;
import net.citizensnpcs.trait.versioned.GoatTrait;
import net.citizensnpcs.trait.versioned.LlamaTrait;
import net.citizensnpcs.trait.versioned.MushroomCowTrait;
import net.citizensnpcs.trait.versioned.PandaTrait;
import net.citizensnpcs.trait.versioned.ParrotTrait;
import net.citizensnpcs.trait.versioned.PhantomTrait;
import net.citizensnpcs.trait.versioned.PiglinTrait;
import net.citizensnpcs.trait.versioned.PolarBearTrait;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.trait.versioned.ShulkerTrait;
import net.citizensnpcs.trait.versioned.SnifferTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.trait.versioned.SpellcasterTrait;
import net.citizensnpcs.trait.versioned.TextDisplayTrait;
import net.citizensnpcs.trait.versioned.TropicalFishTrait;
import net.citizensnpcs.trait.versioned.VillagerTrait;
import net.citizensnpcs.trait.versioned.WardenTrait;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.CraftSound;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_21_R3.inventory.view.CraftAnvilView;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMSImpl
implements NMSBridge {
    private static final MethodHandle ARMADILLO_SCUTE_TIME = NMS.getSetter(Armadillo.class, "cj");
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP = NMS.getFirstGetter(AttributeProvider.class, Map.class);
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP_SETTER = NMS.getFirstFinalSetter(AttributeProvider.class, Map.class);
    private static final MethodHandle ATTRIBUTE_SUPPLIER = NMS.getFirstGetter(AttributeMapBase.class, AttributeProvider.class);
    private static final MethodHandle AVAILABLE_BEHAVIORS_BY_PRIORITY = NMS.getGetter(BehaviorController.class, "f");
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.POLAR_BEAR, new EntityType[]{EntityType.BEE, EntityType.SILVERFISH, EntityType.SHULKER, EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.SLIME, EntityType.DOLPHIN, EntityType.MAGMA_CUBE, EntityType.HORSE, EntityType.GHAST, EntityType.SHULKER, EntityType.PHANTOM});
    private static final MethodHandle BUKKITENTITY_FIELD_SETTER = NMS.getSetter(net.minecraft.world.entity.Entity.class, "bukkitEntity");
    private static final MethodHandle CHUNKMAP_UPDATE_PLAYER_STATUS = NMS.getMethodHandle(PlayerChunkMap.class, "a", true, EntityPlayer.class, Boolean.TYPE);
    public static final MethodHandle CONNECTION_DISCONNECT_LISTENER = NMS.getSetter(NetworkManager.class, "p");
    public static final MethodHandle CONNECTION_PACKET_LISTENER = NMS.getSetter(NetworkManager.class, "q");
    private static final MethodHandle CRAFT_BOSSBAR_HANDLE_FIELD = NMS.getFirstSetter(CraftBossBar.class, BossBattleServer.class);
    private static final DataWatcherObject<Boolean> DATA_NAME_VISIBLE = (DataWatcherObject)NMS.getStaticObject(net.minecraft.world.entity.Entity.class, "aP");
    private static final DataWatcherObject<EntityPose> DATA_POSE = (DataWatcherObject)NMS.getStaticObject(net.minecraft.world.entity.Entity.class, "aq");
    private static final float DEFAULT_SPEED = 1.0f;
    public static final MethodHandle ENDERDRAGON_CHECK_WALLS = NMS.getFirstMethodHandleWithReturnType(EntityEnderDragon.class, true, Boolean.TYPE, AxisAlignedBB.class);
    public static final MethodHandle ENDERDRAGON_HURT = NMS.getMethodHandle(EntityEnderDragon.class, "b", true, WorldServer.class, List.class);
    public static final MethodHandle ENDERDRAGON_KNOCKBACK = NMS.getMethodHandle(EntityEnderDragon.class, "a", true, WorldServer.class, List.class);
    private static final DataWatcherObject<Boolean> ENDERMAN_DATA_CREEPY = (DataWatcherObject)NMS.getStaticObject(EntityEnderman.class, "cb");
    private static final MethodHandle ENTITY_EYE_HEIGHT = NMS.getSetter(net.minecraft.world.entity.Entity.class, "bc");
    private static final MethodHandle ENTITY_FISH_NUM_IN_SCHOOL = NMS.getFirstSetter(EntityFishSchool.class, Integer.TYPE);
    private static final MethodHandle ENTITY_NAVIGATION = NMS.getFirstSetter(EntityInsentient.class, NavigationAbstract.class);
    private static CustomEntityRegistry ENTITY_REGISTRY;
    private static MethodHandle ENTITY_REGISTRY_SETTER;
    private static final MethodHandle FALLING_BLOCK_STATE_SETTER;
    private static final MethodHandle FISHING_HOOK_LIFE;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_GETTER;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_SETTER;
    public static final MethodHandle FOX_SET_FACEPLANTED;
    private static final Location FROM_LOCATION;
    private static final DataWatcherObject<Float> INTERACTION_HEIGHT;
    private static final DataWatcherObject<Float> INTERACTION_WIDTH;
    private static final MethodHandle JUMP_FIELD;
    private static final MethodHandle LOOK_CONTROL_SETTER;
    private static MethodHandle META_COMPOUND_TAG;
    private static final MethodHandle MINECRAFT_CLIENT;
    public static final MethodHandle MOONRISE_IS_REAL_PLAYER;
    private static final MethodHandle MOVE_CONTROLLER_OPERATION;
    private static final MethodHandle NAVIGATION_CREATE_PATHFINDER;
    private static final MethodHandle NAVIGATION_PATH;
    private static final MethodHandle NAVIGATION_PATHFINDER;
    private static final MethodHandle NAVIGATION_WORLD_FIELD;
    public static final MethodHandle PAPER_PLAYER_MOB_COUNTS;
    private static final MethodHandle PLAYER_INFO_ENTRIES_LIST;
    private static final MethodHandle PLAYERINFO_ENTRIES;
    private static final MethodHandle POSITION_CODEC_GETTER;
    private static final MethodHandle PUFFERFISH_DEFLATE;
    private static final MethodHandle PUFFERFISH_INFLATE;
    public static DataWatcherObject<Integer> RABBIT_TYPE_DATAWATCHER;
    private static final Random RANDOM;
    private static final MethodHandle SERVER_ENTITY_GETTER;
    public static final MethodHandle SERVER_ENTITY_TRACK_DELTA;
    public static final MethodHandle SERVER_ENTITY_UPDATE_INTERVAL;
    private static MethodHandle SET_PROFILE_METHOD;
    private static final MethodHandle SIZE_FIELD_GETTER;
    private static final MethodHandle SIZE_FIELD_SETTER;
    private static MethodHandle SKULL_META_PROFILE;
    private static MethodHandle TEAM_FIELD;
    private static final Collection<MethodHandle> TRACKED_ENTITY_SETTERS;

    public NMSImpl() {
        this.loadEntityTypes();
    }

    @Override
    public void activate(Entity entity) {
        NMSImpl.getHandle((Entity)entity).activatedTick = MinecraftServer.currentTick;
    }

    @Override
    public boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason custom) {
        int viewDistance = -1;
        PlayerChunkMap chunkMap = null;
        if (entity instanceof Player) {
            chunkMap = ((ChunkProviderServer)NMSImpl.getHandle((Entity)entity).dV().S()).a;
            viewDistance = chunkMap.Q;
            chunkMap.Q = -1;
        }
        boolean success = NMSImpl.getHandle(entity).dV().addFreshEntity(NMSImpl.getHandle(entity), custom);
        if (chunkMap != null) {
            chunkMap.Q = viewDistance;
        }
        return success;
    }

    @Override
    public void addOrRemoveFromPlayerList(Entity entity, boolean remove) {
        if (entity == null) {
            return;
        }
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle(entity);
        if (handle.dV() == null) {
            return;
        }
        List players = handle.dV().z();
        boolean changed = false;
        if (remove && players.contains(handle)) {
            players.remove(handle);
            changed = true;
        } else if (!remove && !players.contains(handle)) {
            players.add(handle);
            changed = true;
        }
        if (!changed) {
            return;
        }
        try {
            CHUNKMAP_UPDATE_PLAYER_STATUS.invoke(((WorldServer)handle.dV()).m().a, handle, !remove);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void attack(LivingEntity attacker, LivingEntity btarget) {
        EntityLiving source = NMSImpl.getHandle(attacker);
        EntityLiving target = NMSImpl.getHandle(btarget);
        if (source instanceof EntityHuman) {
            ((EntityHuman)source).e((net.minecraft.world.entity.Entity)target);
            PlayerAnimation.ARM_SWING.play((Player)source.getBukkitEntity());
            return;
        }
        boolean hasAttackDamage = source.eY().b(GenericAttributes.c);
        if (source instanceof EntityInsentient && hasAttackDamage) {
            ((EntityInsentient)source).c((WorldServer)source.dV(), (net.minecraft.world.entity.Entity)target);
            return;
        }
        float f = (float)(hasAttackDamage ? source.h(GenericAttributes.c) : 1.0);
        DamageSource ds = target.dW().b(source);
        f = EnchantmentManager.a((WorldServer)((WorldServer)source.dV()), (net.minecraft.world.item.ItemStack)source.dZ(), (net.minecraft.world.entity.Entity)target, (DamageSource)ds, (float)f);
        boolean flag = target.a((WorldServer)source.dV(), target.dW().b(source), f);
        if (!flag) {
            return;
        }
        float k = EnchantmentManager.d((WorldServer)((WorldServer)source.dV()), (net.minecraft.world.item.ItemStack)source.dZ(), (net.minecraft.world.entity.Entity)target, (DamageSource)ds, (float)((float)source.h(GenericAttributes.d)));
        if (k > 0.0f) {
            target.knockback((double)(k * 0.5f), (double)MathHelper.a((float)(source.dL() * ((float)Math.PI / 180))), (double)(-MathHelper.b((float)(source.dL() * ((float)Math.PI / 180)))), (net.minecraft.world.entity.Entity)source, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
            source.i(source.dy().d(0.6, 1.0, 0.6));
        }
        source.B((net.minecraft.world.entity.Entity)target);
        EnchantmentManager.a((WorldServer)((WorldServer)source.dV()), (net.minecraft.world.entity.Entity)target, (DamageSource)ds);
    }

    @Override
    public void cancelMoveDestination(Entity entity) {
        MobAI ai = MobAI.from(NMSImpl.getHandle(entity));
        if (ai == null) {
            return;
        }
        ControllerMove control = ai.getMoveControl();
        if (control instanceof EntityMoveControl) {
            ((EntityMoveControl)control).moving = false;
        } else {
            try {
                MOVE_CONTROLLER_OPERATION.invoke(control, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean canNavigateTo(Entity entity, Location dest, NavigatorParameters params) {
        NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        return navigation.a(BlockPosition.a((double)dest.getX(), (double)dest.getY(), (double)dest.getZ()), 1) != null;
    }

    public Iterable<Object> createBundlePacket(List source) {
        return source.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)new ClientboundBundlePacket((Iterable)source));
    }

    @Override
    public EntityPacketTracker createPacketTracker(Entity entity, final EntityPacketTracker.PacketAggregator agg) {
        final net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        final Set linked = Sets.newIdentityHashSet();
        final EntityTrackerEntry tracker = new EntityTrackerEntry((WorldServer)handle.dV(), handle, handle.aq().p(), handle.aq().q(), agg::send, linked);
        final EnumMap equipment = Maps.newEnumMap(EnumItemSlot.class);
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                EntityPlayer p = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                handle.dS();
                tracker.b(p);
                linked.add(p.f);
                agg.add(p.cG(), packet -> p.f.b((Packet)packet));
            }

            @Override
            public void run() {
                if (handle instanceof EntityLiving) {
                    boolean changed = false;
                    EntityLiving entity = (EntityLiving)handle;
                    for (EnumItemSlot slot : EnumItemSlot.values()) {
                        net.minecraft.world.item.ItemStack old = equipment.getOrDefault(slot, net.minecraft.world.item.ItemStack.j);
                        net.minecraft.world.item.ItemStack curr = entity.a(slot);
                        if (!changed && entity.a(old, curr)) {
                            changed = true;
                        }
                        equipment.put(slot, curr);
                    }
                    if (changed) {
                        ArrayList vals = Lists.newArrayList();
                        for (EnumItemSlot slot : EnumItemSlot.values()) {
                            vals.add(Pair.of((Object)slot, (Object)((net.minecraft.world.item.ItemStack)equipment.get(slot))));
                        }
                        agg.send(new PacketPlayOutEntityEquipment(handle.ar(), (List)vals));
                    }
                }
                tracker.a();
            }

            @Override
            public void unlink(Player player) {
                EntityPlayer p = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                tracker.a(p);
                linked.remove(p.f);
                agg.removeConnection(p.cG());
            }

            @Override
            public void unlinkAll(Consumer<Player> callback) {
                handle.a(Entity.RemovalReason.a);
                for (ServerPlayerConnection link : Lists.newArrayList((Iterable)linked)) {
                    CraftPlayer entity = link.o().getBukkitEntity();
                    this.unlink((Player)entity);
                    if (callback == null) continue;
                    callback.accept((Player)entity);
                }
                linked.clear();
            }
        };
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) throws Throwable {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("NMS.fillProfileProperties cannot be invoked from the main thread.");
        }
        MinecraftSessionService sessionService = ((CraftServer)Bukkit.getServer()).getServer().aq();
        if (!(sessionService instanceof YggdrasilMinecraftSessionService)) {
            return sessionService.fetchProfile(profile.getId(), requireSecure).profile();
        }
        URL url = HttpAuthenticationService.constantURL((String)(this.getAuthServerBaseUrl() + UndashedUuid.toString((UUID)profile.getId())));
        url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure));
        MinecraftClient client = MINECRAFT_CLIENT.invoke(sessionService);
        MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)client.get(url, MinecraftProfilePropertiesResponse.class);
        return response.toProfile();
    }

    public String getAuthServerBaseUrl() {
        return Settings.Setting.AUTH_SERVER_URL.asString();
    }

    @Override
    public BlockBreaker getBlockBreaker(Entity entity, org.bukkit.block.Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return new CitizensBlockBreaker(entity, targetBlock, config);
    }

    public BossBar getBossBar(Entity entity) {
        BossBattleServer bserver = null;
        try {
            EnderDragonBattle df;
            if (entity.getType() == EntityType.WITHER) {
                bserver = ((EntityWither)NMSImpl.getHandle((Entity)entity)).ch;
            } else if (entity.getType() == EntityType.ENDER_DRAGON && (df = ((EntityEnderDragon)NMSImpl.getHandle(entity)).gp()) != null) {
                bserver = df.k;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (bserver == null) {
            return null;
        }
        BossBar ret = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        try {
            CRAFT_BOSSBAR_HANDLE_FIELD.invoke(ret, bserver);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public BoundingBox getBoundingBox(Entity handle) {
        return NMSBoundingBox.wrap(NMSImpl.getHandle(handle).cR());
    }

    @Override
    public BoundingBox getCollisionBox(Object data) {
        return NMSBoundingBox.wrap(((CraftBlockData)data).getState().b((IBlockAccess)BlockAccessAir.a, BlockPosition.c, VoxelShapeCollision.a()).a());
    }

    @Override
    public BoundingBox getCollisionBox(org.bukkit.block.Block block) {
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        VoxelShape shape = ((CraftBlock)block).getNMS().g((IBlockAccess)world, ((CraftBlock)block).getPosition());
        return shape.c() ? BoundingBox.EMPTY : NMSBoundingBox.wrap(shape.a());
    }

    @Override
    public Map<String, Object> getComponentMap(ItemStack item) {
        NBTTagCompound ct;
        Serializable base;
        if (META_COMPOUND_TAG == null) {
            base = item.getItemMeta().getClass();
            while (!((Class)base).getName().contains("CraftMetaItem")) {
                base = ((Class)base).getSuperclass();
            }
            META_COMPOUND_TAG = NMS.getGetter(base, "customTag");
        }
        base = Maps.newHashMap(NMSBridge.super.getComponentMap(item));
        try {
            ct = META_COMPOUND_TAG.invoke(item.getItemMeta());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return base;
        }
        if (ct == null) {
            return base;
        }
        base.put("custom_data", NMSImpl.deserialiseNBT((NBTBase)ct));
        return base;
    }

    @Override
    public Location getDestination(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        MobAI ai = MobAI.from(handle);
        if (ai == null) {
            return null;
        }
        ControllerMove controller = ai.getMoveControl();
        if (controller.b()) {
            return new Location(entity.getWorld(), controller.d(), controller.e(), controller.f());
        }
        if (ai.getNavigation().k()) {
            return null;
        }
        Vec3D vec = ai.getNavigation().i().a(handle);
        return new Location(entity.getWorld(), vec.a(), vec.b(), vec.c());
    }

    @Override
    public float getForwardBackwardMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.bp;
    }

    @Override
    public GameProfileRepository getGameProfileRepository() {
        return ((CraftServer)Bukkit.getServer()).getServer().as();
    }

    @Override
    public float getHeadYaw(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return entity.getLocation().getYaw();
        }
        return NMSImpl.getHandle((LivingEntity)entity).cA();
    }

    @Override
    public EntityPacketTracker getPacketTracker(Entity entity) {
        WorldServer server = (WorldServer)NMSImpl.getHandle(entity).dV();
        final PlayerChunkMap.EntityTracker tracked = (PlayerChunkMap.EntityTracker)server.m().a.K.get(entity.getEntityId());
        if (tracked == null) {
            return null;
        }
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                tracked.b((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void run() {
            }

            @Override
            public void unlink(Player player) {
                tracked.a((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void unlinkAll(Consumer<Player> callback) {
                tracked.a();
            }
        };
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null || handle.q == null) {
            return Lists.newArrayList();
        }
        return Lists.transform((List)handle.q, net.minecraft.world.entity.Entity::getBukkitEntity);
    }

    @Override
    public GameProfile getProfile(Player player) {
        return ((EntityHuman)NMSImpl.getHandle((LivingEntity)player)).gh();
    }

    @Override
    public GameProfile getProfile(SkullMeta meta) {
        if (SKULL_META_PROFILE == null && (SKULL_META_PROFILE = NMS.getFirstGetter(meta.getClass(), GameProfile.class)) == null) {
            return null;
        }
        try {
            return SKULL_META_PROFILE.invoke(meta);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public float getRidingHeightOffset(Entity entity, Entity mount) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return (float)(handle.m((net.minecraft.world.entity.Entity)NMSImpl.getHandle((Entity)mount)).e - handle.dt().e);
    }

    @Override
    public String getSoundPath(Sound flag) throws CommandException {
        try {
            SoundEffect effect = CraftSound.bukkitToMinecraft((Sound)flag);
            if (effect == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            return effect.a().a();
        }
        catch (Throwable e) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    @Override
    public Entity getSource(BlockCommandSender sender) {
        net.minecraft.world.entity.Entity source = ((CraftBlockCommandSender)sender).getWrapper().f();
        return source != null ? source.getBukkitEntity() : null;
    }

    @Override
    public float getSpeedFor(NPC npc) {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof LivingEntity)) {
            return 1.0f;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (handle == null) {
            return 1.0f;
        }
        return (float)handle.i(GenericAttributes.v);
    }

    @Override
    public float getStepHeight(Entity entity) {
        return NMSImpl.getHandle(entity).dP();
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> nodes, NavigatorParameters params) {
        ArrayList list = Lists.newArrayList((Iterable)Iterables.transform(nodes, input -> new PathPoint(input.getBlockX(), input.getBlockY(), input.getBlockZ())));
        PathPoint last = list.size() > 0 ? (PathPoint)list.get(list.size() - 1) : null;
        PathEntity path = new PathEntity((List)list, last != null ? new BlockPosition(last.a, last.b, last.c) : null, true);
        return this.getTargetNavigator(entity, params, (NavigationAbstract input) -> input.a(path, (double)params.speedModifier()));
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Location dest, NavigatorParameters params) {
        return this.getTargetNavigator(entity, params, (NavigationAbstract input) -> input.a(dest.getX(), dest.getY(), dest.getZ(), (double)params.speedModifier()));
    }

    private MCNavigationStrategy.MCNavigator getTargetNavigator(final Entity entity, final NavigatorParameters params, final Function<NavigationAbstract, Boolean> function) {
        float oldWater;
        final net.minecraft.world.entity.Entity raw = NMSImpl.getHandle(entity);
        raw.d(true);
        final NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        float f = oldWater = raw instanceof MobAI ? ((MobAI)raw).getPathfindingMalus(PathType.j) : ((EntityInsentient)raw).a(PathType.j);
        if (params.avoidWater() && oldWater >= 0.0f) {
            if (raw instanceof MobAI) {
                ((MobAI)raw).setPathfindingMalus(PathType.j, oldWater + 1.0f);
            } else {
                ((EntityInsentient)raw).a(PathType.j, oldWater + 1.0f);
            }
        }
        navigation.n().b(params.hasExaminer(DoorExaminer.class));
        return new MCNavigationStrategy.MCNavigator(){
            float lastSpeed;
            CancelReason reason;

            private List<org.bukkit.block.Block> getBlocks(Entity entity2, PathEntity path) {
                ArrayList blocks = Lists.newArrayList();
                for (int i = 0; i < path.e(); ++i) {
                    PathPoint pp = path.a(i);
                    blocks.add(entity2.getWorld().getBlockAt(pp.a, pp.b, pp.c));
                }
                return blocks;
            }

            @Override
            public CancelReason getCancelReason() {
                return this.reason;
            }

            @Override
            public Iterable<Vector> getPath() {
                return new NavigationIterable(navigation);
            }

            @Override
            public void stop() {
                PathEntity path = NMSImpl.getPathEntity(navigation);
                if (params.debug() && path != null) {
                    List<org.bukkit.block.Block> blocks = this.getBlocks(entity, path);
                    Util.sendBlockChanges(blocks, null);
                }
                if (oldWater >= 0.0f) {
                    if (raw instanceof MobAI) {
                        ((MobAI)raw).setPathfindingMalus(PathType.j, oldWater);
                    } else {
                        ((EntityInsentient)raw).a(PathType.j, oldWater);
                    }
                }
                navigation.m();
            }

            @Override
            public boolean update() {
                if (params.speedModifier() != this.lastSpeed) {
                    net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
                    EntitySize size = null;
                    try {
                        size = SIZE_FIELD_GETTER.invoke(handle);
                        if (handle instanceof EntityHorseAbstract) {
                            SIZE_FIELD_SETTER.invoke(handle, EntitySize.c((float)Math.min(0.99f, size.a()), (float)size.b()));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (!((Boolean)function.apply(navigation)).booleanValue()) {
                        this.reason = CancelReason.STUCK;
                    }
                    try {
                        SIZE_FIELD_SETTER.invoke(handle, size);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (params.debug() && NMSImpl.getPathEntity(navigation) != null) {
                        Util.sendBlockChanges(this.getBlocks(entity, NMSImpl.getPathEntity(navigation)), Material.DANDELION);
                    }
                    this.lastSpeed = params.speedModifier();
                }
                navigation.a((double)params.speedModifier());
                return navigation.k();
            }
        };
    }

    @Override
    public MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity target, NavigatorParameters parameters) {
        NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        return navigation == null ? null : new MCTargetNavigator(entity, navigation, target, parameters);
    }

    @Override
    public Entity getVehicle(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return null;
        }
        net.minecraft.world.entity.Entity e = handle.dk();
        return e == handle || e == null ? null : e.getBukkitEntity();
    }

    @Override
    public double getWidth(Entity entity) {
        return entity.getWidth();
    }

    @Override
    public float getXZMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.bn;
    }

    @Override
    public float getYaw(Entity entity) {
        return NMSImpl.getHandle(entity).dL();
    }

    @Override
    public boolean isOnGround(Entity entity) {
        return NMSImpl.getHandle(entity).aJ();
    }

    @Override
    public boolean isSneaking(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).isSneaking();
        }
        return NMSImpl.getHandle(entity).aw() == EntityPose.f;
    }

    @Override
    public boolean isSolid(org.bukkit.block.Block in) {
        IBlockData data = ((CraftBlock)in).getNMS();
        return data.j((IBlockAccess)((CraftWorld)in.getWorld()).getHandle(), new BlockPosition(in.getX(), in.getY(), in.getZ()));
    }

    @Override
    public boolean isValid(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return handle.valid && handle.bL();
    }

    @Override
    public void load(CommandManager manager) {
        this.registerTraitWithCommand(manager, EnderDragonTrait.class);
        this.registerTraitWithCommand(manager, AreaEffectCloudTrait.class);
        this.registerTraitWithCommand(manager, AllayTrait.class);
        this.registerTraitWithCommand(manager, AxolotlTrait.class);
        this.registerTraitWithCommand(manager, ArmadilloTrait.class);
        this.registerTraitWithCommand(manager, BeeTrait.class);
        this.registerTraitWithCommand(manager, BoatTrait.class);
        this.registerTraitWithCommand(manager, BossBarTrait.class);
        this.registerTraitWithCommand(manager, CamelTrait.class);
        this.registerTraitWithCommand(manager, CatTrait.class);
        this.registerTraitWithCommand(manager, DisplayTrait.class);
        this.registerTraitWithCommand(manager, FoxTrait.class);
        this.registerTraitWithCommand(manager, FrogTrait.class);
        this.registerTraitWithCommand(manager, GoatTrait.class);
        this.registerTraitWithCommand(manager, LlamaTrait.class);
        this.registerTraitWithCommand(manager, MushroomCowTrait.class);
        this.registerTraitWithCommand(manager, ParrotTrait.class);
        this.registerTraitWithCommand(manager, PandaTrait.class);
        this.registerTraitWithCommand(manager, PiglinTrait.class);
        this.registerTraitWithCommand(manager, PhantomTrait.class);
        this.registerTraitWithCommand(manager, PolarBearTrait.class);
        this.registerTraitWithCommand(manager, PufferFishTrait.class);
        this.registerTraitWithCommand(manager, SpellcasterTrait.class);
        this.registerTraitWithCommand(manager, ShulkerTrait.class);
        this.registerTraitWithCommand(manager, SnowmanTrait.class);
        this.registerTraitWithCommand(manager, TextDisplayTrait.class);
        this.registerTraitWithCommand(manager, TropicalFishTrait.class);
        this.registerTraitWithCommand(manager, VillagerTrait.class);
        this.registerTraitWithCommand(manager, WardenTrait.class);
    }

    private void loadEntityTypes() {
        EntityControllers.setEntityControllerForType(EntityType.ALLAY, AllayController.class);
        EntityControllers.setEntityControllerForType(EntityType.AREA_EFFECT_CLOUD, AreaEffectCloudController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMADILLO, ArmadilloController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMOR_STAND, ArmorStandController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARROW, TippedArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.AXOLOTL, AxolotlController.class);
        EntityControllers.setEntityControllerForType(EntityType.BAT, BatController.class);
        EntityControllers.setEntityControllerForType(EntityType.BEE, BeeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLAZE, BlazeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLOCK_DISPLAY, BlockDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.BOGGED, BoggedController.class);
        EntityControllers.setEntityControllerForType(EntityType.BREEZE, BreezeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BREEZE_WIND_CHARGE, BreezeWindChargeController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAMEL, CamelController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAT, CatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAVE_SPIDER, CaveSpiderController.class);
        for (EntityType type : EntityType.values()) {
            String name = type.name();
            if (name.endsWith("_CHEST_BOAT")) {
                EntityControllers.setEntityControllerForType(type, ChestBoatController.class);
            } else if (name.endsWith("_BOAT")) {
                EntityControllers.setEntityControllerForType(type, BoatController.class);
            }
            if (name.endsWith("_CHEST_RAFT")) {
                EntityControllers.setEntityControllerForType(type, ChestRaftController.class);
                continue;
            }
            if (!name.endsWith("_RAFT")) continue;
            EntityControllers.setEntityControllerForType(type, RaftController.class);
        }
        EntityControllers.setEntityControllerForType(EntityType.CHEST_MINECART, MinecartChestController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHICKEN, ChickenController.class);
        EntityControllers.setEntityControllerForType(EntityType.COD, CodController.class);
        EntityControllers.setEntityControllerForType(EntityType.COMMAND_BLOCK_MINECART, MinecartCommandController.class);
        EntityControllers.setEntityControllerForType(EntityType.COW, CowController.class);
        EntityControllers.setEntityControllerForType(EntityType.CREEPER, CreeperController.class);
        EntityControllers.setEntityControllerForType(EntityType.CREAKING, CreakingController.class);
        EntityControllers.setEntityControllerForType(EntityType.DOLPHIN, DolphinController.class);
        EntityControllers.setEntityControllerForType(EntityType.DONKEY, HorseDonkeyController.class);
        EntityControllers.setEntityControllerForType(EntityType.DRAGON_FIREBALL, DragonFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROWNED, DrownedController.class);
        EntityControllers.setEntityControllerForType(EntityType.EGG, EggController.class);
        EntityControllers.setEntityControllerForType(EntityType.ELDER_GUARDIAN, GuardianElderController.class);
        EntityControllers.setEntityControllerForType(EntityType.END_CRYSTAL, EnderCrystalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_DRAGON, EnderDragonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_PEARL, EnderPearlController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMAN, EndermanController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMITE, EndermiteController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER, EvokerController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER_FANGS, EvokerFangsController.class);
        EntityControllers.setEntityControllerForType(EntityType.EXPERIENCE_ORB, ExperienceOrbController.class);
        EntityControllers.setEntityControllerForType(EntityType.EXPERIENCE_BOTTLE, ThrownExpBottleController.class);
        EntityControllers.setEntityControllerForType(EntityType.EYE_OF_ENDER, EyeOfEnderController.class);
        EntityControllers.setEntityControllerForType(EntityType.FALLING_BLOCK, FallingBlockController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREBALL, LargeFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREWORK_ROCKET, FireworkController.class);
        EntityControllers.setEntityControllerForType(EntityType.FISHING_BOBBER, FishingHookController.class);
        EntityControllers.setEntityControllerForType(EntityType.FOX, FoxController.class);
        EntityControllers.setEntityControllerForType(EntityType.FROG, FrogController.class);
        EntityControllers.setEntityControllerForType(EntityType.FURNACE_MINECART, MinecartFurnaceController.class);
        EntityControllers.setEntityControllerForType(EntityType.GHAST, GhastController.class);
        EntityControllers.setEntityControllerForType(EntityType.GIANT, GiantController.class);
        EntityControllers.setEntityControllerForType(EntityType.GLOW_ITEM_FRAME, GlowItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.GLOW_SQUID, GlowSquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.GOAT, GoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.GUARDIAN, GuardianController.class);
        EntityControllers.setEntityControllerForType(EntityType.HOGLIN, HoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.HOPPER_MINECART, MinecartHopperController.class);
        EntityControllers.setEntityControllerForType(EntityType.HORSE, HorseController.class);
        EntityControllers.setEntityControllerForType(EntityType.HUSK, ZombieHuskController.class);
        EntityControllers.setEntityControllerForType(EntityType.ILLUSIONER, IllusionerController.class);
        EntityControllers.setEntityControllerForType(EntityType.INTERACTION, InteractionController.class);
        EntityControllers.setEntityControllerForType(EntityType.IRON_GOLEM, IronGolemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM, ItemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_DISPLAY, ItemDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_FRAME, ItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.OMINOUS_ITEM_SPAWNER, OminousItemSpawnerController.class);
        EntityControllers.setEntityControllerForType(EntityType.LEASH_KNOT, LeashController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA, LlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA_SPIT, LlamaSpitController.class);
        EntityControllers.setEntityControllerForType(EntityType.MAGMA_CUBE, MagmaCubeController.class);
        EntityControllers.setEntityControllerForType(EntityType.MARKER, MarkerController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART, MinecartRideableController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPAWNER_MINECART, MinecartSpawnerController.class);
        EntityControllers.setEntityControllerForType(EntityType.MOOSHROOM, MushroomCowController.class);
        EntityControllers.setEntityControllerForType(EntityType.MULE, HorseMuleController.class);
        EntityControllers.setEntityControllerForType(EntityType.OCELOT, OcelotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PAINTING, PaintingController.class);
        EntityControllers.setEntityControllerForType(EntityType.PANDA, PandaController.class);
        EntityControllers.setEntityControllerForType(EntityType.PARROT, ParrotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PHANTOM, PhantomController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG, PigController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN, PiglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN_BRUTE, PiglinBruteController.class);
        EntityControllers.setEntityControllerForType(EntityType.PILLAGER, PillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.PLAYER, HumanController.class);
        EntityControllers.setEntityControllerForType(EntityType.POLAR_BEAR, PolarBearController.class);
        EntityControllers.setEntityControllerForType(EntityType.POTION, ThrownPotionController.class);
        EntityControllers.setEntityControllerForType(EntityType.PUFFERFISH, PufferFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.RABBIT, RabbitController.class);
        EntityControllers.setEntityControllerForType(EntityType.RAVAGER, RavagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SALMON, SalmonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHEEP, SheepController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER, ShulkerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER_BULLET, ShulkerBulletController.class);
        EntityControllers.setEntityControllerForType(EntityType.SILVERFISH, SilverfishController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON, SkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON_HORSE, HorseSkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SLIME, SlimeController.class);
        EntityControllers.setEntityControllerForType(EntityType.SMALL_FIREBALL, SmallFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNIFFER, SnifferController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOW_GOLEM, SnowmanController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWBALL, SnowballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPECTRAL_ARROW, SpectralArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPIDER, SpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SQUID, SquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRAY, SkeletonStrayController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRIDER, StriderController.class);
        EntityControllers.setEntityControllerForType(EntityType.TADPOLE, TadpoleController.class);
        EntityControllers.setEntityControllerForType(EntityType.TEXT_DISPLAY, TextDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.TNT, TNTPrimedController.class);
        EntityControllers.setEntityControllerForType(EntityType.TNT_MINECART, MinecartTNTController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRADER_LLAMA, TraderLlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRIDENT, ThrownTridentController.class);
        EntityControllers.setEntityControllerForType(EntityType.TROPICAL_FISH, TropicalFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.TURTLE, TurtleController.class);
        EntityControllers.setEntityControllerForType(EntityType.VEX, VexController.class);
        EntityControllers.setEntityControllerForType(EntityType.VILLAGER, VillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.VINDICATOR, VindicatorController.class);
        EntityControllers.setEntityControllerForType(EntityType.WANDERING_TRADER, WanderingTraderController.class);
        EntityControllers.setEntityControllerForType(EntityType.WARDEN, WardenController.class);
        EntityControllers.setEntityControllerForType(EntityType.WIND_CHARGE, WindChargeController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITCH, WitchController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER, WitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKELETON, SkeletonWitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKULL, WitherSkullController.class);
        EntityControllers.setEntityControllerForType(EntityType.WOLF, WolfController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOGLIN, ZoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE, ZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_HORSE, HorseZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_VILLAGER, ZombieVillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIFIED_PIGLIN, PigZombieController.class);
    }

    @Override
    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        yaw = Util.clamp(yaw);
        handle.v(yaw);
        this.setHeadYaw(entity, yaw);
        handle.w(pitch);
    }

    @Override
    public void look(Entity entity, Location to, boolean headOnly, boolean immediate) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (immediate || headOnly || BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient) && !(handle instanceof MobAI)) {
            double pitch;
            double yaw;
            Location fromLocation = entity.getLocation(FROM_LOCATION);
            double xDiff = to.getX() - fromLocation.getX();
            double yDiff = to.getY() - fromLocation.getY();
            double zDiff = to.getZ() - fromLocation.getZ();
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
            double d2 = yaw = distanceXZ == 0.0 ? 0.0 : Math.toDegrees(Math.acos(xDiff / distanceXZ));
            double d3 = distanceY == 0.0 ? 0.0 : (pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - (double)(handle.getBukkitEntity().getType() == EntityType.PHANTOM ? 45 : 90));
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            yaw = handle.getBukkitEntity().getType() == EntityType.ENDER_DRAGON ? (double)Util.getYawFromVelocity((Entity)handle.getBukkitEntity(), xDiff, zDiff) : (yaw -= 90.0);
            if (headOnly) {
                this.setHeadYaw(entity, (float)yaw);
            } else {
                this.look(entity, (float)yaw, (float)pitch);
            }
            return;
        }
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).L().a(to.getX(), to.getY(), to.getZ(), (float)((EntityInsentient)handle).ai(), (float)((EntityInsentient)handle).ad());
            while (((EntityLiving)handle).aZ >= 180.0f) {
                ((EntityLiving)handle).aZ -= 360.0f;
            }
            while (((EntityLiving)handle).aZ < -180.0f) {
                ((EntityLiving)handle).aZ += 360.0f;
            }
        } else if (handle instanceof NPCHolder) {
            ((NPCHolder)handle).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(to);
        }
    }

    @Override
    public void look(Entity from, Entity to) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(from);
        net.minecraft.world.entity.Entity target = NMSImpl.getHandle(to);
        if (BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient) && !(handle instanceof MobAI)) {
            if (to instanceof LivingEntity) {
                this.look(from, ((LivingEntity)to).getEyeLocation(), false, true);
            } else {
                this.look(from, to.getLocation(), false, true);
            }
        } else if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).L().a(target, (float)((EntityInsentient)handle).ai(), (float)((EntityInsentient)handle).ad());
            while (((EntityLiving)handle).aZ >= 180.0f) {
                ((EntityLiving)handle).aZ -= 360.0f;
            }
            while (((EntityLiving)handle).aZ < -180.0f) {
                ((EntityLiving)handle).aZ += 360.0f;
            }
        } else if (handle instanceof NPCHolder) {
            ((NPCHolder)handle).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(to);
        }
    }

    @Override
    public void markPoseDirty(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        handle.au().markDirty(DATA_POSE);
    }

    @Override
    public void mount(Entity entity, Entity passenger) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(passenger);
        if (handle == null) {
            return;
        }
        handle.a(NMSImpl.getHandle(entity), true);
    }

    @Override
    public void onPlayerInfoAdd(Player player, Object raw, Function<UUID, MirrorTrait> mirrorTraits) {
        ClientboundPlayerInfoUpdatePacket packet = (ClientboundPlayerInfoUpdatePacket)raw;
        ArrayList list = Lists.newArrayList((Iterable)packet.e());
        boolean changed = false;
        GameProfile playerProfile = null;
        for (int i = 0; i < list.size(); ++i) {
            MirrorTrait trait;
            ClientboundPlayerInfoUpdatePacket.b npcInfo = (ClientboundPlayerInfoUpdatePacket.b)list.get(i);
            if (npcInfo == null || (trait = mirrorTraits.apply(npcInfo.a())) == null || !trait.isMirroring(player)) continue;
            boolean disableTablist = trait.getNPC().shouldRemoveFromTabList();
            if (disableTablist != npcInfo.c()) {
                list.set(i, new ClientboundPlayerInfoUpdatePacket.b(npcInfo.a(), npcInfo.b(), !disableTablist, npcInfo.d(), npcInfo.e(), (IChatBaseComponent)(!disableTablist ? npcInfo.f() : IChatBaseComponent.i()), npcInfo.g(), npcInfo.h(), npcInfo.i()));
                changed = true;
            }
            if (playerProfile == null) {
                playerProfile = NMS.getProfile(player);
            }
            if (trait.mirrorName()) {
                list.set(i, new ClientboundPlayerInfoUpdatePacket.b(npcInfo.a(), playerProfile, !disableTablist, npcInfo.d(), npcInfo.e(), (IChatBaseComponent)IChatBaseComponent.b((String)Util.possiblyStripBedrockPrefix(playerProfile.getName(), playerProfile.getId())), npcInfo.g(), npcInfo.h(), npcInfo.i()));
                changed = true;
                continue;
            }
            Collection textures = playerProfile.getProperties().get((Object)"textures");
            if (textures == null || textures.size() == 0) continue;
            npcInfo.b().getProperties().clear();
            for (String key : playerProfile.getProperties().keySet()) {
                npcInfo.b().getProperties().putAll((Object)key, (Iterable)playerProfile.getProperties().get((Object)key));
            }
            changed = true;
        }
        if (changed) {
            try {
                PLAYER_INFO_ENTRIES_LIST.invoke(packet, list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public InventoryView openAnvilInventory(Player player, Inventory anvil, String title) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        CitizensAnvilMenu container = new CitizensAnvilMenu(handle.nextContainerCounter(), handle.gi(), ContainerAccess.a((net.minecraft.world.level.World)handle.dV(), (BlockPosition)new BlockPosition(0, 0, 0)), anvil);
        container.setTitle((IChatBaseComponent)IChatMutableComponent.a((ComponentContents)new LiteralContents.a(title == null ? "" : title)));
        container.getBukkitView().setItem(0, anvil.getItem(0));
        container.getBukkitView().setItem(1, anvil.getItem(1));
        container.checkReachable = false;
        handle.f.b((Packet)new PacketPlayOutOpenWindow(container.l, container.a(), container.getTitle()));
        handle.cd = container;
        handle.a((Container)container);
        return container.getBukkitView();
    }

    @Override
    public void openHorseInventory(Tameable horse, Player equipper) {
        EntityLiving handle = NMSImpl.getHandle(horse);
        EntityPlayer equipperHandle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)equipper);
        if (handle == null || equipperHandle == null) {
            return;
        }
        boolean wasTamed = horse.isTamed();
        horse.setTamed(true);
        ((EntityHorseAbstract)handle).b((EntityHuman)equipperHandle);
        horse.setTamed(wasTamed);
    }

    @Override
    public void playAnimation(PlayerAnimation animation, Player player, Iterable<Player> to) {
        PlayerAnimationImpl.play(animation, player, to);
    }

    @Override
    public Runnable playerTicker(NPC npc, Player entity) {
        EntityPlayer player = (EntityPlayer)NMSImpl.getHandle((LivingEntity)entity);
        return () -> {
            if (!entity.isValid()) {
                return;
            }
            player.i();
        };
    }

    @Override
    public void positionInteractionText(Player player, Entity entity, Entity mount, double offset) {
        NMSImpl.sendPacket(player, new ClientboundBundlePacket(List.of(new PacketPlayOutEntityMetadata(entity.getEntityId(), List.of(new DataWatcher.Item(INTERACTION_WIDTH, (Object)Float.valueOf(0.0f)).e(), new DataWatcher.Item(INTERACTION_HEIGHT, (Object)Float.valueOf((float)(offset += (double)this.getRidingHeightOffset(entity, mount)))).e(), new DataWatcher.Item(DATA_POSE, (Object)EntityPose.i).e(), new DataWatcher.Item(DATA_NAME_VISIBLE, (Object)true).e())), new PacketPlayOutMount(NMSImpl.getHandle(mount)), new PacketPlayOutEntityMetadata(entity.getEntityId(), List.of(new DataWatcher.Item(INTERACTION_HEIGHT, (Object)Float.valueOf(999999.0f)).e())))));
    }

    @Override
    public void registerEntityClass(Class<?> clazz, Object raw) {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        EntityTypes type = (EntityTypes)raw;
        Class<?> search = clazz;
        while ((search = search.getSuperclass()) != null && net.minecraft.world.entity.Entity.class.isAssignableFrom(search)) {
            MinecraftKey key = ENTITY_REGISTRY.getKey(type);
            if (key == null || type == null) continue;
            int code = ENTITY_REGISTRY.getId(type);
            ENTITY_REGISTRY.put(code, key, type);
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass for class " + clazz.toString());
    }

    private void registerTraitWithCommand(CommandManager manager, Class<? extends Trait> clazz) {
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(clazz));
        manager.register(clazz);
    }

    @Override
    public void remove(Entity entity) {
        NMSImpl.getHandle(entity).a(Entity.RemovalReason.a);
    }

    @Override
    public void removeFromServerPlayerList(Player player) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().l.remove(handle);
    }

    @Override
    public void removeFromWorld(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        ((WorldServer)handle.dV()).m().a(handle);
    }

    @Override
    public void removeHookIfNecessary(FishHook entity) {
        EntityFishingHook hook = (EntityFishingHook)NMSImpl.getHandle((Entity)entity);
        net.minecraft.world.entity.Entity hooked = hook.s();
        if (hooked == null) {
            return;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)hooked.getBukkitEntity());
        if (npc != null && npc.isProtected()) {
            hook.n = null;
            hook.getBukkitEntity().remove();
        }
    }

    @Override
    public void replaceTrackerEntry(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        PlayerChunkMap cm = ((WorldServer)handle.dV()).m().a;
        PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)cm.K.get(entity.getEntityId());
        if (entry == null) {
            return;
        }
        entry.a();
        CitizensEntityTracker newTracker = new CitizensEntityTracker(cm, entry);
        for (MethodHandle setter : TRACKED_ENTITY_SETTERS) {
            try {
                setter.invoke(handle, newTracker);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        cm.K.put(entity.getEntityId(), (Object)newTracker);
    }

    @Override
    public void sendPositionUpdate(Entity from, Collection<Player> to, boolean position, Float bodyYaw, Float pitch, Float headYaw) {
        List<Packet<?>> toSend = NMSImpl.getPositionUpdate(from, position, bodyYaw, pitch, headYaw);
        for (Player dest : to) {
            NMSImpl.sendPackets(dest, toSend);
        }
    }

    @Override
    public boolean sendTabListAdd(Player recipient, Player listPlayer) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)listPlayer);
        EntityPlayer from = ((CraftPlayer)listPlayer).getHandle();
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(Arrays.asList(from));
        boolean list = from instanceof NPCHolder ? !((NPCHolder)from).getNPC().shouldRemoveFromTabList() : true;
        ClientboundPlayerInfoUpdatePacket.b entry = new ClientboundPlayerInfoUpdatePacket.b(from.cG(), from.gh(), list, from.f.k(), from.h.b(), (IChatBaseComponent)(list ? from.O() : IChatBaseComponent.i()), false, from.listOrder, from.ad() == null ? null : from.ad().a());
        try {
            PLAYERINFO_ENTRIES.invoke(packet, Lists.newArrayList((Object[])new ClientboundPlayerInfoUpdatePacket.b[]{entry}));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        NMSImpl.sendPacket(recipient, packet);
        return true;
    }

    @Override
    public void sendTabListRemove(Player recipient, Collection<Player> players) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull(players);
        NMSImpl.sendPacket(recipient, new ClientboundPlayerInfoRemovePacket(players.stream().map(OfflinePlayer::getUniqueId).collect(Collectors.toList())));
    }

    @Override
    public void sendTeamPacket(Player recipient, Team team, int mode) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)team);
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getGetter(team.getClass(), "team");
        }
        try {
            ScoreboardTeam nmsTeam = TEAM_FIELD.invoke(team);
            if (mode == 1) {
                NMSImpl.sendPacket(recipient, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)nmsTeam));
            } else {
                NMSImpl.sendPacket(recipient, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)nmsTeam, (mode == 0 ? 1 : 0) != 0));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setAggressive(Entity entity, boolean aggro) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)handle).w(aggro);
    }

    @Override
    public void setAllayDancing(Entity entity, boolean dancing) {
        Allay allay = (Allay)NMSImpl.getHandle(entity);
        allay.x(dancing);
    }

    @Override
    public void setArmadilloState(Entity entity, ArmadilloTrait.ArmadilloState state) {
        Armadillo.a s = Armadillo.a.a;
        switch (state) {
            case IDLE: {
                s = Armadillo.a.a;
                break;
            }
            case ROLLING_UP: {
                s = Armadillo.a.b;
                break;
            }
            case ROLLING_OUT: {
                s = Armadillo.a.d;
                break;
            }
            case SCARED: {
                s = Armadillo.a.c;
            }
        }
        ((Armadillo)NMSImpl.getHandle(entity)).a(s);
    }

    @Override
    public void setBodyYaw(Entity entity, float yaw) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).aY = yaw;
        }
        handle.r(yaw);
        handle.v(yaw);
    }

    @Override
    public void setBoundingBox(Entity entity, BoundingBox box) {
        NMSImpl.getHandle(entity).a(NMSBoundingBox.convert(box));
    }

    @Override
    public void setCamelPose(Entity entity, CamelTrait.CamelPose pose) {
        if (entity.getType() != EntityType.CAMEL) {
            throw new IllegalStateException();
        }
        Camel camel = (Camel)NMSImpl.getHandle(entity);
        switch (pose) {
            case STANDING: {
                if (!camel.gN()) {
                    camel.gG();
                }
                return;
            }
            case SITTING: {
                if (!camel.gv()) {
                    camel.gF();
                }
                return;
            }
            case PANIC: {
                if (!camel.gp()) {
                    camel.gH();
                }
                return;
            }
        }
    }

    @Override
    public void setCustomName(Entity entity, Object component, String string) {
        NMSImpl.getHandle(entity).b((IChatBaseComponent)component);
    }

    @Override
    public void setDestination(Entity entity, double x, double y, double z, float speed) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        MobAI ai = MobAI.from(handle);
        if (ai != null) {
            ai.getMoveControl().a(x, y, z, (double)speed);
        }
    }

    @Override
    public void setDimensions(Entity entity, EntityDim desired) {
        NMSImpl.setSize(NMSImpl.getHandle(entity), EntitySize.c((float)desired.width, (float)desired.height));
    }

    @Override
    public void setEndermanAngry(Enderman enderman, boolean angry) {
        if (ENDERMAN_DATA_CREEPY == null) {
            return;
        }
        NMSImpl.getHandle((LivingEntity)enderman).au().a(ENDERMAN_DATA_CREEPY, (Object)angry);
    }

    @Override
    public void setHeadAndBodyYaw(Entity entity, float yaw) {
        yaw = Util.clamp(yaw);
        this.setBodyYaw(entity, yaw);
        this.setHeadYaw(entity, yaw);
    }

    @Override
    public void setHeadYaw(Entity entity, float yaw) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ((EntityLiving)NMSImpl.getHandle(entity)).q(Util.clamp(yaw));
    }

    @Override
    public void setKnockbackResistance(LivingEntity entity, double d2) {
        EntityLiving handle = NMSImpl.getHandle(entity);
        handle.g(GenericAttributes.p).a(d2);
    }

    @Override
    public void setLocationDirectly(Entity entity, Location location) {
        NMSImpl.getHandle(entity).b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setLyingDown(Entity cat, boolean lying) {
        ((EntityCat)NMSImpl.getHandle(cat)).A(lying);
    }

    @Override
    public void setNavigationTarget(Entity handle, Entity target, float speed) {
        NMSImpl.getNavigation(handle).a(NMSImpl.getHandle(target), (double)speed);
    }

    @Override
    public void setNavigationType(Entity entity, NMS.MinecraftNavigationType type) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient ei = (EntityInsentient)handle;
        switch (type) {
            case GROUND: {
                try {
                    ENTITY_NAVIGATION.invoke(ei, new Navigation(ei, ei.dV()));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            case WALL_CLIMB: {
                try {
                    ENTITY_NAVIGATION.invoke(ei, new NavigationSpider(ei, ei.dV()));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setNoGravity(Entity entity, boolean nogravity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        handle.f(nogravity);
        if (!(handle instanceof EntityInsentient) || !(entity instanceof NPCHolder)) {
            return;
        }
        EntityInsentient mob = (EntityInsentient)handle;
        NPC npc = ((NPCHolder)entity).getNPC();
        if (!(mob.N() instanceof ControllerMoveFlying) || npc.data().has("flying-nogravity-float")) {
            return;
        }
        try {
            if (nogravity) {
                boolean old = FLYING_MOVECONTROL_FLOAT_GETTER.invoke(mob.N());
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(mob.N(), true);
                npc.data().set("flying-nogravity-float", (Object)old);
            } else if (npc.data().has("flying-nogravity-float")) {
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(mob.N(), npc.data().get("flying-nogravity-float"));
                npc.data().remove("flying-nogravity-float");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setOpWithoutSaving(Player player, boolean op) {
        if (player.isOp() == op) {
            return;
        }
        EntityPlayer playerHandle = ((CraftPlayer)player).getHandle();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        DedicatedPlayerList playerList = ((CraftServer)player.getServer()).getHandle();
        DedicatedServer server = playerList.b();
        OpList opList = playerList.k();
        if (op) {
            opList.a((JsonListEntry)new OpListEntry(profile, server.k(), opList.a(profile)));
        } else {
            opList.c((Object)profile);
        }
        playerList.e(playerHandle);
    }

    @Override
    public void setPandaSitting(Entity entity, boolean sitting) {
        ((EntityPanda)NMSImpl.getHandle(entity)).x(sitting);
    }

    @Override
    public void setPeekShulker(Entity shulker, int peek) {
        ((EntityShulker)NMSImpl.getHandle(shulker)).b(peek);
    }

    @Override
    public void setPiglinDancing(Entity entity, boolean dancing) {
        if (!(NMSImpl.getHandle(entity) instanceof EntityPiglin)) {
            return;
        }
        ((EntityPiglin)NMSImpl.getHandle(entity)).y(dancing);
    }

    @Override
    public void setPitch(Entity entity, float pitch) {
        NMSImpl.getHandle(entity).w(pitch);
    }

    @Override
    public void setPolarBearRearing(Entity entity, boolean rearing) {
        ((EntityPolarBear)NMSImpl.getHandle(entity)).x(rearing);
    }

    @Override
    public void setPose(Entity entity, EntityPoseTrait.EntityPose pose) {
        NMSImpl.getHandle(entity).b((EntityPose)EntityPose.s.apply(pose.id()));
    }

    @Override
    public void setProfile(SkullMeta meta, GameProfile profile) {
        if (SET_PROFILE_METHOD == null && (SET_PROFILE_METHOD = NMS.getMethodHandle(meta.getClass(), "setProfile", true, GameProfile.class)) == null) {
            return;
        }
        try {
            SET_PROFILE_METHOD.invoke(meta, profile);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setShouldJump(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        MobAI ai = MobAI.from(handle);
        if (ai != null) {
            ai.getJumpControl().a();
        }
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).t(true);
        }
    }

    @Override
    public void setSitting(Ocelot ocelot, boolean sitting) {
        this.setSneaking((Entity)ocelot, sitting);
    }

    @Override
    public void setSitting(Tameable tameable, boolean sitting) {
        ((EntityTameableAnimal)NMSImpl.getHandle(tameable)).y(sitting);
    }

    @Override
    public void setSneaking(Entity entity, boolean sneaking) {
        if (entity instanceof Player) {
            ((Player)entity).setSneaking(sneaking);
        }
        EntityPose pose = sneaking ? EntityPose.f : EntityPose.a;
        NMSImpl.getHandle(entity).b(pose);
    }

    @Override
    public void setSnifferState(Entity entity, SnifferTrait.SnifferState state) {
        Sniffer handle = (Sniffer)NMSImpl.getHandle(entity);
        handle.a(Sniffer.State.valueOf((String)state.name()));
    }

    @Override
    public void setStepHeight(Entity entity, float height) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof EntityLiving)) {
            return;
        }
        ((EntityLiving)handle).g(GenericAttributes.B).a((double)height);
    }

    @Override
    public void setTextDisplayComponent(Entity entity, Object component) {
        Display.TextDisplay disp = (Display.TextDisplay)NMSImpl.getHandle(entity);
        disp.a((IChatBaseComponent)component);
    }

    @Override
    public void setVerticalMovement(Entity bukkitEntity, double d2) {
        if (!bukkitEntity.getType().isAlive()) {
            return;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)bukkitEntity);
        handle.bn = (float)d2;
    }

    @Override
    public void setWardenPose(Entity entity, Object pose) {
        Warden warden = (Warden)NMSImpl.getHandle(entity);
        if (pose == Pose.DIGGING) {
            if (warden.c(EntityPose.o)) {
                return;
            }
            warden.b(EntityPose.o);
            warden.a(SoundEffects.Cz, 5.0f, 1.0f);
        } else if (pose == Pose.EMERGING) {
            if (warden.c(EntityPose.n)) {
                return;
            }
            warden.b(EntityPose.n);
            warden.a(SoundEffects.CA, 5.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (warden.c(EntityPose.n)) {
                    warden.b(EntityPose.a);
                }
            }, 134L);
        } else if (pose == Pose.ROARING) {
            if (warden.c(EntityPose.l)) {
                return;
            }
            warden.b(EntityPose.l);
            warden.a(SoundEffects.CI, 3.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (warden.c(EntityPose.l)) {
                    warden.b(EntityPose.a);
                }
            }, 84L);
        } else {
            warden.b(EntityPose.a);
        }
    }

    @Override
    public boolean shouldJump(Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return JUMP_FIELD.invoke(NMSImpl.getHandle(entity));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void shutdown() {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        try {
            ENTITY_REGISTRY_SETTER.invoke(null, ENTITY_REGISTRY.get());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sleep(Player entity, boolean sleep) {
        NMSImpl.getHandle((LivingEntity)entity).b(sleep ? EntityPose.c : EntityPose.a);
    }

    @Override
    public void trySwim(Entity entity) {
        this.trySwim(entity, 0.04f);
    }

    @Override
    public void trySwim(Entity entity, float power) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (RANDOM.nextFloat() <= 0.85f && handle.bj()) {
            handle.n(handle.dy().d, handle.dy().e + (double)power, handle.dy().f);
        }
    }

    @Override
    public void updateInventoryTitle(Player player, SpigotUtil.InventoryViewAPI view, String newTitle) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        Containers menuType = null;
        switch (view.getTopInventory().getType()) {
            case ANVIL: {
                menuType = Containers.i;
                break;
            }
            case BARREL: {
                menuType = Containers.c;
                break;
            }
            case BEACON: {
                menuType = Containers.j;
                break;
            }
            case BLAST_FURNACE: {
                menuType = Containers.k;
                break;
            }
            case BREWING: {
                menuType = Containers.l;
                break;
            }
            case CARTOGRAPHY: {
                menuType = Containers.x;
                break;
            }
            case CHEST: {
                int sz = view.getTopInventory().getSize();
                if (sz > 45) {
                    menuType = Containers.f;
                    break;
                }
                if (sz > 36) {
                    menuType = Containers.e;
                    break;
                }
                if (sz > 27) {
                    menuType = Containers.d;
                    break;
                }
                if (sz > 18) {
                    menuType = Containers.c;
                    break;
                }
                if (sz > 9) {
                    menuType = Containers.b;
                    break;
                }
                menuType = Containers.a;
                break;
            }
            case COMPOSTER: {
                break;
            }
            case PLAYER: 
            case CRAFTING: 
            case CREATIVE: {
                return;
            }
            case DISPENSER: 
            case DROPPER: {
                menuType = Containers.g;
                break;
            }
            case ENCHANTING: {
                menuType = Containers.n;
                break;
            }
            case ENDER_CHEST: {
                menuType = Containers.c;
                break;
            }
            case FURNACE: {
                menuType = Containers.o;
                break;
            }
            case GRINDSTONE: {
                menuType = Containers.p;
                break;
            }
            case HOPPER: {
                menuType = Containers.q;
                break;
            }
            case LECTERN: {
                menuType = Containers.r;
                break;
            }
            case LOOM: {
                menuType = Containers.s;
                break;
            }
            case MERCHANT: {
                menuType = Containers.t;
                break;
            }
            case SHULKER_BOX: {
                menuType = Containers.u;
                break;
            }
            case SMITHING: {
                menuType = Containers.v;
                break;
            }
            case SMOKER: {
                menuType = Containers.w;
                break;
            }
            case STONECUTTER: {
                menuType = Containers.y;
                break;
            }
            case WORKBENCH: {
                menuType = Containers.m;
            }
        }
        handle.f.b((Packet)new PacketPlayOutOpenWindow(handle.cd.l, menuType, (IChatBaseComponent)IChatMutableComponent.a((ComponentContents)new LiteralContents.a(newTitle))));
        player.updateInventory();
    }

    @Override
    public void updateNavigationWorld(Entity entity, World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        net.minecraft.world.entity.Entity en = NMSImpl.getHandle(entity);
        if (en == null || !(en instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.invoke(handle.P(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatePathfindingRange(NPC npc, float pathfindingRange) {
        if (!npc.isSpawned() || !npc.getEntity().getType().isAlive()) {
            return;
        }
        EntityLiving en = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (en instanceof MobAI) {
            ((MobAI)en).updatePathfindingRange(pathfindingRange);
            return;
        }
        if (NAVIGATION_PATHFINDER == null) {
            return;
        }
        NavigationAbstract navigation = ((EntityInsentient)en).P();
        AttributeModifiable inst = en.g(GenericAttributes.m);
        inst.a((double)pathfindingRange);
        int mc = MathHelper.a((double)(en.i(GenericAttributes.m) * 16.0));
        try {
            NAVIGATION_PATHFINDER.invoke(navigation, NAVIGATION_CREATE_PATHFINDER.invoke(navigation, mc));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void callNPCMoveEvent(NPC npc, net.minecraft.world.entity.Entity what) {
        if (NPCMoveEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        if (what.K != what.dA() || what.L != what.dC() || what.M != what.dG() || what.N != what.dL() || what.O != what.dN()) {
            Location from = new Location((World)what.dV().getWorld(), what.K, what.L, what.M, what.N, what.O);
            Location to = new Location((World)what.dV().getWorld(), what.dA(), what.dC(), what.dG(), what.dL(), what.dN());
            NPCMoveEvent event = new NPCMoveEvent(npc, from, to.clone());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                Location eventFrom = event.getFrom();
                what.a(eventFrom.getX(), eventFrom.getY(), eventFrom.getZ(), eventFrom.getYaw(), eventFrom.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                what.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
    }

    public static void checkAndUpdateHeight(EntityLiving living, DataWatcherObject<?> datawatcherobject, Consumer<DataWatcherObject<?>> cb) {
        EntitySize size;
        try {
            size = SIZE_FIELD_GETTER.invoke(living);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        float oldw = size.a();
        float oldl = size.b();
        cb.accept(datawatcherobject);
        if (oldw != size.a() || size.b() != oldl) {
            living.a_(living.dA() - 0.01, living.dC(), living.dG() - 0.01);
            living.a_(living.dA() + 0.01, living.dC(), living.dG() + 0.01);
        }
    }

    public static void clearGoals(NPC npc, PathfinderGoalSelector ... goalSelectors) {
        if (goalSelectors == null) {
            return;
        }
        int i = 0;
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                Set list = selector.b();
                if (!list.isEmpty()) {
                    npc.data().set("selector" + i, (Object)Lists.newArrayList((Iterable)list));
                }
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
            catch (Throwable e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
            ++i;
        }
    }

    private static Object deserialiseNBT(NBTBase tag) {
        switch (tag.b()) {
            case 10: {
                NBTTagCompound ct = (NBTTagCompound)tag;
                HashMap map = Maps.newHashMapWithExpectedSize((int)ct.f());
                for (String key : ct.e()) {
                    map.put(key, NMSImpl.deserialiseNBT(ct.c(key)));
                }
                return map;
            }
            case 9: {
                NBTTagList list = (NBTTagList)tag;
                ArrayList res = Lists.newArrayList((Object[])new Object[]{list.size()});
                for (int i = 0; i < list.size(); ++i) {
                    res.add(NMSImpl.deserialiseNBT(list.k(i)));
                }
                return res;
            }
            case 7: {
                return ((NBTTagByteArray)tag).e();
            }
            case 11: {
                return ((NBTTagIntArray)tag).g();
            }
            case 12: {
                return ((NBTTagLongArray)tag).g();
            }
            case 8: {
                return ((NBTTagString)tag).u_();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 99: {
                return ((NBTNumber)tag).l();
            }
        }
        throw new IllegalArgumentException();
    }

    public static TreeMap<?, ?> getBehaviorMap(EntityLiving entity) {
        try {
            return AVAILABLE_BEHAVIORS_BY_PRIORITY.invoke(entity.eb());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static net.minecraft.world.entity.Entity getHandle(Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    private static EntityLiving getHandle(LivingEntity entity) {
        return (EntityLiving)NMSImpl.getHandle((Entity)entity);
    }

    private static EntityLiving getHandle(Tameable entity) {
        return (EntityLiving)NMSImpl.getHandle((Entity)entity);
    }

    public static NavigationAbstract getNavigation(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return handle instanceof EntityInsentient ? ((EntityInsentient)handle).P() : (handle instanceof MobAI ? ((MobAI)handle).getNavigation() : null);
    }

    private static PathEntity getPathEntity(NavigationAbstract nav) {
        try {
            return nav instanceof EntityNavigation ? ((EntityNavigation)nav).getPathEntity() : NAVIGATION_PATH.invoke(nav);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Packet<?>> getPositionUpdate(Entity from, boolean position, Float bodyYaw, Float pitch, Float headYaw) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(from);
        if (bodyYaw == null) {
            bodyYaw = Float.valueOf(handle.dL());
        }
        if (pitch == null) {
            pitch = Float.valueOf(handle.dN());
        }
        ArrayList toSend = Lists.newArrayList();
        if (position) {
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)((WorldServer)handle.dV()).m().a.K.get(handle.ar());
            if (entry == null) {
                Messaging.debug("Null tracker entity for ", from);
                return Collections.emptyList();
            }
            VecDeltaCodec vdc = null;
            try {
                EntityTrackerEntry serverEntity = SERVER_ENTITY_GETTER.invoke(entry);
                if (serverEntity == null) {
                    Messaging.debug("Null server entity for ", from);
                    return Collections.emptyList();
                }
                vdc = POSITION_CODEC_GETTER.invoke(serverEntity);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
            Vec3D pos = handle.du();
            toSend.add(new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(handle.ar(), (short)vdc.a(pos), (short)vdc.b(pos), (short)vdc.c(pos), (byte)(bodyYaw.floatValue() * 256.0f / 360.0f), (byte)(pitch.floatValue() * 256.0f / 360.0f), handle.aD));
        } else {
            toSend.add(new PacketPlayOutEntity.PacketPlayOutEntityLook(handle.ar(), (byte)(bodyYaw.floatValue() * 256.0f / 360.0f), (byte)(pitch.floatValue() * 256.0f / 360.0f), handle.aD));
        }
        if (headYaw != null) {
            toSend.add(new PacketPlayOutEntityHeadRotation(handle, (byte)(headYaw.floatValue() * 256.0f / 360.0f)));
        }
        return toSend;
    }

    public static EntitySize getSize(net.minecraft.world.entity.Entity entity) {
        try {
            return SIZE_FIELD_GETTER.invoke(entity);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SoundEffect getSoundEffect(NPC npc, SoundEffect snd, NPC.Metadata meta) {
        if (npc == null) {
            return snd;
        }
        String data = (String)npc.data().get(meta);
        if (data == null) {
            return snd;
        }
        Holder.c ref = BuiltInRegistries.b.c(MinecraftKey.c((String)data)).orElse(null);
        return ref == null ? snd : (SoundEffect)ref.a();
    }

    public static boolean isLeashed(NPC npc, Supplier<Boolean> isLeashed, EntityInsentient entity) {
        return NMS.isLeashed(npc, isLeashed, () -> entity.z());
    }

    public static void minecartItemLogic(EntityMinecartAbstract minecart) {
        NPC npc = ((NPCHolder)minecart).getNPC();
        if (npc == null) {
            return;
        }
        int offset = npc.data().get(NPC.Metadata.MINECART_OFFSET, Integer.valueOf(0));
        minecart.r(npc.data().has(NPC.Metadata.ITEM_ID));
        if (minecart.A()) {
            Material mat = npc.getItemProvider().get().getType();
            minecart.c(((Block)BuiltInRegistries.e.a(MinecraftKey.a((String)mat.getKey().toString()))).m());
        }
        minecart.c(offset);
    }

    public static boolean moveFish(NPC npc, EntityInsentient handle, Vec3D vec3d) {
        if (npc == null || npc.useMinecraftAI()) {
            return false;
        }
        if (handle.bj() && !npc.getNavigator().isNavigating()) {
            handle.a(handle instanceof EntityDolphin || handle instanceof Axolotl ? handle.fp() : (handle instanceof EntityTurtle ? 0.1f : 0.01f), vec3d);
            handle.a(EnumMoveType.a, handle.dy());
            handle.i(handle.dy().c(0.9));
            return true;
        }
        return false;
    }

    public static void moveLogic(EntityLiving entity, Vec3D v) {
        if (entity.dj() || entity.dh()) {
            boolean flag;
            double g = 0.08;
            boolean bl = flag = entity.dy().e <= 0.0;
            if (flag && entity.b(MobEffects.B)) {
                g = 0.01;
                entity.Z = 0.0f;
            }
            Fluid fluid = entity.dV().b_(entity.dv());
            if ((entity.bj() || entity.bx()) && !entity.a(fluid)) {
                Vec3D vec3d1;
                double d0 = entity.dC();
                double d1 = g;
                if (entity.bj()) {
                    float f = entity.cj() ? 0.9f : 0.8f;
                    float f1 = 0.02f;
                    float f2 = (float)entity.h(GenericAttributes.F);
                    if (!entity.aJ()) {
                        f2 *= 0.5f;
                    }
                    if (f2 > 0.0f) {
                        f += (0.54600006f - f) * f2;
                        f1 += (entity.fp() - f1) * f2;
                    }
                    if (entity.b(MobEffects.D)) {
                        f = 0.96f;
                    }
                    entity.a(f1, v);
                    entity.a(EnumMoveType.a, entity.dy());
                    Vec3D vec3d2 = entity.dy();
                    if (entity.P && entity.q_()) {
                        vec3d2 = new Vec3D(vec3d2.d, 0.2, vec3d2.f);
                    }
                    vec3d2 = vec3d2.d((double)f, (double)0.8f, (double)f);
                    entity.i(entity.a(d1, flag, vec3d2));
                } else {
                    entity.a(0.02f, v);
                    entity.a(EnumMoveType.a, entity.dy());
                    if (entity.b(TagsFluid.b) <= entity.dp()) {
                        entity.i(entity.dy().d(0.5, (double)0.8f, 0.5));
                        vec3d1 = entity.a(d1, flag, entity.dy());
                        entity.i(vec3d1);
                    } else {
                        entity.i(entity.dy().c(0.5));
                    }
                    if (d1 != 0.0) {
                        entity.i(entity.dy().b(0.0, -d1 / 4.0, 0.0));
                    }
                }
                vec3d1 = entity.dy();
                if (entity.P && entity.g(vec3d1.d, vec3d1.e + (double)0.6f - entity.dC() + d0, vec3d1.f)) {
                    entity.n(vec3d1.d, (double)0.3f, vec3d1.f);
                }
            } else if (entity.fJ()) {
                double dd;
                float ff;
                double d4;
                Vec3D vec3d = entity.dy();
                Vec3D vec3d1 = entity.bT();
                float f = entity.dN() * ((float)Math.PI / 180);
                double d0 = Math.sqrt(vec3d1.d * vec3d1.d + vec3d1.f * vec3d1.f);
                double d1 = vec3d.i();
                double d2 = g;
                double d3 = MathHelper.k((double)Math.cos(f));
                vec3d = vec3d.b(0.0, d2 * (-1.0 + d3 * 0.75), 0.0);
                if (vec3d.e < 0.0 && d0 > 0.0) {
                    d4 = vec3d.e * -0.1 * d3;
                    vec3d = vec3d.b(vec3d1.d * d4 / d0, d4, vec3d1.f * d4 / d0);
                }
                if (f < 0.0f && d0 > 0.0) {
                    d4 = d1 * (double)(-MathHelper.a((float)f)) * 0.04;
                    vec3d = vec3d.b(-vec3d1.d * d4 / d0, d4 * 3.2, -vec3d1.f * d4 / d0);
                }
                if (d0 > 0.0) {
                    vec3d = vec3d.b((vec3d1.d / d0 * d1 - vec3d.d) * 0.1, 0.0, (vec3d1.f / d0 * d1 - vec3d.f) * 0.1);
                }
                double h = vec3d.i();
                entity.i(vec3d.d(0.99, 0.98, 0.99));
                entity.a(EnumMoveType.a, entity.dy());
                if (entity.P && (ff = (float)((dd = h - entity.dy().i()) * 10.0 - 3.0)) > 0.0f) {
                    entity.a((int)f > 4 ? entity.eM().b() : entity.eM().a(), 1.0f, 1.0f);
                    entity.a(entity.dW().n(), f);
                }
            } else {
                double d0;
                BlockPosition blockposition = entity.aQ();
                float f = entity.aJ() ? entity.dV().a_(blockposition).b().g() : 1.0f;
                float f1 = f * 0.91f;
                entity.a(entity.aJ() ? entity.fp() * (0.21600002f / (f * f * f)) : (entity.cW() instanceof Player ? entity.fp() * 0.1f : 0.02f), v);
                if (entity.q_()) {
                    Vec3D vec3d = entity.dy();
                    entity.k();
                    d0 = MathHelper.a((double)vec3d.d, (double)-0.15, (double)0.15);
                    double d1 = MathHelper.a((double)vec3d.f, (double)-0.15, (double)0.15);
                    double d2 = Math.max(vec3d.e, -0.15);
                    if (d2 < 0.0 && !entity.dw().a(Blocks.ou) && entity.fI() && entity instanceof Player) {
                        d2 = 0.0;
                    }
                    vec3d = new Vec3D(d0, d2, d1);
                    entity.i(vec3d);
                }
                entity.a(EnumMoveType.a, entity.dy());
                Vec3D vec3d1 = entity.dy();
                if ((entity.P || NMS.shouldJump((Entity)entity.getBukkitEntity())) && (entity.q_() || entity.dw().a(Blocks.rr) && PowderSnowBlock.a((net.minecraft.world.entity.Entity)entity))) {
                    vec3d1 = new Vec3D(vec3d1.d, 0.2, vec3d1.f);
                }
                d0 = vec3d1.e;
                MobEffect mobeffect = entity.c(MobEffects.y);
                d0 = mobeffect != null ? (d0 += (0.05 * (double)(mobeffect.e() + 1) - vec3d1.e) * 0.2) : (entity.dV().C && !entity.dV().B(blockposition) ? (entity.dC() > (double)entity.dV().L_() ? -0.1 : 0.0) : (d0 -= g));
                if (entity.eu()) {
                    entity.n(vec3d1.d, d0, vec3d1.f);
                } else {
                    float f2 = entity instanceof EntityBird ? f1 : 0.98f;
                    entity.n(vec3d1.d * (double)f1, d0 * (double)f2, vec3d1.f * (double)f1);
                }
            }
        }
    }

    public static void resetPuffTicks(EntityPufferFish fish) {
        try {
            PUFFERFISH_INFLATE.invoke(fish, 0);
            PUFFERFISH_DEFLATE.invoke(fish, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void restoreGoals(NPC npc, PathfinderGoalSelector ... goalSelectors) {
        if (goalSelectors == null) {
            return;
        }
        int i = 0;
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                Set list = selector.b();
                list.clear();
                Collection old = (Collection)npc.data().get("selector" + i);
                if (old != null) {
                    list.addAll(old);
                }
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", e.getLocalizedMessage());
            }
            catch (Throwable e) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", e.getLocalizedMessage());
            }
            ++i;
        }
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        if (packet == null) {
            return;
        }
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).f.b(packet);
    }

    public static void sendPackets(Player player, Iterable<Packet<?>> packets) {
        if (packets == null) {
            return;
        }
        for (Packet<?> packet : packets) {
            ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).f.b(packet);
        }
    }

    public static void setAttribute(EntityLiving entity, Holder<AttributeBase> attribute, double value) {
        AttributeModifiable attr = entity.g(attribute);
        if (attr == null) {
            try {
                AttributeProvider provider = ATTRIBUTE_SUPPLIER.invoke(entity.eY());
                HashMap all = Maps.newHashMap((Map)ATTRIBUTE_PROVIDER_MAP.invoke(provider));
                all.put(attribute, new AttributeModifiable(attribute, att -> {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance FOLLOW_RANGE");
                }));
                ATTRIBUTE_PROVIDER_MAP_SETTER.invoke(provider, ImmutableMap.copyOf((Map)all));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            attr = entity.g(attribute);
        }
        attr.a(value);
    }

    public static void setBukkitEntity(net.minecraft.world.entity.Entity entity, CraftEntity bukkitEntity) {
        try {
            BUKKITENTITY_FIELD_SETTER.invoke(entity, bukkitEntity);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setFallingBlockState(EntityFallingBlock handle, IBlockData state) {
        try {
            FALLING_BLOCK_STATE_SETTER.invoke(handle, state);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setLife(EntityFishingHook entity, int life) {
        try {
            FISHING_HOOK_LIFE.invoke(entity, life);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setLookControl(EntityInsentient mob, ControllerLook control) {
        try {
            LOOK_CONTROL_SETTER.invoke(mob, control);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setNotInSchool(EntityFish entity) {
        try {
            if (ENTITY_FISH_NUM_IN_SCHOOL != null) {
                ENTITY_FISH_NUM_IN_SCHOOL.invoke(entity, 2);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void setScuteTime(net.minecraft.world.entity.Entity armadillo, int scuteTime) {
        if (ARMADILLO_SCUTE_TIME == null) {
            return;
        }
        try {
            ARMADILLO_SCUTE_TIME.invoke(armadillo, scuteTime);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.world.entity.Entity entity, boolean justCreated) {
        try {
            AttributeMapBase map;
            if (entity instanceof EntityLiving && (map = ((EntityLiving)entity).eY()).b(GenericAttributes.y) && Math.abs(map.c(GenericAttributes.y) - 1.0) > 0.01) {
                return;
            }
            EntitySize entitysize = SIZE_FIELD_GETTER.invoke(entity);
            EntityPose entitypose = entity.aw();
            EntitySize entitysize1 = entity.a(entitypose);
            SIZE_FIELD_SETTER.invoke(entity, entitysize1);
            ENTITY_EYE_HEIGHT.invoke(entity, entity.aq().n().c());
            if (entitysize1.a() < entitysize.a()) {
                // empty if block
            }
            AxisAlignedBB axisalignedbb = entity.cR();
            entity.a(new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c, axisalignedbb.a + (double)entitysize1.a(), axisalignedbb.b + (double)entitysize1.b(), axisalignedbb.c + (double)entitysize1.a()));
            if (entitysize1.a() > entitysize.a() && !justCreated && !entity.dV().C) {
                float f = entitysize.a() - entitysize1.a();
                entity.a(EnumMoveType.a, new Vec3D((double)f, 0.0, (double)f));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.world.entity.Entity entity, EntitySize size) {
        try {
            SIZE_FIELD_SETTER.invoke(entity, size);
            ENTITY_EYE_HEIGHT.invoke(entity, entity.aq().n().c());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static net.minecraft.world.entity.Entity teleportAcrossWorld(net.minecraft.world.entity.Entity entity, TeleportTransition transition) {
        if (entity.dQ()) {
            return null;
        }
        NPC npc = ((NPCHolder)entity).getNPC();
        if (npc == null) {
            return null;
        }
        npc.despawn(DespawnReason.PENDING_RESPAWN);
        npc.spawn(new Location((World)transition.b().getWorld(), transition.c().d, transition.c().e, transition.c().f, transition.e(), transition.f()));
        net.minecraft.world.entity.Entity handle = ((CraftEntity)npc.getEntity()).getHandle();
        handle.i(transition.d());
        handle.aV = entity.aV;
        return handle;
    }

    public static void updateAI(EntityLiving entity) {
        if (entity instanceof EntityInsentient) {
            EntityInsentient handle = (EntityInsentient)entity;
            handle.Q().a();
            handle.P().c();
            handle.N().a();
            handle.L().a();
            handle.O().b();
        } else if (entity instanceof MobAI) {
            ((MobAI)entity).tickAI();
        }
    }

    public static void updateMinecraftAIState(NPC npc, EntityInsentient entity) {
        if (npc == null) {
            return;
        }
        if (npc.useMinecraftAI()) {
            NMSImpl.restoreGoals(npc, entity.bS, entity.bT);
            if (npc.data().has("behavior-map")) {
                TreeMap behavior = (TreeMap)npc.data().get("behavior-map");
                NMSImpl.getBehaviorMap((EntityLiving)entity).putAll(behavior);
                npc.data().remove("behavior-map");
            }
        } else {
            NMSImpl.clearGoals(npc, entity.bS, entity.bT);
            TreeMap<?, ?> behaviorMap = NMSImpl.getBehaviorMap((EntityLiving)entity);
            if (behaviorMap.size() > 0) {
                npc.data().set("behavior-map", new TreeMap((SortedMap<?, ?>)behaviorMap));
                behaviorMap.clear();
            }
        }
    }

    static {
        FALLING_BLOCK_STATE_SETTER = NMS.getFirstSetter(EntityFallingBlock.class, IBlockData.class);
        FISHING_HOOK_LIFE = NMS.getSetter(EntityFishingHook.class, "h");
        FLYING_MOVECONTROL_FLOAT_GETTER = NMS.getFirstGetter(ControllerMoveFlying.class, Boolean.TYPE);
        FLYING_MOVECONTROL_FLOAT_SETTER = NMS.getFirstSetter(ControllerMoveFlying.class, Boolean.TYPE);
        FOX_SET_FACEPLANTED = NMS.getMethodHandle(EntityFox.class, "B", true, Boolean.TYPE);
        FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        INTERACTION_HEIGHT = (DataWatcherObject)NMS.getStaticObject(Interaction.class, "c");
        INTERACTION_WIDTH = (DataWatcherObject)NMS.getStaticObject(Interaction.class, "b");
        JUMP_FIELD = NMS.getGetter(EntityLiving.class, "bm");
        LOOK_CONTROL_SETTER = NMS.getFirstSetter(EntityInsentient.class, ControllerLook.class);
        MINECRAFT_CLIENT = NMS.getFirstGetter(YggdrasilMinecraftSessionService.class, MinecraftClient.class);
        MOONRISE_IS_REAL_PLAYER = NMS.getSetter(EntityPlayer.class, "isRealPlayer", false);
        MOVE_CONTROLLER_OPERATION = NMS.getSetter(ControllerMove.class, "k");
        NAVIGATION_CREATE_PATHFINDER = NMS.getFirstMethodHandleWithReturnType(NavigationAbstract.class, true, Pathfinder.class, Integer.TYPE);
        NAVIGATION_PATH = NMS.getFirstGetter(NavigationAbstract.class, PathEntity.class);
        NAVIGATION_PATHFINDER = NMS.getFirstFinalSetter(NavigationAbstract.class, Pathfinder.class);
        NAVIGATION_WORLD_FIELD = NMS.getFirstSetter(NavigationAbstract.class, net.minecraft.world.level.World.class);
        PAPER_PLAYER_MOB_COUNTS = NMS.getGetter(EntityPlayer.class, "mobCounts", false);
        PLAYERINFO_ENTRIES = PLAYER_INFO_ENTRIES_LIST = NMS.getFirstFinalSetter(ClientboundPlayerInfoUpdatePacket.class, List.class);
        POSITION_CODEC_GETTER = NMS.getFirstGetter(EntityTrackerEntry.class, VecDeltaCodec.class);
        PUFFERFISH_DEFLATE = NMS.getSetter(EntityPufferFish.class, "ca");
        PUFFERFISH_INFLATE = NMS.getSetter(EntityPufferFish.class, "bZ");
        RABBIT_TYPE_DATAWATCHER = (DataWatcherObject)NMS.getFirstStaticObject(EntityRabbit.class, DataWatcherObject.class);
        RANDOM = Util.getFastRandom();
        SERVER_ENTITY_GETTER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, EntityTrackerEntry.class);
        SERVER_ENTITY_TRACK_DELTA = NMS.getGetter(EntityTrackerEntry.class, "i");
        SERVER_ENTITY_UPDATE_INTERVAL = NMS.getGetter(EntityTrackerEntry.class, "h");
        SIZE_FIELD_GETTER = NMS.getFirstGetter(net.minecraft.world.entity.Entity.class, EntitySize.class);
        SIZE_FIELD_SETTER = NMS.getFirstSetter(net.minecraft.world.entity.Entity.class, EntitySize.class);
        TRACKED_ENTITY_SETTERS = NMS.getSettersOfType(net.minecraft.world.entity.Entity.class, PlayerChunkMap.EntityTracker.class);
        try {
            ENTITY_REGISTRY = new CustomEntityRegistry(BuiltInRegistries.f);
            ENTITY_REGISTRY_SETTER = NMS.getFinalSetter(BuiltInRegistries.class, "f");
            ENTITY_REGISTRY_SETTER.invoke(ENTITY_REGISTRY);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", e.getMessage());
        }
    }

    private static class MCTargetNavigator
    implements MCTargetStrategy.TargetNavigator {
        private final Entity entity;
        private final NavigationAbstract navigation;
        private final NavigatorParameters parameters;
        private final Entity target;

        private MCTargetNavigator(Entity entity, NavigationAbstract navigation, Entity target, NavigatorParameters parameters) {
            this.entity = entity;
            this.navigation = navigation;
            this.target = target;
            this.parameters = parameters;
        }

        @Override
        public Location getCurrentDestination() {
            return NMS.getDestination(this.entity);
        }

        @Override
        public Iterable<Vector> getPath() {
            return new NavigationIterable(this.navigation);
        }

        @Override
        public void setPath() {
            Location location = this.parameters.entityTargetLocationMapper().apply(this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            this.navigation.a(location.getX(), location.getY(), location.getZ(), (double)this.parameters.speedModifier());
        }

        @Override
        public void stop() {
            this.navigation.m();
        }

        @Override
        public void update() {
            this.navigation.c();
        }
    }

    private final class CitizensAnvilMenu
    extends ContainerAnvil {
        private final Inventory anvil;
        private CraftAnvilView bukkitEntity;

        private CitizensAnvilMenu(int i, PlayerInventory playerinventory, ContainerAccess containeraccess, Inventory anvil) {
            super(i, playerinventory, containeraccess);
            this.anvil = anvil;
        }

        protected void a(EntityHuman entityhuman, IInventory iinventory) {
        }

        public void l() {
            super.l();
            this.y.a(0);
        }

        public CraftAnvilView getBukkitView() {
            if (this.bukkitEntity == null) {
                this.bukkitEntity = new CraftAnvilView((HumanEntity)this.r.getBukkitEntity(), (AnvilInventory)new CitizensInventoryAnvil(this.q.getLocation(), this.s, (IInventory)this.t, this, this.anvil), (ContainerAnvil)this);
            }
            return this.bukkitEntity;
        }
    }

    private static class NavigationIterable
    implements Iterable<Vector> {
        private final NavigationAbstract navigation;

        public NavigationIterable(NavigationAbstract nav) {
            this.navigation = nav;
        }

        @Override
        public Iterator<Vector> iterator() {
            final PathEntity path = NMSImpl.getPathEntity(this.navigation);
            final int npoints = path == null ? 0 : path.e();
            return new Iterator<Vector>(){
                PathPoint curr;
                int i;
                {
                    this.curr = npoints > 0 ? path.a(0) : null;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public Vector next() {
                    PathPoint old = this.curr;
                    this.curr = this.i + 1 < npoints ? path.a(++this.i) : null;
                    return new Vector(old.a, old.b, old.c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class CitizensInventoryAnvil
    extends CraftInventoryAnvil
    implements ForwardingInventory {
        private final Inventory wrapped;

        public CitizensInventoryAnvil(Location location, IInventory inventory, IInventory resultInventory, ContainerAnvil container, Inventory wrapped) {
            super(location, inventory, resultInventory);
            this.wrapped = wrapped;
        }

        @Override
        public Inventory getWrapped() {
            return this.wrapped;
        }

        public void setItem(int slot, ItemStack item) {
            super.setItem(slot, item);
            this.wrapped.setItem(slot, item);
        }
    }
}

