/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.DelayTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class Waypoint {
    @Persist(required=true)
    private Location location;
    @Persist
    private List<WaypointTrigger> triggers;

    public Waypoint() {
    }

    public Waypoint(Location at) {
        this.location = at.clone();
    }

    public void addTrigger(WaypointTrigger trigger) {
        if (this.triggers == null) {
            this.triggers = Lists.newArrayList();
        }
        this.triggers.add(trigger);
    }

    public void describeTriggers(CommandSender sender) {
        String base = " ";
        if (this.triggers == null) {
            return;
        }
        for (int i = 0; i < this.triggers.size(); ++i) {
            base = base + "\n    - " + this.triggers.get(i).description() + " [<hover:show_text:Remove trigger><click:run_command:/npc path remove_trigger " + i + "><u><red>-</click></hover>]";
        }
        Messaging.sendTr(sender, "citizens.editors.waypoints.triggers.list", base);
    }

    public double distance(Waypoint dest) {
        return this.location.distance(dest.location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Waypoint other = (Waypoint)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.triggers, other.triggers);
    }

    public Location getLocation() {
        return this.location.clone();
    }

    public List<WaypointTrigger> getTriggers() {
        return this.triggers == null ? Collections.emptyList() : this.triggers;
    }

    public int hashCode() {
        int prime = 31;
        int result = prime + (this.location == null ? 0 : this.location.hashCode());
        return prime * result + (this.triggers == null ? 0 : this.triggers.hashCode());
    }

    public void onReach(NPC npc) {
        if (this.triggers == null) {
            return;
        }
        this.runTriggers(npc, 0);
    }

    private void runTriggers(NPC npc, int start) {
        ArrayList triggers = Lists.newArrayList(this.triggers);
        for (int i = start; i < triggers.size(); ++i) {
            int delay;
            WaypointTrigger trigger = (WaypointTrigger)triggers.get(i);
            trigger.onWaypointReached(npc, this.location.clone());
            if (!(trigger instanceof DelayTrigger) || (delay = ((DelayTrigger)trigger).getDelay()) <= 0) continue;
            int newStart = i + 1;
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> this.runTriggers(npc, newStart), (long)delay);
            break;
        }
    }

    public String toString() {
        return "Waypoint [" + this.location + (this.triggers == null ? "]" : ", " + this.triggers.size() + " triggers]");
    }

    static {
        PersistenceLoader.registerPersistDelegate(WaypointTrigger.class, WaypointTriggerRegistry.class);
    }
}

