/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.util.Vector;

public class FallingExaminer
implements BlockExaminer {
    private final Map<PathPoint, Integer> fall = Maps.newHashMap();
    private final int maxFallDistance;
    private final MinecraftBlockExaminer mc = new MinecraftBlockExaminer();

    public FallingExaminer(int maxFallDistance) {
        this.maxFallDistance = maxFallDistance;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return this.fall.containsKey(point) ? 0.25f : 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        if (!SpigotUtil.checkYSafe(pos.getBlockY() - 1, source.getWorld())) {
            return BlockExaminer.PassableState.IGNORE;
        }
        if (this.fall.containsKey(point)) {
            return BlockExaminer.PassableState.PASSABLE;
        }
        Vector ppos = point.getParentPoint().getVector();
        if (!MinecraftBlockExaminer.canStandOn(source.getBlockAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ()))) {
            Integer dist = this.fall.get(point.getParentPoint());
            if (dist == null && this.mc.isPassable(source, point.getParentPoint()) == BlockExaminer.PassableState.PASSABLE) {
                this.fall.put(point, 0);
                return BlockExaminer.PassableState.PASSABLE;
            }
            if (dist != null && dist < this.maxFallDistance && pos.getBlockY() < ppos.getBlockY() && pos.getBlockX() == ppos.getBlockX() && pos.getBlockZ() == ppos.getBlockZ() && MinecraftBlockExaminer.canStandIn(source.getBlockAt(pos))) {
                this.fall.put(point, dist + 1);
                return BlockExaminer.PassableState.PASSABLE;
            }
        }
        return BlockExaminer.PassableState.IGNORE;
    }
}

