/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.npc.skin.SkinnableEntity;

@TraitName(value="skinlayers")
public class SkinLayers
extends Trait {
    @Persist(value="cape")
    private boolean cape = true;
    @Persist(value="hat")
    private boolean hat = true;
    @Persist(value="jacket")
    private boolean jacket = true;
    @Persist(value="left-pants")
    private boolean leftPants = true;
    @Persist(value="left-sleeve")
    private boolean leftSleeve = true;
    @Persist(value="right-pants")
    private boolean rightPants = true;
    @Persist(value="right-sleeve")
    private boolean rightSleeve = true;

    public SkinLayers() {
        super("skinlayers");
    }

    public SkinLayers hide() {
        this.cape = false;
        this.hat = false;
        this.jacket = false;
        this.leftSleeve = false;
        this.rightSleeve = false;
        this.leftPants = false;
        this.rightPants = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideCape() {
        this.cape = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideHat() {
        this.hat = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideJacket() {
        this.jacket = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideLeftPants() {
        this.leftPants = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideLeftSleeve() {
        this.leftSleeve = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hidePants() {
        this.leftPants = false;
        this.rightPants = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideRightPants() {
        this.rightPants = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideRightSleeve() {
        this.rightSleeve = false;
        this.setFlags();
        return this;
    }

    public SkinLayers hideSleeves() {
        this.leftSleeve = false;
        this.rightSleeve = false;
        this.setFlags();
        return this;
    }

    public boolean isVisible(Layer layer) {
        switch (layer.ordinal()) {
            case 0: {
                return this.cape;
            }
            case 2: {
                return this.jacket;
            }
            case 4: {
                return this.leftSleeve;
            }
            case 6: {
                return this.rightSleeve;
            }
            case 3: {
                return this.leftPants;
            }
            case 5: {
                return this.rightPants;
            }
            case 1: {
                return this.hat;
            }
        }
        return false;
    }

    @Override
    public void onAttach() {
        this.setFlags();
    }

    @Override
    public void onSpawn() {
        this.setFlags();
    }

    private void setFlags() {
        if (!(this.npc.getEntity() instanceof SkinnableEntity)) {
            return;
        }
        SkinnableEntity skinnable = (SkinnableEntity)this.npc.getEntity();
        EnumSet<Layer> visible = EnumSet.noneOf(Layer.class);
        for (Layer layer : Layer.values()) {
            if (!this.isVisible(layer)) continue;
            visible.add(layer);
        }
        skinnable.setSkinFlags(visible);
    }

    public SkinLayers setVisible(Layer layer, boolean isVisible) {
        switch (layer.ordinal()) {
            case 0: {
                this.cape = isVisible;
                break;
            }
            case 2: {
                this.jacket = isVisible;
                break;
            }
            case 4: {
                this.leftSleeve = isVisible;
                break;
            }
            case 6: {
                this.rightSleeve = isVisible;
                break;
            }
            case 3: {
                this.leftPants = isVisible;
                break;
            }
            case 5: {
                this.rightPants = isVisible;
                break;
            }
            case 1: {
                this.hat = isVisible;
            }
        }
        this.setFlags();
        return this;
    }

    public SkinLayers show() {
        this.cape = true;
        this.hat = true;
        this.jacket = true;
        this.leftSleeve = true;
        this.rightSleeve = true;
        this.leftPants = true;
        this.rightPants = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showCape() {
        this.cape = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showHat() {
        this.hat = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showJacket() {
        this.jacket = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showLeftPants() {
        this.leftPants = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showLeftSleeve() {
        this.leftSleeve = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showPants() {
        this.leftPants = true;
        this.rightPants = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showRightPants() {
        this.rightPants = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showRightSleeve() {
        this.rightSleeve = true;
        this.setFlags();
        return this;
    }

    public SkinLayers showSleeves() {
        this.leftSleeve = true;
        this.rightSleeve = true;
        this.setFlags();
        return this;
    }

    public String toString() {
        return "SkinLayers{cape:" + this.cape + ", hat:" + this.hat + ", jacket:" + this.jacket + ", leftSleeve:" + this.leftSleeve + ", rightSleeve:" + this.rightSleeve + ", leftPants:" + this.leftPants + ", rightPants:" + this.rightPants + "}";
    }

    public static enum Layer {
        CAPE(0),
        HAT(6),
        JACKET(1),
        LEFT_PANTS(4),
        LEFT_SLEEVE(2),
        RIGHT_PANTS(5),
        RIGHT_SLEEVE(3);

        int flag;

        private Layer(int offset) {
            this.flag = 1 << offset;
        }

        public static byte toByte(Set<Layer> flags) {
            byte b = 0;
            for (Layer layer : flags) {
                b = (byte)(b | layer.flag);
            }
            return b;
        }
    }
}

