/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_20_R4.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_20_R4.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_20_R4.util.EntityNavigation;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public ControllerJump getJumpControl();

    public Map<PathType, Float> getMalus();

    public ControllerMove getMoveControl();

    public NavigationAbstract getNavigation();

    default public float getPathfindingMalus(PathType var1) {
        Map<PathType, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(PathType water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        NavigationAbstract nav = this.getNavigation();
        if (!nav.l()) {
            nav.c();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((EntityLiving)NMSImpl.getHandle(this.getBukkitEntity())).f(GenericAttributes.k).a((double)range);
    }

    public static MobAI from(net.minecraft.world.entity.Entity handle) {
        if (handle instanceof EntityInsentient) {
            final EntityInsentient mob = (EntityInsentient)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public ControllerJump getJumpControl() {
                    return mob.I();
                }

                @Override
                public Map<PathType, Float> getMalus() {
                    return null;
                }

                @Override
                public ControllerMove getMoveControl() {
                    return mob.H();
                }

                @Override
                public NavigationAbstract getNavigation() {
                    return mob.K();
                }

                @Override
                public float getPathfindingMalus(PathType var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(PathType water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.M().a();
                    mob.K().c();
                    mob.H().a();
                    mob.G().a();
                    mob.I().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public ControllerJump getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<PathType, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public ControllerMove getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public NavigationAbstract getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final EntityLiving entity;
        private final Map<PathType, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(EntityLiving entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (Holder<AttributeBase>)GenericAttributes.k, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.f(GenericAttributes.r).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.dP());
            this.malus = Maps.newEnumMap(PathType.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public ControllerJump getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<PathType, Float> getMalus() {
            return this.malus;
        }

        @Override
        public ControllerMove getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public NavigationAbstract getNavigation() {
            return this.navigation;
        }
    }
}

