/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persistable;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@TraitName(value="rotationtrait")
public class RotationTrait
extends Trait {
    @Persist(reify=true)
    private final RotationParams globalParameters = new RotationParams();
    private final RotationSession globalSession = new RotationSession(this.globalParameters);
    private List<PacketRotationSession> packetSessions = Lists.newCopyOnWriteArrayList();
    private final Map<UUID, PacketRotationSession> packetSessionsByUUID = Maps.newConcurrentMap();

    public RotationTrait() {
        super("rotationtrait");
    }

    public void clearPacketSessions() {
        this.packetSessions.clear();
        this.packetSessionsByUUID.clear();
    }

    public PacketRotationSession createPacketSession(RotationParams params) {
        if (params.filter == null && params.uuidFilter == null) {
            throw new IllegalStateException();
        }
        RotationSession session = new RotationSession(params);
        PacketRotationSession lrs = new PacketRotationSession(session);
        if (params.uuidFilter != null) {
            for (UUID uuid : params.uuidFilter) {
                this.packetSessionsByUUID.put(uuid, lrs);
            }
        } else {
            this.packetSessions.add(lrs);
        }
        return lrs;
    }

    private Location getEyeLocation() {
        return this.npc.getEntity() instanceof LivingEntity ? ((LivingEntity)this.npc.getEntity()).getEyeLocation() : this.npc.getEntity().getLocation();
    }

    public RotationParams getGlobalParameters() {
        return this.globalParameters;
    }

    public PacketRotationSession getPacketSession(Player player) {
        PacketRotationSession lrs = this.packetSessionsByUUID.get(player.getUniqueId());
        if (lrs != null && lrs.triple != null) {
            return lrs;
        }
        for (PacketRotationSession session : this.packetSessions) {
            if (!session.accepts(player) || session.triple == null) continue;
            return session;
        }
        return null;
    }

    public RotationSession getPhysicalSession() {
        return this.globalSession;
    }

    public void resetPlayerToPhysicalSession(UUID uuid) {
        PacketRotationSession prs = this.packetSessionsByUUID.remove(uuid);
        if (prs == null || !this.npc.isSpawned()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        NMS.sendPositionUpdate(this.npc.getEntity(), (Collection<Player>)ImmutableList.of((Object)player), false);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.npc.data().get(NPC.Metadata.RESET_PITCH_ON_TICK, Boolean.valueOf(false)).booleanValue()) {
            NMS.setPitch(this.npc.getEntity(), 0.0f);
        }
        HashSet ran = Sets.newHashSet();
        for (PacketRotationSession session : Iterables.concat(this.packetSessions, this.packetSessionsByUUID.values())) {
            if (ran.contains(session)) continue;
            ran.add(session);
            session.run(this.npc.getEntity());
        }
        this.packetSessions = Lists.newCopyOnWriteArrayList((Iterable)this.packetSessions.stream().filter(s -> s.isActive()).collect(Collectors.toCollection(CopyOnWriteArrayList::new)));
        this.packetSessionsByUUID.values().removeIf(s -> !s.isActive());
        if (this.npc.getNavigator().isNavigating()) {
            return;
        }
        this.globalSession.run(new EntityRotation(this.npc.getEntity()));
    }

    private static float clamp(float orig, float min, float max) {
        return Math.max(min, Math.min(max, orig));
    }

    public static class RotationParams
    implements Persistable,
    Cloneable {
        private Function<Player, Boolean> filter;
        private boolean headOnly = false;
        private boolean immediate = false;
        private boolean linkedBody;
        private float maxPitchPerTick = 10.0f;
        private float maxYawPerTick = 40.0f;
        private volatile boolean persist = false;
        private float[] pitchRange = new float[]{-180.0f, 180.0f};
        private List<UUID> uuidFilter;
        private float[] yawRange = new float[]{-180.0f, 180.0f};

        public boolean accepts(Player player) {
            return this.filter.apply(player);
        }

        public RotationParams clone() {
            try {
                return (RotationParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public String describe() {
            if (this.immediate) {
                return "immediately moves to target rotation";
            }
            return "rotates" + (this.headOnly ? " head " : "") + "to target moving [[" + this.maxPitchPerTick + "]] degrees in pitch and [[" + this.maxYawPerTick + "]] degrees in yaw per tick";
        }

        public RotationParams filter(Function<Player, Boolean> filter) {
            this.filter = filter;
            return this;
        }

        public RotationParams headOnly(boolean headOnly) {
            this.headOnly = headOnly;
            return this;
        }

        public RotationParams immediate(boolean immediate) {
            this.immediate = immediate;
            return this;
        }

        public RotationParams linkedBody(boolean linked) {
            this.linkedBody = linked;
            return this;
        }

        @Override
        public void load(DataKey key) {
            String[] parts;
            if (key.keyExists("headOnly")) {
                this.headOnly = key.getBoolean("headOnly");
            }
            if (key.keyExists("immediate")) {
                this.immediate = key.getBoolean("immediate");
            }
            if (key.keyExists("maxPitchPerTick")) {
                this.maxPitchPerTick = (float)key.getDouble("maxPitchPerTick");
            }
            if (key.keyExists("maxYawPerTick")) {
                this.maxYawPerTick = (float)key.getDouble("maxYawPerTick");
            }
            if (key.keyExists("linkedBody")) {
                this.linkedBody = key.getBoolean("linkedBody");
            }
            if (key.keyExists("yawRange")) {
                parts = key.getString("yawRange").split(",");
                this.yawRange = new float[]{Float.parseFloat(parts[0]), Float.parseFloat(parts[1])};
            }
            if (key.keyExists("pitchRange")) {
                parts = key.getString("pitchRange").split(",");
                this.pitchRange = new float[]{Float.parseFloat(parts[0]), Float.parseFloat(parts[1])};
            }
        }

        public RotationParams maxPitchPerTick(float val) {
            this.maxPitchPerTick = val;
            return this;
        }

        public RotationParams maxYawPerTick(float val) {
            this.maxYawPerTick = val;
            return this;
        }

        public RotationParams persist(boolean persist) {
            this.persist = persist;
            return this;
        }

        public RotationParams pitchRange(float[] val) {
            this.pitchRange = val;
            return this;
        }

        public float rotateHeadYawTowards(int t, float yaw, float targetYaw) {
            float out = this.rotateTowards(yaw, targetYaw, this.maxYawPerTick);
            return Util.clamp(out, this.yawRange[0], this.yawRange[1], 360.0f);
        }

        public float rotatePitchTowards(int t, float pitch, float targetPitch) {
            float out = this.rotateTowards(pitch, targetPitch, this.maxPitchPerTick);
            return Util.clamp(out, this.pitchRange[0], this.pitchRange[1], 360.0f);
        }

        private float rotateTowards(float target, float current, float maxRotPerTick) {
            float diff = Util.clamp(current - target);
            return target + RotationTrait.clamp(diff, -maxRotPerTick, maxRotPerTick);
        }

        @Override
        public void save(DataKey key) {
            if (this.headOnly) {
                key.setBoolean("headOnly", this.headOnly);
            }
            if (this.immediate) {
                key.setBoolean("immediate", this.immediate);
            }
            if (this.maxPitchPerTick != 10.0f) {
                key.setDouble("maxPitchPerTick", this.maxPitchPerTick);
            } else {
                key.removeKey("maxPitchPerTick");
            }
            if (this.maxYawPerTick != 40.0f) {
                key.setDouble("maxYawPerTick", this.maxYawPerTick);
            } else {
                key.removeKey("maxYawPerTick");
            }
            if (this.pitchRange[0] != -180.0f || this.pitchRange[1] != 180.0f) {
                key.setString("pitchRange", this.pitchRange[0] + "," + this.pitchRange[1]);
            } else {
                key.removeKey("pitchRange");
            }
            if (this.yawRange[0] != -180.0f || this.yawRange[1] != 180.0f) {
                key.setString("yawRange", this.yawRange[0] + "," + this.yawRange[1]);
            } else {
                key.removeKey("yawRange");
            }
        }

        public RotationParams uuidFilter(List<UUID> uuids) {
            this.uuidFilter = uuids;
            return this;
        }

        public RotationParams uuidFilter(UUID ... uuids) {
            return this.uuidFilter(Arrays.asList(uuids));
        }

        public RotationParams yawRange(float[] val) {
            this.yawRange = val;
            return this;
        }
    }

    public class RotationSession {
        private final RotationParams params;
        private volatile int t = -1;
        private Supplier<Float> targetPitch = () -> Float.valueOf(0.0f);
        private Supplier<Float> targetYaw = this.targetPitch;

        public RotationSession(RotationParams params) {
            this.params = params;
        }

        public float getTargetPitch() {
            return this.targetPitch.get().floatValue();
        }

        public float getTargetYaw() {
            switch (RotationTrait.this.npc.getEntity().getType()) {
                case PHANTOM: {
                    return Util.clamp(this.targetYaw.get().floatValue() + 45.0f);
                }
                case ENDER_DRAGON: {
                    return Util.clamp(this.targetYaw.get().floatValue() - 180.0f);
                }
            }
            return this.targetYaw.get().floatValue();
        }

        public boolean isActive() {
            return this.params.persist || this.t >= 0;
        }

        public void rotateToFace(Entity target) {
            this.rotateToFace(target instanceof LivingEntity ? ((LivingEntity)target).getEyeLocation() : target.getLocation());
        }

        public void rotateToFace(Location target) {
            this.t = 0;
            this.targetPitch = () -> {
                Location from = RotationTrait.this.getEyeLocation();
                double dx = target.getX() - from.getX();
                double dy = target.getY() - from.getY();
                double dz = target.getZ() - from.getZ();
                double diag = Math.sqrt((float)(dx * dx + dz * dz));
                return Float.valueOf((float)(-Math.toDegrees(Math.atan2(dy, diag))));
            };
            this.targetYaw = () -> {
                Location from = RotationTrait.this.getEyeLocation();
                return Float.valueOf((float)Math.toDegrees(Math.atan2(target.getZ() - from.getZ(), target.getX() - from.getX())) - 90.0f);
            };
        }

        public void rotateToHave(float yaw, float pitch) {
            this.t = 0;
            this.targetYaw = () -> Float.valueOf(yaw);
            this.targetPitch = () -> Float.valueOf(pitch);
        }

        private void run(RotationTriple rot) {
            if (!this.isActive()) {
                return;
            }
            float f = rot.headYaw = this.params.immediate ? this.getTargetYaw() : Util.clamp(this.params.rotateHeadYawTowards(this.t, rot.headYaw, this.getTargetYaw()));
            if (!this.params.headOnly) {
                float lo = Util.clamp(rot.headYaw - 20.0f);
                float hi = Util.clamp(rot.headYaw + 20.0f);
                if (hi < 0.0f && lo > 0.0f) {
                    float i = hi;
                    hi = lo;
                    lo = i;
                }
                boolean contained = false;
                float body = Util.clamp(rot.bodyYaw);
                if (hi > 0.0f && lo < 0.0f) {
                    contained = body >= hi || body <= lo;
                } else {
                    boolean bl = contained = body >= lo && body <= hi;
                }
                if (!contained) {
                    rot.bodyYaw = Math.abs(body - lo) > Math.abs(body - hi) ? hi : lo;
                }
            }
            rot.pitch = this.params.immediate ? this.getTargetPitch() : this.params.rotatePitchTowards(this.t, rot.pitch, this.getTargetPitch());
            ++this.t;
            if (this.params.linkedBody) {
                rot.bodyYaw = rot.headYaw;
            }
            if ((double)(Math.abs(rot.pitch - this.getTargetPitch()) + Math.abs(rot.headYaw - this.getTargetYaw())) < 0.1) {
                this.t = -1;
                if (!this.params.headOnly) {
                    rot.bodyYaw = rot.headYaw;
                }
            }
            rot.apply();
        }
    }

    public static class PacketRotationSession {
        private volatile boolean ended;
        private final RotationSession session;
        private volatile PacketRotationTriple triple;

        public PacketRotationSession(RotationSession session) {
            this.session = session;
        }

        public boolean accepts(Player player) {
            return this.session.params.accepts(player);
        }

        public void end() {
            this.ended = true;
        }

        public float getBodyYaw() {
            return this.triple.bodyYaw;
        }

        public float getHeadYaw() {
            return this.triple.headYaw;
        }

        public float getPitch() {
            return this.triple.pitch;
        }

        public RotationSession getSession() {
            return this.session;
        }

        public boolean isActive() {
            return !this.ended && this.session.isActive();
        }

        public void onPacketOverwritten() {
            if (this.triple == null) {
                return;
            }
            this.triple.record();
        }

        public void run(Entity entity) {
            if (this.triple == null) {
                this.triple = new PacketRotationTriple(entity);
            }
            this.session.run(this.triple);
            if (!this.session.isActive()) {
                this.triple = null;
            }
        }
    }

    private static class PacketRotationTriple
    extends EntityRotation {
        private volatile float lastBodyYaw;
        private volatile float lastHeadYaw;
        private volatile float lastPitch;

        public PacketRotationTriple(Entity entity) {
            super(entity);
        }

        @Override
        public void apply() {
            if (Math.abs(this.lastBodyYaw - this.bodyYaw) + Math.abs(this.lastHeadYaw - this.headYaw) + Math.abs(this.pitch - this.lastPitch) > 1.0f) {
                NMS.sendPositionUpdateNearby(this.entity, false, Float.valueOf(this.bodyYaw), Float.valueOf(this.pitch), Float.valueOf(this.headYaw));
            }
        }

        public void record() {
            this.lastBodyYaw = this.bodyYaw;
            this.lastHeadYaw = this.headYaw;
            this.lastPitch = this.pitch;
        }
    }

    private static class EntityRotation
    extends RotationTriple {
        protected Entity entity;

        public EntityRotation(Entity entity) {
            super(NMS.getYaw(entity), NMS.getHeadYaw(entity), entity.getLocation().getPitch());
            this.entity = entity;
        }

        @Override
        public void apply() {
            NMS.setBodyYaw(this.entity, this.bodyYaw);
            NMS.setHeadYaw(this.entity, this.headYaw);
            NMS.setPitch(this.entity, this.pitch);
        }
    }

    private static abstract class RotationTriple
    implements Cloneable {
        public float bodyYaw;
        public float headYaw;
        public float pitch;

        public RotationTriple(float bodyYaw, float headYaw, float pitch) {
            this.bodyYaw = bodyYaw;
            this.headYaw = headYaw;
            this.pitch = pitch;
        }

        public abstract void apply();

        public RotationTriple clone() {
            try {
                return (RotationTriple)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

