/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftRabbit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Rabbit;

public class RabbitController
extends MobEntityController {
    public RabbitController() {
        super(EntityRabbitNPC.class, EntityTypes.aZ);
    }

    public Rabbit getBukkitEntity() {
        return (Rabbit)super.getBukkitEntity();
    }

    public static class EntityRabbitNPC
    extends EntityRabbit
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityRabbitNPC(EntityTypes<? extends EntityRabbit> types, World level) {
            this(types, level, null);
        }

        public EntityRabbitNPC(EntityTypes<? extends EntityRabbit> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public boolean a(double f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dH() {
            if (this.npc == null) {
                super.dH();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            super.a(level);
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                if (this.npc.getNavigator().isNavigating()) {
                    NMS.setShouldJump((Entity)this.getBukkitEntity());
                }
                this.npc.update();
            }
        }

        protected SoundEffect s() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new RabbitNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect j_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.j_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fh() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fh());
        }

        public int cE() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cE());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction i_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.i_();
        }

        public EntityLiving e() {
            return this.npc != null ? null : super.e();
        }

        public boolean Q_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.Q_(), (EntityInsentient)this);
        }

        public boolean bG() {
            return this.npc == null ? super.bG() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean k_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.k_();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean g(NBTTagCompound save) {
            return this.npc == null ? super.g(save) : false;
        }

        public void a(EntityRabbit.Variant variant) {
            if (this.npc == null) {
                super.a(variant);
                return;
            }
            if (this.npc.useMinecraftAI()) {
                if (this.bF.b().size() == 0) {
                    this.C();
                }
                super.a(variant);
                NMSImpl.clearGoals((NPC)this.npc, this.bF, this.bG);
            } else if (NMSImpl.RABBIT_TYPE_DATAWATCHER != null) {
                this.al.a(NMSImpl.RABBIT_TYPE_DATAWATCHER, (Object)variant.a());
            }
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void a_(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a_(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class RabbitNPC
    extends CraftRabbit
    implements ForwardingNPCHolder {
        public RabbitNPC(EntityRabbitNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityRabbit)entity);
        }
    }
}

