/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.AttributeTrait;
import net.citizensnpcs.trait.BatTrait;
import net.citizensnpcs.trait.BoundingBoxTrait;
import net.citizensnpcs.trait.ChunkTicketTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.DropsTrait;
import net.citizensnpcs.trait.EnderCrystalTrait;
import net.citizensnpcs.trait.EndermanTrait;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.FollowTrait;
import net.citizensnpcs.trait.ForcefieldTrait;
import net.citizensnpcs.trait.GameModeTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.HomeTrait;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.trait.ItemFrameTrait;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.trait.OcelotModifiers;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.PaintingTrait;
import net.citizensnpcs.trait.PausePathfindingTrait;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.RabbitType;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.Saddle;
import net.citizensnpcs.trait.ScaledMaxHealthTrait;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.SheepTrait;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.trait.SleepTrait;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.SneakTrait;
import net.citizensnpcs.trait.TargetableTrait;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.WitherTrait;
import net.citizensnpcs.trait.WolfModifiers;
import net.citizensnpcs.trait.WoolColor;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Player;

public class CitizensTraitFactory
implements TraitFactory {
    private final List<TraitInfo> defaultTraits = Lists.newArrayList();
    private final Map<String, TraitInfo> registered = Maps.newHashMap();

    public CitizensTraitFactory(Citizens plugin) {
        this.registerTrait(TraitInfo.create(Age.class));
        this.registerTrait(TraitInfo.create(ArmorStandTrait.class));
        this.registerTrait(TraitInfo.create(AttributeTrait.class));
        this.registerTrait(TraitInfo.create(Anchors.class).optInToStats());
        this.registerTrait(TraitInfo.create(BatTrait.class));
        this.registerTrait(TraitInfo.create(BoundingBoxTrait.class));
        this.registerTrait(TraitInfo.create(ClickRedirectTrait.class));
        this.registerTrait(TraitInfo.create(ChunkTicketTrait.class));
        this.registerTrait(TraitInfo.create(CommandTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(Controllable.class).optInToStats());
        this.registerTrait(TraitInfo.create(CurrentLocation.class));
        this.registerTrait(TraitInfo.create(DropsTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(EnderCrystalTrait.class));
        this.registerTrait(TraitInfo.create(EndermanTrait.class));
        this.registerTrait(TraitInfo.create(EntityPoseTrait.class));
        this.registerTrait(TraitInfo.create(Equipment.class));
        this.registerTrait(TraitInfo.create(FollowTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(ForcefieldTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(GameModeTrait.class));
        this.registerTrait(TraitInfo.create(Gravity.class));
        this.registerTrait(TraitInfo.create(HomeTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(HorseModifiers.class));
        this.registerTrait(TraitInfo.create(HologramTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(Inventory.class));
        this.registerTrait(TraitInfo.create(ItemFrameTrait.class));
        this.registerTrait(TraitInfo.create(LookClose.class).optInToStats());
        this.registerTrait(TraitInfo.create(PaintingTrait.class));
        this.registerTrait(TraitInfo.create(MirrorTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(MountTrait.class));
        this.registerTrait(TraitInfo.create(MobType.class).asDefaultTrait());
        this.registerTrait(TraitInfo.create(OcelotModifiers.class));
        this.registerTrait(TraitInfo.create(Owner.class));
        this.registerTrait(TraitInfo.create(PacketNPC.class).optInToStats());
        this.registerTrait(TraitInfo.create(PausePathfindingTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(PlayerFilter.class).optInToStats().withSupplier(() -> new PlayerFilter((p, e) -> {
            EntityPacketTracker ept = NMS.getPacketTracker(e);
            if (ept != null) {
                ept.unlink((Player)p);
            }
        }, (p, e) -> {
            EntityPacketTracker ept = NMS.getPacketTracker(e);
            if (ept != null) {
                ept.link((Player)p);
            }
        })));
        this.registerTrait(TraitInfo.create(Poses.class).optInToStats());
        this.registerTrait(TraitInfo.create(Powered.class));
        this.registerTrait(TraitInfo.create(RabbitType.class));
        this.registerTrait(TraitInfo.create(RotationTrait.class));
        this.registerTrait(TraitInfo.create(Saddle.class));
        this.registerTrait(TraitInfo.create(ScaledMaxHealthTrait.class));
        this.registerTrait(TraitInfo.create(ScoreboardTrait.class));
        this.registerTrait(TraitInfo.create(SitTrait.class).optInToStats());
        this.registerTrait(TraitInfo.create(ShopTrait.class).optInToStats().withSupplier(() -> new ShopTrait(plugin.getShops())));
        this.registerTrait(TraitInfo.create(SleepTrait.class));
        this.registerTrait(TraitInfo.create(SheepTrait.class));
        this.registerTrait(TraitInfo.create(SkinLayers.class));
        this.registerTrait(TraitInfo.create(SkinTrait.class));
        this.registerTrait(TraitInfo.create(SneakTrait.class));
        this.registerTrait(TraitInfo.create(SlimeSize.class));
        this.registerTrait(TraitInfo.create(Spawned.class));
        this.registerTrait(TraitInfo.create(Text.class).optInToStats());
        this.registerTrait(TraitInfo.create(TargetableTrait.class));
        this.registerTrait(TraitInfo.create(Waypoints.class).optInToStats());
        this.registerTrait(TraitInfo.create(WitherTrait.class));
        this.registerTrait(TraitInfo.create(WoolColor.class));
        this.registerTrait(TraitInfo.create(WolfModifiers.class));
        this.registerTrait(TraitInfo.create(VillagerProfession.class));
    }

    @Override
    public void addDefaultTraits(NPC npc) {
        for (TraitInfo info : this.defaultTraits) {
            npc.addTrait((Trait)this.create(info));
        }
    }

    private <T extends Trait> T create(TraitInfo info) {
        return info.tryCreateInstance();
    }

    @Override
    public void deregisterTrait(TraitInfo info) {
        Objects.requireNonNull(info, "info cannot be null");
        this.registered.remove(info.getTraitName());
    }

    @Override
    public Collection<TraitInfo> getRegisteredTraits() {
        return this.registered.values();
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        for (TraitInfo entry : this.registered.values()) {
            if (clazz != entry.getTraitClass()) continue;
            return this.create(entry);
        }
        return null;
    }

    @Override
    public <T extends Trait> T getTrait(String name) {
        TraitInfo info = this.registered.get(name.toLowerCase(Locale.ROOT));
        if (info == null) {
            return null;
        }
        return this.create(info);
    }

    @Override
    public Class<? extends Trait> getTraitClass(String name) {
        TraitInfo info = this.registered.get(name.toLowerCase(Locale.ROOT));
        return info == null ? null : info.getTraitClass();
    }

    @Override
    public void registerTrait(TraitInfo info) {
        Objects.requireNonNull(info, "info cannot be null");
        info.checkValid();
        if (this.registered.containsKey(info.getTraitName())) {
            throw new IllegalArgumentException("Trait name " + info.getTraitName() + " already registered");
        }
        this.registered.put(info.getTraitName(), info);
        if (info.isDefaultTrait()) {
            this.defaultTraits.add(info);
        }
        info.registerListener(CitizensAPI.getPlugin());
    }

    public boolean trackStats(Trait trait) {
        return this.registered.get(trait.getName()).shouldTrackStats();
    }
}

