/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.npc.CitizensNPC;

public class Template {
    private final String name;
    private final boolean override;
    private final Map<String, Object> replacements;
    private static YamlStorage templates = new YamlStorage(CitizensAPI.getDataFolder(), "templates.yml");

    private Template(String name, Map<String, Object> replacements, boolean override) {
        this.replacements = replacements;
        this.override = override;
        this.name = name;
    }

    public void apply(NPC npc) {
    }

    public static Template byName(String name) {
        if (!templates.getKey("").keyExists(name)) {
            return null;
        }
        YamlStorage.YamlKey key = templates.getKey(name);
        boolean override = key.getBoolean("override", false);
        Map<String, Object> replacements = key.getRelative("replacements").getValuesDeep();
        return new Template(name, replacements, override);
    }

    static {
        templates.load();
    }

    public static class TemplateBuilder {
        private final String name;
        private boolean override;
        private final Map<String, Object> replacements = Maps.newHashMap();

        private TemplateBuilder(String name) {
            this.name = name;
        }

        public Template buildAndSave() {
            this.save();
            return new Template(this.name, this.replacements, this.override);
        }

        public TemplateBuilder from(NPC npc) {
            this.replacements.clear();
            MemoryDataKey key = new MemoryDataKey();
            ((CitizensNPC)npc).save(key);
            this.replacements.putAll(key.getRawTree());
            return this;
        }

        public TemplateBuilder override(boolean override) {
            this.override = override;
            return this;
        }

        public void save() {
            YamlStorage.YamlKey root = templates.getKey(this.name);
            ((DataKey)root).setBoolean("override", this.override);
            ((DataKey)root).setRaw("replacements", this.replacements);
            templates.save();
        }

        public static TemplateBuilder create(String name) {
            return new TemplateBuilder(name);
        }
    }
}

