/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityVillager;
import net.minecraft.server.World;
import org.bukkit.entity.Villager;
import org.bukkit.util.Vector;

public class CitizensVillagerNPC
extends CitizensMobNPC {
    public CitizensVillagerNPC(int id, String name) {
        super(id, name, EntityVillagerNPC.class);
    }

    public Villager getBukkitEntity() {
        return (Villager)super.getBukkitEntity();
    }

    public static class EntityVillagerNPC
    extends EntityVillager
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityVillagerNPC(World world) {
            this(world, null);
        }

        public EntityVillagerNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void bb() {
            if (this.npc == null) {
                super.bb();
            }
        }

        public void bc() {
            super.bc();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public boolean c(EntityHuman entityhuman) {
            if (this.npc == null) {
                return super.c(entityhuman);
            }
            return false;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, entity);
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

