/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.versioned.AreaEffectCloudTrait;
import net.citizensnpcs.trait.versioned.DisplayTrait;
import net.citizensnpcs.trait.versioned.TextDisplayTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@TraitName(value="hologramtrait")
public class HologramTrait
extends Trait {
    private HologramRenderer defaultRenderer;
    private double lastEntityBbHeight = 0.0;
    private Location lastLoc;
    private boolean lastNameplateVisible;
    @Persist
    private double lineHeight = -1.0;
    private final List<HologramLine> lines = Lists.newArrayList();
    private HologramLine nameLine;
    private final NPCRegistry registry = CitizensAPI.getTemporaryNPCRegistry();
    private int t;
    @Persist
    private int viewRange = -1;
    private static final Pattern ITEM_MATCHER = Pattern.compile("<item:((?:minecraft:)?[a-zA-Z0-9_ ]*?)(:.*?)?>");
    private static boolean SUPPORTS_DISPLAY = true;

    public HologramTrait() {
        super("hologramtrait");
        if (Settings.Setting.DEFAULT_HOLOGRAM_RENDERER_SETTINGS.asSection() != null) {
            this.defaultRenderer = this.createHologramRenderer();
            MemoryDataKey key = new MemoryDataKey();
            ((DataKey)key).setRaw("", Settings.Setting.DEFAULT_HOLOGRAM_RENDERER_SETTINGS.asSection());
            PersistenceLoader.load(this.defaultRenderer, (DataKey)key);
        }
    }

    public void addLine(String text) {
        this.lines.add(new HologramLine(text, true, -1, this.createHologramRenderer()));
        this.reloadLineHolograms();
    }

    public void addLine(String text, HologramRenderer hr) {
        this.lines.add(new HologramLine(text, hr));
        this.reloadLineHolograms();
    }

    public void addTemporaryLine(String text, int ticks) {
        this.lines.add(new HologramLine(text, false, ticks, this.createHologramRenderer()));
        this.reloadLineHolograms();
    }

    public void addTemporaryLine(String text, int ticks, HologramRenderer hr) {
        this.lines.add(new HologramLine(text, false, ticks, hr));
        this.reloadLineHolograms();
    }

    public void clear() {
        for (HologramLine line : this.lines) {
            line.removeNPC();
        }
        this.lines.clear();
    }

    private HologramRenderer createHologramRenderer() {
        HologramRenderer renderer = this.createRenderer(Settings.Setting.DEFAULT_HOLOGRAM_RENDERER.asString());
        if (HologramRendererCreateEvent.handlers.getRegisteredListeners().length > 0) {
            HologramRendererCreateEvent event = new HologramRendererCreateEvent(this.npc, renderer, false);
            Bukkit.getPluginManager().callEvent((Event)event);
            renderer = event.getRenderer();
        }
        return renderer;
    }

    private HologramRenderer createNameRenderer() {
        String setting = this.defaultRenderer instanceof TextDisplayRenderer ? "display" : (SpigotUtil.getVersion()[1] >= 20 ? "armorstand_vehicle" : "armorstand");
        HologramRenderer renderer = this.createRenderer(setting);
        if (HologramRendererCreateEvent.handlers.getRegisteredListeners().length > 0) {
            HologramRendererCreateEvent event = new HologramRendererCreateEvent(this.npc, renderer, true);
            Bukkit.getPluginManager().callEvent((Event)event);
            renderer = event.getRenderer();
        }
        return renderer;
    }

    private HologramRenderer createRenderer(String setting) {
        if (this.defaultRenderer != null) {
            return this.defaultRenderer.copy();
        }
        if (!SUPPORTS_DISPLAY) {
            setting = SpigotUtil.getVersion()[1] <= 8 ? "armorstand" : "areaeffectcloud";
        }
        switch (setting) {
            case "areaeffectcloud": {
                return new AreaEffectCloudRenderer();
            }
            case "armorstand_vehicle": {
                return new ArmorstandVehicleRenderer();
            }
            case "display": {
                return new TextDisplayRenderer();
            }
            case "display_vehicle": {
                return new TextDisplayVehicleRenderer();
            }
            case "interaction": {
                return new InteractionVehicleRenderer();
            }
        }
        return new ArmorstandRenderer();
    }

    private double getHeight(int lineNumber) {
        double base = this.lastNameplateVisible ? 0.0 : -this.getLineHeight();
        for (int i = 0; i <= lineNumber; ++i) {
            HologramLine line = this.lines.get(i);
            base += line.mb + this.getLineHeight();
            if (i == lineNumber) continue;
            base += line.mt;
        }
        return base;
    }

    @Deprecated
    public Collection<Entity> getHologramEntities() {
        return this.lines.stream().flatMap(l -> l.renderer.getEntities().stream()).collect(Collectors.toList());
    }

    public Collection<HologramRenderer> getHologramRenderers() {
        return this.lines.stream().map(l -> l.renderer).collect(Collectors.toList());
    }

    public double getLineHeight() {
        return this.lineHeight == -1.0 ? Settings.Setting.DEFAULT_NPC_HOLOGRAM_LINE_HEIGHT.asDouble() : this.lineHeight;
    }

    public List<String> getLines() {
        return Lists.transform(this.lines, l -> l.text);
    }

    @Deprecated
    public Entity getNameEntity() {
        return this.nameLine == null || this.nameLine.renderer.getEntities().size() == 0 ? null : this.nameLine.renderer.getEntities().iterator().next();
    }

    public HologramRenderer getNameRenderer() {
        return this.nameLine == null ? null : this.nameLine.renderer;
    }

    public HologramRenderer getTemplateRenderer() {
        return this.defaultRenderer == null ? (this.defaultRenderer = new TextDisplayRenderer()) : this.defaultRenderer;
    }

    public int getViewRange() {
        return this.viewRange;
    }

    public void insertLine(int idx, String text) {
        this.lines.add(idx, new HologramLine(text, true, -1, this.createHologramRenderer()));
        this.reloadLineHolograms();
    }

    @Override
    public void load(DataKey root) {
        this.clear();
        if (!root.getString("renderer_template.type", "").isEmpty()) {
            this.defaultRenderer = null;
            this.defaultRenderer = PersistenceLoader.load(this.createRenderer(root.getString("renderer_template.type")), root.getRelative("renderer_template"));
        }
        for (DataKey key : root.getRelative("lines").getIntegerSubKeys()) {
            HologramLine line = new HologramLine(key.keyExists("text") ? key.getString("text") : key.getString(""), true, -1, this.createHologramRenderer());
            line.mt = key.keyExists("margin.top") ? key.getDouble("margin.top") : 0.0;
            double d = line.mb = key.keyExists("margin.bottom") ? key.getDouble("margin.bottom") : 0.0;
            if (key.keyExists("renderer")) {
                PersistenceLoader.load(line.renderer, key.getRelative("renderer"));
            }
            this.lines.add(line);
        }
    }

    @Override
    public void onDespawn() {
        this.reloadLineHolograms();
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void onSpawn() {
        if (!this.npc.isSpawned()) {
            return;
        }
        this.lastNameplateVisible = Boolean.parseBoolean(((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString());
    }

    private void reloadLineHolograms() {
        for (HologramLine line : this.lines) {
            line.removeNPC();
        }
        if (this.nameLine != null) {
            this.nameLine.removeNPC();
            this.nameLine = null;
        }
    }

    public void removeLine(int idx) {
        if (idx < 0 || idx >= this.lines.size()) {
            return;
        }
        this.lines.remove(idx).removeNPC();
        this.reloadLineHolograms();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            this.onDespawn();
            return;
        }
        boolean nameplateVisible = Boolean.parseBoolean(((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString());
        if (this.npc.requiresNameHologram()) {
            if (this.nameLine != null && !nameplateVisible) {
                this.nameLine.removeNPC();
                this.nameLine = null;
            } else if (this.nameLine == null && nameplateVisible) {
                this.nameLine = new HologramLine(this.npc.getRawName(), this.createNameRenderer());
            }
        }
        Location npcLoc = this.npc.getEntity().getLocation();
        Vector3d offset = new Vector3d();
        boolean updatePosition = Settings.Setting.HOLOGRAM_ALWAYS_UPDATE_POSITION.asBoolean() || this.lastLoc == null || this.lastLoc.getWorld() != npcLoc.getWorld() || this.lastLoc.distance(npcLoc) >= 0.001 || this.lastNameplateVisible != nameplateVisible || Math.abs(this.lastEntityBbHeight - NMS.getBoundingBoxHeight(this.npc.getEntity())) >= 0.05;
        boolean updateText = false;
        if (this.t++ >= Settings.Setting.HOLOGRAM_UPDATE_RATE.asTicks() + Util.getFastRandom().nextInt(3)) {
            this.t = 0;
            updateText = true;
        }
        this.lastNameplateVisible = nameplateVisible;
        if (updatePosition) {
            this.lastLoc = npcLoc.clone();
            this.lastEntityBbHeight = NMS.getBoundingBoxHeight(this.npc.getEntity());
        }
        if (this.nameLine != null) {
            if (updateText) {
                this.nameLine.setText(this.npc.getRawName());
            }
            if (updatePosition || this.nameLine.renderer.getEntities().size() == 0) {
                this.nameLine.render(offset);
                this.nameLine.renderer.getEntities().forEach(e -> NMS.setSneaking(e, NMS.isSneaking(this.npc.getEntity())));
            }
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            if (line.ticks > 0 && --line.ticks == 0) {
                this.lines.remove(i--).removeNPC();
                continue;
            }
            if (updatePosition || line.renderer.getEntities().size() == 0) {
                offset.y = this.getHeight(i);
                line.render(offset);
            }
            if (!updateText) continue;
            line.setText(line.text);
        }
    }

    @Override
    public void save(DataKey root) {
        root.removeKey("renderer_template");
        if (this.defaultRenderer != null) {
            root.setString("renderer_template.type", this.defaultRenderer instanceof TextDisplayRenderer ? "display" : (this.defaultRenderer instanceof AreaEffectCloudRenderer ? "areaeffectcloud" : (this.defaultRenderer instanceof InteractionVehicleRenderer ? "interaction" : "")));
            PersistenceLoader.save(this.defaultRenderer, root.getRelative("renderer_template"));
        }
        root.removeKey("lines");
        int i = 0;
        for (HologramLine line : this.lines) {
            if (!line.persist) continue;
            PersistenceLoader.save(line.renderer, root.getRelative("lines." + i + ".renderer"));
            root.setString("lines." + i + ".text", line.text);
            root.setDouble("lines." + i + ".margin.top", line.mt);
            root.setDouble("lines." + i + ".margin.bottom", line.mb);
            ++i;
        }
    }

    public void setLine(int idx, String text) {
        if (idx == this.lines.size()) {
            this.addLine(text);
            return;
        }
        this.lines.get(idx).setText(text);
        this.reloadLineHolograms();
    }

    public void setLineHeight(double height) {
        this.lineHeight = height;
        this.reloadLineHolograms();
    }

    public void setMargin(int idx, String type, double margin) {
        if (type.equalsIgnoreCase("top")) {
            this.lines.get((int)idx).mt = margin;
        } else if (type.equalsIgnoreCase("bottom")) {
            this.lines.get((int)idx).mb = margin;
        }
        this.reloadLineHolograms();
    }

    public void setViewRange(int range) {
        this.viewRange = range;
        this.reloadLineHolograms();
    }

    static {
        try {
            Class.forName("org.bukkit.entity.Display");
        }
        catch (ClassNotFoundException e) {
            SUPPORTS_DISPLAY = false;
        }
    }

    public static interface HologramRenderer {
        default public HologramRenderer copy() {
            try {
                return (HologramRenderer)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void destroy();

        public Collection<Entity> getEntities();

        public String getPerPlayerText(NPC var1, Player var2);

        default public NPC getTemplateNPC() {
            return null;
        }

        default public boolean isSneaking(NPC npc, Player player) {
            return NMS.isSneaking(npc.getEntity());
        }

        default public void onSeenByPlayer(NPC hologram, Player player) {
        }

        public void render(NPC var1, Vector3d var2);

        public void updateText(NPC var1, String var2);
    }

    class HologramLine {
        double mb;
        double mt;
        boolean persist;
        HologramRenderer renderer;
        String text;
        int ticks;

        public HologramLine(String text, boolean persist, int ticks, HologramRenderer hr) {
            if (ITEM_MATCHER.matcher(text).find()) {
                this.mb = 0.21;
                this.mt = 0.07;
                hr = new ItemRenderer();
            }
            this.persist = persist;
            this.ticks = ticks;
            this.renderer = hr;
            if (this.renderer instanceof SingleEntityHologramRenderer) {
                SingleEntityHologramRenderer sr = (SingleEntityHologramRenderer)this.renderer;
                sr.setViewRange(HologramTrait.this.viewRange);
                sr.setRegistry(HologramTrait.this.registry);
            }
            this.setText(text);
        }

        public HologramLine(String text, HologramRenderer renderer) {
            this(text, false, -1, renderer);
        }

        public void removeNPC() {
            this.renderer.destroy();
        }

        public void render(Vector3d vector3d) {
            this.renderer.render(HologramTrait.this.npc, vector3d);
        }

        public void setText(String text) {
            String string = this.text = text == null ? "" : text;
            if (ITEM_MATCHER.matcher(this.text).find() && !(this.renderer instanceof ItemRenderer)) {
                this.renderer.destroy();
                this.mb = 0.21;
                this.mt = 0.07;
                this.renderer = new ItemRenderer();
            }
            this.renderer.updateText(HologramTrait.this.npc, text);
        }
    }

    public static class HologramRendererCreateEvent
    extends NPCEvent {
        private final boolean nameRenderer;
        private HologramRenderer renderer;
        private static final HandlerList handlers = new HandlerList();

        protected HologramRendererCreateEvent(NPC npc, HologramRenderer renderer, boolean nameRenderer) {
            super(npc);
            this.renderer = renderer;
            this.nameRenderer = nameRenderer;
        }

        public HandlerList getHandlers() {
            return handlers;
        }

        public HologramRenderer getRenderer() {
            return this.renderer;
        }

        public boolean isNameRenderer() {
            return this.nameRenderer;
        }

        public void setRenderer(HologramRenderer renderer) {
            Objects.requireNonNull(renderer);
            this.renderer = renderer;
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }
    }

    public static class TextDisplayRenderer
    extends SingleEntityHologramRenderer {
        @Persist(value="", reify=true)
        DisplayTrait dt = new DisplayTrait();
        @Persist(value="", reify=true)
        TextDisplayTrait tdt = new TextDisplayTrait();

        public TextDisplayRenderer() {
            this.dt.setBillboard(Display.Billboard.CENTER);
            this.dt.setInterpolationDelay(0);
            this.tdt.setSeeThrough(true);
        }

        @Override
        public HologramRenderer copy() {
            TextDisplayRenderer r = new TextDisplayRenderer();
            r.dt = this.dt;
            r.tdt = this.tdt;
            return r;
        }

        @Override
        protected NPC createNPC(NPC base, String name, Vector3d offset) {
            NPC hologram = this.registry().createNPC(EntityType.TEXT_DISPLAY, "");
            hologram.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
            hologram.data().set(NPC.Metadata.TEXT_DISPLAY_COMPONENT, Messaging.minecraftComponentFromRawMessage(name));
            hologram.addTrait(this.dt);
            hologram.addTrait(this.tdt);
            return hologram;
        }

        @Override
        public NPC getTemplateNPC() {
            return this.createNPC(null, "", null);
        }

        @Override
        public void render0(NPC base, Vector3d offset) {
            AttributeInstance inst;
            TextDisplay disp = (TextDisplay)this.hologram.getEntity();
            if (SpigotUtil.getVersion()[1] >= 21 && base.getEntity() instanceof LivingEntity && (inst = ((LivingEntity)base.getEntity()).getAttribute((Attribute)Util.getRegistryValue(Registry.ATTRIBUTE, "generic.scale", "scale"))) != null) {
                Transformation tf = disp.getTransformation();
                tf.getScale().set(inst.getValue());
                disp.setTransformation(tf);
            }
            this.hologram.getEntity().teleport(base.getEntity().getLocation().clone().add(offset.x, offset.y + NMS.getBoundingBoxHeight(base.getEntity()) + (double)0.2f, offset.z), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }

        @Override
        public void updateText(NPC npc, String raw) {
            this.text = raw;
            if (this.hologram == null) {
                return;
            }
            this.hologram.data().set(NPC.Metadata.TEXT_DISPLAY_COMPONENT, Messaging.minecraftComponentFromRawMessage(Placeholders.replace(this.text, null, npc)));
        }
    }

    public static class AreaEffectCloudRenderer
    extends SingleEntityHologramRenderer {
        private boolean rendered;
        @Persist(value="", reify=true)
        AreaEffectCloudTrait trait = new AreaEffectCloudTrait();

        @Override
        public HologramRenderer copy() {
            AreaEffectCloudRenderer r = new AreaEffectCloudRenderer();
            r.trait = this.trait;
            return r;
        }

        @Override
        protected NPC createNPC(NPC base, String name, Vector3d offset) {
            NPC npc = this.registry().createNPC(EntityType.AREA_EFFECT_CLOUD, name);
            npc.addTrait(this.trait);
            this.rendered = false;
            return npc;
        }

        @Override
        public NPC getTemplateNPC() {
            return this.createNPC(null, "", new Vector3d(0.0, 0.0, 0.0));
        }

        @Override
        protected void render0(NPC npc, Vector3d offset) {
            AreaEffectCloud cloud = (AreaEffectCloud)this.hologram.getEntity();
            if (!this.rendered) {
                cloud.setRadius(0.0f);
                cloud.setParticle(Particle.BLOCK_MARKER, (Object)Bukkit.createBlockData((Material)Material.AIR));
            }
            this.hologram.getEntity().teleport(npc.getEntity().getLocation().clone().add(offset.x, offset.y + NMS.getBoundingBoxHeight(npc.getEntity()) - 0.5, offset.z), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }

    public static class ArmorstandVehicleRenderer
    extends SingleEntityHologramRenderer {
        @Override
        public HologramRenderer copy() {
            return new ArmorstandVehicleRenderer();
        }

        @Override
        protected NPC createNPC(NPC base, String name, Vector3d offset) {
            NPC npc = this.registry().createNPC(EntityType.ARMOR_STAND, name);
            npc.getOrAddTrait(ArmorStandTrait.class).setAsHelperEntityWithName(base);
            return npc;
        }

        @Override
        protected void render0(NPC npc, Vector3d offset) {
            if (this.hologram.getEntity().getVehicle() == null) {
                NMS.mount(npc.getEntity(), this.hologram.getEntity());
            }
        }
    }

    public static class TextDisplayVehicleRenderer
    extends TextDisplayRenderer {
        @Override
        public HologramRenderer copy() {
            TextDisplayVehicleRenderer r = new TextDisplayVehicleRenderer();
            r.dt = this.dt;
            r.tdt = this.tdt;
            return r;
        }

        @Override
        public void render0(NPC npc, Vector3d offset) {
            super.render0(npc, offset);
            TextDisplay disp = (TextDisplay)this.hologram.getEntity();
            Transformation tf = disp.getTransformation();
            tf.getTranslation().y = (float)offset.y + 0.2f;
            disp.setTransformation(tf);
            if (this.hologram.getEntity().getVehicle() == null) {
                NMS.mount(npc.getEntity(), this.hologram.getEntity());
            }
        }
    }

    public static class InteractionVehicleRenderer
    extends SingleEntityHologramRenderer {
        private Vector3d lastOffset;

        @Override
        public HologramRenderer copy() {
            return new InteractionVehicleRenderer();
        }

        @Override
        protected NPC createNPC(NPC base, String name, Vector3d offset) {
            this.lastOffset = new Vector3d((Vector3dc)offset);
            return this.registry().createNPC(EntityType.INTERACTION, name);
        }

        @Override
        public NPC getTemplateNPC() {
            return this.createNPC(null, "", new Vector3d(0.0, 0.0, 0.0));
        }

        @Override
        public void onSeenByPlayer(NPC npc, Player player) {
            if (this.lastOffset == null || this.hologram == null) {
                return;
            }
            NMS.positionInteractionText(player, this.hologram.getEntity(), npc.getEntity(), this.lastOffset.y);
        }

        @Override
        public void render0(NPC npc, Vector3d offset) {
            this.lastOffset = new Vector3d((Vector3dc)offset);
            if (this.hologram.getEntity().getVehicle() == null) {
                NMS.mount(npc.getEntity(), this.hologram.getEntity());
            }
        }
    }

    public static class ArmorstandRenderer
    extends SingleEntityHologramRenderer {
        @Override
        public HologramRenderer copy() {
            return new ArmorstandRenderer();
        }

        @Override
        protected NPC createNPC(NPC base, String name, Vector3d offset) {
            NPC npc = this.registry().createNPC(EntityType.ARMOR_STAND, name);
            npc.getOrAddTrait(ArmorStandTrait.class).setAsHelperEntityWithName(base);
            return npc;
        }

        @Override
        protected void render0(NPC npc, Vector3d offset) {
            this.hologram.getEntity().teleport(npc.getEntity().getLocation().clone().add(offset.x, offset.y + NMS.getBoundingBoxHeight(npc.getEntity()), offset.z), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }

    public static class TabCompletions
    implements Arg.CompletionsProvider {
        private static final Set<String> LINE_ARGS = ImmutableSet.of((Object)"set", (Object)"remove", (Object)"margintop", (Object)"marginbottom");

        @Override
        public Collection<String> getCompletions(CommandContext args, CommandSender sender, NPC npc) {
            if (args.length() > 1 && npc != null && LINE_ARGS.contains(args.getString(1).toLowerCase(Locale.ROOT))) {
                HologramTrait ht = npc.getOrAddTrait(HologramTrait.class);
                return IntStream.range(0, ht.getLines().size()).mapToObj(Integer::toString).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    public static abstract class SingleEntityHologramRenderer
    implements HologramRenderer {
        protected NPC hologram;
        private NPCRegistry registry;
        private int spawnWaitTicks;
        protected String text;
        private int viewRange = -1;

        protected abstract NPC createNPC(NPC var1, String var2, Vector3d var3);

        @Override
        public void destroy() {
            if (this.hologram != null) {
                this.hologram.destroy();
                this.hologram = null;
            }
        }

        @Override
        public Collection<Entity> getEntities() {
            return this.hologram != null && this.hologram.getEntity() != null ? ImmutableList.of((Object)this.hologram.getEntity()) : Collections.emptyList();
        }

        @Override
        public String getPerPlayerText(NPC npc, Player viewer) {
            return Placeholders.replace(this.text, (CommandSender)viewer, npc);
        }

        protected NPCRegistry registry() {
            return this.registry == null ? (this.registry = CitizensAPI.getTemporaryNPCRegistry()) : this.registry;
        }

        @Override
        public void render(NPC npc, Vector3d offset) {
            if (this.getEntities().isEmpty() && this.spawnWaitTicks-- <= 0) {
                this.destroy();
                this.spawnHologram(npc, offset);
                this.spawnWaitTicks = 5;
            }
            if (this.hologram == null || !this.hologram.isSpawned()) {
                return;
            }
            this.render0(npc, offset);
        }

        protected abstract void render0(NPC var1, Vector3d var2);

        public void setRegistry(NPCRegistry registry) {
            this.registry = registry;
        }

        public void setViewRange(int range) {
            this.viewRange = range;
        }

        protected void spawnHologram(NPC npc, Vector3d offset) {
            this.hologram = this.createNPC(npc, Placeholders.replace(this.text, null, npc), offset);
            if (!this.hologram.hasTrait(ClickRedirectTrait.class)) {
                this.hologram.addTrait(new ClickRedirectTrait(npc));
            }
            this.hologram.data().set(NPC.Metadata.HOLOGRAM_RENDERER, (Object)this);
            if (Settings.Setting.PACKET_HOLOGRAMS.asBoolean()) {
                this.hologram.addTrait(PacketNPC.class);
            }
            if (this.viewRange != -1) {
                this.hologram.data().set(NPC.Metadata.TRACKING_RANGE, (Object)this.viewRange);
            } else if (npc.data().has(NPC.Metadata.TRACKING_RANGE)) {
                this.hologram.data().set(NPC.Metadata.TRACKING_RANGE, npc.data().get(NPC.Metadata.TRACKING_RANGE));
            }
            this.hologram.spawn(npc.getEntity().getLocation().add(offset.x, offset.y + NMS.getBoundingBoxHeight(npc.getEntity()), offset.z));
        }

        @Override
        public void updateText(NPC npc, String raw) {
            this.text = raw;
            if (this.hologram == null) {
                return;
            }
            String updatedName = Placeholders.replace(this.text, null, npc);
            if (this.hologram.isSpawned()) {
                this.hologram.getEntity().setCustomName(null);
            }
            this.hologram.setName(updatedName);
            if (!Placeholders.containsPlaceholders(this.text)) {
                this.hologram.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)(Messaging.stripColor(this.text).length() > 0 ? 1 : 0));
            }
        }
    }

    public static class ItemRenderer
    extends SingleEntityHologramRenderer {
        private NPC itemNPC;

        @Override
        public HologramRenderer copy() {
            return new ItemRenderer();
        }

        @Override
        protected NPC createNPC(NPC base, String name, Vector3d offset) {
            NPC mount = this.registry().createNPC(EntityType.ARMOR_STAND, "");
            mount.getOrAddTrait(ArmorStandTrait.class).setAsPointEntity();
            Matcher itemMatcher = ITEM_MATCHER.matcher(name);
            itemMatcher.find();
            Material material = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)itemMatcher.group(1), (boolean)false) : Material.matchMaterial((String)itemMatcher.group(1));
            ItemStack itemStack = new ItemStack(material, 1);
            this.itemNPC = this.registry().createNPCUsingItem(Util.getFallbackEntityType("ITEM", "DROPPED_ITEM"), "", itemStack);
            this.itemNPC.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
            if (itemMatcher.group(2) != null) {
                String modify = itemMatcher.group(2).substring(1);
                ChatColor matched = null;
                for (ChatColor color : ChatColor.values()) {
                    if (!modify.equalsIgnoreCase(color.name())) continue;
                    this.itemNPC.getOrAddTrait(ScoreboardTrait.class).setColor(color);
                    matched = color;
                    break;
                }
                if (matched == null) {
                    ItemStack stack = Bukkit.getItemFactory().createItemStack(material + "[" + modify + "]");
                    this.itemNPC.setItemProvider(() -> stack.clone());
                }
            }
            this.itemNPC.spawn(base.getStoredLocation());
            this.itemNPC.getOrAddTrait(MountTrait.class).setMountedOn(mount.getUniqueId());
            return mount;
        }

        @Override
        public void destroy() {
            super.destroy();
            if (this.itemNPC == null) {
                return;
            }
            this.itemNPC.destroy();
            this.itemNPC = null;
        }

        @Override
        public Collection<Entity> getEntities() {
            return this.itemNPC != null && this.itemNPC.getEntity() != null ? ImmutableList.of((Object)this.hologram.getEntity(), (Object)this.itemNPC.getEntity()) : Collections.emptyList();
        }

        @Override
        protected void render0(NPC npc, Vector3d offset) {
            this.hologram.getEntity().teleport(npc.getEntity().getLocation().clone().add(offset.x, offset.y + NMS.getBoundingBoxHeight(npc.getEntity()), offset.z), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }

        @Override
        public void updateText(NPC npc, String text) {
            this.text = text;
        }
    }

    public static class ItemDisplayRenderer
    extends SingleEntityHologramRenderer {
        @Override
        public HologramRenderer copy() {
            return new ItemDisplayRenderer();
        }

        @Override
        protected NPC createNPC(NPC base, String name, Vector3d offset) {
            Matcher itemMatcher = ITEM_MATCHER.matcher(name);
            itemMatcher.find();
            Material material = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)itemMatcher.group(1), (boolean)false) : Material.matchMaterial((String)itemMatcher.group(1));
            ItemStack itemStack = new ItemStack(material, 1);
            NPC npc = this.registry().createNPCUsingItem(EntityType.ITEM_DISPLAY, "", itemStack);
            npc.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
            if (itemMatcher.group(2) != null) {
                String modify = itemMatcher.group(2).substring(1);
                for (ChatColor color : ChatColor.values()) {
                    if (!modify.equalsIgnoreCase(color.name())) continue;
                    npc.getOrAddTrait(ScoreboardTrait.class).setColor(color);
                    return npc;
                }
                ItemStack stack = Bukkit.getItemFactory().createItemStack(material + "[" + modify + "]");
                npc.setItemProvider(() -> stack.clone());
            }
            return npc;
        }

        @Override
        public void render0(NPC base, Vector3d offset) {
            ItemDisplay disp = (ItemDisplay)this.hologram.getEntity();
            Transformation tf = disp.getTransformation();
            tf.getTranslation().y = (float)offset.y + 0.1f;
            disp.setTransformation(tf);
            if (this.hologram.getEntity().getVehicle() == null) {
                NMS.mount(base.getEntity(), this.hologram.getEntity());
            }
        }

        @Override
        public void updateText(NPC npc, String text) {
            this.text = text;
        }
    }
}

