/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Storage;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements Storage {
    private final FileConfiguration config = new YamlConfiguration();
    private final File file;
    private final boolean transformLists;
    private static Field LOADER_OPTIONS;
    private static Method SET_CODEPOINT_LIMIT;

    public YamlStorage(File file) {
        this(file, null);
    }

    public YamlStorage(File file, String header) {
        this(file, header, true);
    }

    public YamlStorage(File file, String header, boolean transformLists) {
        this.tryIncreaseMaxCodepoints(this.config);
        this.transformLists = transformLists;
        this.file = file;
        if (!file.exists()) {
            this.create();
            if (header != null) {
                this.config.options().header(header);
            }
            this.save();
        }
    }

    private void create() {
        try {
            Messaging.debug("Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Messaging.severe("Could not create file: " + this.file.getName());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlStorage other = (YamlStorage)obj;
        return Objects.equals(this.file, other.file);
    }

    @Override
    public DataKey getKey(String root) {
        return new MemoryDataKey((ConfigurationSection)this.config, root);
    }

    public int hashCode() {
        return 31 + (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean load() {
        try {
            this.config.load(this.file);
            if (this.transformLists) {
                this.transformListsToMapsInConfig((ConfigurationSection)this.config);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void save() {
        YamlConfiguration copy = new YamlConfiguration();
        for (String key : this.config.getKeys(false)) {
            copy.set(key, this.config.get(key));
        }
        this.save(copy);
    }

    private void save(YamlConfiguration from) {
        try {
            Files.createParentDirs((File)this.file);
            File temporaryFile = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            temporaryFile.deleteOnExit();
            if (this.transformLists) {
                this.transformMapsToListsInConfig((ConfigurationSection)from);
            }
            from.save(temporaryFile);
            this.file.delete();
            temporaryFile.renameTo(this.file);
            temporaryFile.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void saveAsync() {
        YamlConfiguration copy = new YamlConfiguration();
        for (String key : this.config.getKeys(false)) {
            copy.set(key, this.config.get(key));
        }
        ForkJoinPool.commonPool().submit(() -> this.save(copy));
    }

    public String toString() {
        return "YamlStorage {file=" + this.file + "}";
    }

    private void transformListsToMapsInConfig(ConfigurationSection root) {
        ArrayList queue = Lists.newArrayList((Object[])new ConfigurationSection[]{root});
        while (queue.size() > 0) {
            ConfigurationSection section = (ConfigurationSection)queue.remove(queue.size() - 1);
            for (String key : section.getKeys(false)) {
                Object value = section.get(key);
                if (value instanceof Collection) {
                    ConfigurationSection synthetic = section.createSection(key);
                    int i = 0;
                    for (Object next : (Collection)value) {
                        if (next instanceof Map) {
                            queue.add(synthetic.createSection(Integer.toString(i++), (Map)next));
                            continue;
                        }
                        synthetic.set(Integer.toString(i++), next);
                    }
                    continue;
                }
                if (!(value instanceof ConfigurationSection)) continue;
                queue.add((ConfigurationSection)value);
            }
        }
    }

    private void transformMapsToListsInConfig(ConfigurationSection root) {
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(root);
        ArrayList convert = Lists.newArrayList();
        while (queue.size() > 0) {
            ConfigurationSection parent = (ConfigurationSection)queue.poll();
            for (String key : parent.getKeys(false)) {
                Object value = parent.get(key);
                if (!(value instanceof ConfigurationSection)) continue;
                queue.add((ConfigurationSection)value);
                convert.add(new Tuple(parent, key));
            }
        }
        block2: for (Tuple t : convert) {
            List ints = t.parent.getConfigurationSection(t.key).getKeys(false).stream().map(i -> Ints.tryParse((String)i)).collect(Collectors.toList());
            if (ints.size() == 0) continue;
            for (int i2 = 0; i2 < ints.size(); ++i2) {
                if (ints.get(i2) == null || (Integer)ints.get(i2) != i2) continue block2;
            }
            t.parent.set(t.key, ints.stream().map(i -> t.parent.getConfigurationSection(t.key).get(Integer.toString(i))).collect(Collectors.toList()));
        }
    }

    private void tryIncreaseMaxCodepoints(FileConfiguration config) {
        if (SET_CODEPOINT_LIMIT == null || LOADER_OPTIONS == null) {
            return;
        }
        try {
            SET_CODEPOINT_LIMIT.invoke(LOADER_OPTIONS.get(config), 0x4000000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            LOADER_OPTIONS = YamlConfiguration.class.getDeclaredField("yamlLoaderOptions");
            LOADER_OPTIONS.setAccessible(true);
            SET_CODEPOINT_LIMIT = Class.forName("org.yaml.snakeyaml.LoaderOptions").getMethod("setCodepointLimit", Integer.TYPE);
            SET_CODEPOINT_LIMIT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Tuple {
        String key;
        ConfigurationSection parent;

        public Tuple(ConfigurationSection parent2, String key2) {
            this.parent = parent2;
            this.key = key2;
        }
    }
}

