/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree.expr;

import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.citizensnpcs.api.ai.tree.expr.CompiledExpression;
import net.citizensnpcs.api.ai.tree.expr.ExpressionEngine;
import net.citizensnpcs.api.ai.tree.expr.ExpressionScope;

public class JSR223Engine
implements ExpressionEngine {
    private final boolean compilable;
    private final ScriptEngine engine;
    private final String name;

    public JSR223Engine(String language) {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName(language);
        if (this.engine == null) {
            throw new IllegalArgumentException("Script engine not found: " + language);
        }
        this.name = language.toLowerCase();
        this.compilable = this.engine instanceof Compilable;
    }

    @Override
    public CompiledExpression compile(String expression) throws ExpressionEngine.ExpressionCompileException {
        if (this.compilable) {
            try {
                CompiledScript compiled = ((Compilable)((Object)this.engine)).compile(expression);
                return new JSR223CompiledExpression(compiled);
            }
            catch (ScriptException e) {
                throw new ExpressionEngine.ExpressionCompileException("Failed to compile script: " + expression, e);
            }
        }
        return new JSR223InterpretedExpression(this.engine, expression);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static Bindings createBindings(ExpressionScope scope) {
        SimpleBindings bindings = new SimpleBindings();
        for (String name : scope.getVariableNames()) {
            Object value = scope.get(name);
            if (value == null) continue;
            if (name.contains(".")) {
                String[] parts = name.split("\\.");
                Map<String, Object> current = bindings;
                for (int i = 0; i < parts.length - 1; ++i) {
                    HashMap next = (HashMap)current.get(parts[i]);
                    if (next == null) {
                        next = new HashMap();
                        current.put(parts[i], next);
                    }
                    current = next;
                }
                current.put(parts[parts.length - 1], value);
                continue;
            }
            bindings.put(name, value);
        }
        return bindings;
    }

    public static JSR223Engine javascript() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        if (engine == null) {
            engine = manager.getEngineByName("graal.js");
        }
        if (engine == null) {
            engine = manager.getEngineByName("js");
        }
        if (engine == null) {
            throw new IllegalStateException("No JavaScript engine available");
        }
        return new JSR223Engine("js");
    }

    private static class JSR223CompiledExpression
    implements CompiledExpression {
        private final CompiledScript compiled;

        JSR223CompiledExpression(CompiledScript compiled) {
            this.compiled = compiled;
        }

        @Override
        public Object evaluate(ExpressionScope scope) {
            try {
                Bindings bindings = JSR223Engine.createBindings(scope);
                return this.compiled.eval(bindings);
            }
            catch (ScriptException e) {
                return null;
            }
        }
    }

    private static class JSR223InterpretedExpression
    implements CompiledExpression {
        private final ScriptEngine engine;
        private final String expression;

        JSR223InterpretedExpression(ScriptEngine engine, String expression) {
            this.engine = engine;
            this.expression = expression;
        }

        @Override
        public Object evaluate(ExpressionScope scope) {
            try {
                Bindings bindings = JSR223Engine.createBindings(scope);
                return this.engine.eval(this.expression, bindings);
            }
            catch (ScriptException e) {
                return null;
            }
        }
    }
}

