/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class CoalescedBehavior
implements Behavior {
    private final List<Behavior> behaviors;

    public CoalescedBehavior(List<Behavior> behaviors) {
        this.behaviors = behaviors;
    }

    @Override
    public void reset() {
        for (Behavior behavior : this.behaviors) {
            behavior.reset();
        }
    }

    @Override
    public BehaviorStatus run() {
        for (Behavior behavior : this.behaviors) {
            BehaviorStatus status;
            if (!behavior.shouldExecute() || (status = behavior.run()) != BehaviorStatus.FAILURE && status != BehaviorStatus.RESET_AND_REMOVE) continue;
            return status;
        }
        return BehaviorStatus.SUCCESS;
    }

    @Override
    public boolean shouldExecute() {
        for (Behavior behavior : this.behaviors) {
            if (!behavior.shouldExecute()) continue;
            return true;
        }
        return false;
    }
}

