/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractBlockBreaker
extends BlockBreaker {
    protected final BlockBreaker.BlockBreakerConfiguration configuration;
    private int currentDamage;
    private int currentTick;
    protected final Entity entity;
    private boolean isDigging = true;
    private final Location location;
    private boolean setTarget;
    private int startDigTick;
    protected final int x;
    protected final int y;
    protected final int z;

    public AbstractBlockBreaker(Entity entity, Block target, BlockBreaker.BlockBreakerConfiguration config) {
        this.entity = entity;
        this.x = target.getX();
        this.y = target.getY();
        this.z = target.getZ();
        this.location = target.getLocation();
        this.startDigTick = (int)(System.currentTimeMillis() / 50L);
        this.configuration = config;
    }

    private void cancelNavigation() {
        if (this.setTarget) {
            if (this.entity instanceof NPCHolder) {
                NPC npc = ((NPCHolder)this.entity).getNPC();
                if (npc != null && npc.getNavigator().isNavigating()) {
                    npc.getNavigator().cancelNavigation();
                }
            } else {
                NMS.cancelMoveDestination(this.entity);
            }
        }
        this.setTarget = false;
    }

    protected abstract float getDamage(int var1);

    protected ItemStack getItemStack() {
        return this.configuration.item() != null ? this.configuration.item() : (this.entity instanceof LivingEntity ? ((LivingEntity)this.entity).getEquipment().getItemInHand() : null);
    }

    private boolean inRange() {
        Location center = Util.getCenterLocation(this.location.getBlock());
        Location loc = this.entity.getLocation();
        double xz = Math.sqrt(Math.pow(center.getX() - loc.getX(), 2.0) + Math.pow(center.getZ() - loc.getZ(), 2.0));
        return xz <= this.configuration.radius() && Math.abs(center.getY() - loc.getY()) <= 3.0;
    }

    @Override
    public void reset() {
        this.cancelNavigation();
        if (this.configuration.callback() != null) {
            this.configuration.callback().run();
        }
        this.isDigging = false;
        this.currentDamage = -1;
        this.setBlockDamage(-1);
    }

    @Override
    public BehaviorStatus run() {
        if (!this.entity.isValid()) {
            return BehaviorStatus.FAILURE;
        }
        if (!this.isDigging) {
            return BehaviorStatus.SUCCESS;
        }
        this.currentTick = (int)(System.currentTimeMillis() / 50L);
        if (this.configuration.radius() > 0.0) {
            if (!this.inRange()) {
                this.startDigTick = this.currentTick;
                if (this.entity instanceof NPCHolder) {
                    NPC npc = ((NPCHolder)this.entity).getNPC();
                    if (npc != null && !npc.getNavigator().isNavigating()) {
                        npc.getNavigator().setTarget(this.location);
                        npc.getNavigator().getLocalParameters().pathDistanceMargin(Math.max(1.0, npc.getNavigator().getLocalParameters().pathDistanceMargin()));
                        npc.getNavigator().getLocalParameters().distanceMargin(Math.max(this.configuration.radius() - 1.0, 0.75));
                        this.setTarget = true;
                    }
                } else {
                    NMS.setDestination(this.entity, this.x, this.y, this.z, 1.0f);
                    this.setTarget = true;
                }
                return BehaviorStatus.RUNNING;
            }
            if (this.setTarget) {
                this.cancelNavigation();
            }
        }
        Util.faceLocation(this.entity, this.location);
        if (this.entity instanceof Player && this.currentTick % 5 == 0) {
            PlayerAnimation.ARM_SWING.play((Player)this.entity);
        }
        if (this.entity.getWorld().getBlockAt(this.x, this.y, this.z).isEmpty()) {
            return BehaviorStatus.SUCCESS;
        }
        int tickDifference = this.currentTick - this.startDigTick;
        float damage = this.getDamage(tickDifference);
        if (damage >= 1.0f) {
            this.configuration.blockBreaker().accept(this.entity.getWorld().getBlockAt(this.x, this.y, this.z), this.getItemStack());
            return BehaviorStatus.SUCCESS;
        }
        int modifiedDamage = (int)(damage * 10.0f);
        if (modifiedDamage != this.currentDamage) {
            this.setBlockDamage(modifiedDamage);
            this.currentDamage = modifiedDamage;
        }
        return BehaviorStatus.RUNNING;
    }

    protected abstract void setBlockDamage(int var1);

    @Override
    public boolean shouldExecute() {
        return !this.entity.getWorld().getBlockAt(this.x, this.y, this.z).isEmpty();
    }
}

