/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.PathfinderType;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.AsyncChunkCache;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NMSChunkBlockSource;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class AStarNavigationStrategy
extends AbstractPathStrategy {
    private Location current;
    private final Location destination;
    private final NPC npc;
    private final NavigatorParameters params;
    private Path plan;
    private PathPlanner planner;
    private static final AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();

    public AStarNavigationStrategy(NPC npc, Iterable<Vector> path, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.npc = npc;
        ArrayList list = Lists.newArrayList(path);
        this.destination = ((Vector)list.get(list.size() - 1)).toLocation(npc.getStoredLocation().getWorld());
        this.plan = new Path(list);
    }

    public AStarNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.npc = npc;
        if (!MinecraftBlockExaminer.canStandIn(dest.getBlock())) {
            dest = MinecraftBlockExaminer.findValidLocationAbove(dest, 2);
        }
        this.destination = dest;
        if (params.pathfinderType() == PathfinderType.CITIZENS_ASYNC) {
            CompletableFuture<Path> future = CitizensAPI.getAsyncChunkCache().findPathAsync(new AsyncChunkCache.PathRequest(npc.getEntity().getLocation(), dest, 1, params));
            this.planner = new AsyncAStarPlanner(future);
        } else {
            this.planner = new AStarPlanner(params, npc.getEntity().getLocation(), this.destination);
        }
    }

    @Override
    public Location getCurrentDestination() {
        return this.current != null ? this.current : this.destination.clone();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.plan == null ? null : this.plan.getPath();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.destination;
    }

    @Override
    public void stop() {
        if (this.plan != null && this.params.debug()) {
            Util.sendBlockChanges(this.plan.getBlocks(this.npc.getEntity().getWorld()), null);
        }
        this.plan = null;
    }

    @Override
    public boolean update() {
        if (this.planner != null) {
            CancelReason reason = this.planner.tick();
            if (reason != null) {
                this.setCancelReason(reason);
                return true;
            }
            if (this.planner.getPath() == null) {
                return false;
            }
            this.plan = this.planner.getPath();
            if (this.plan != null && this.params.debug()) {
                Util.sendBlockChanges(this.plan.getBlocks(this.destination.getWorld()), Util.getFallbackMaterial("DANDELION", "YELLOW_FLOWER"));
            }
            this.planner = null;
        }
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        Location loc = this.npc.getEntity().getLocation();
        if (this.current == null) {
            this.current = this.plan.getCurrentVector().toLocation(loc.getWorld());
        }
        Location dest = this.plan.isFinalEntry() ? this.current : Util.getCenterLocation(this.current.getBlock());
        double dX = dest.getX() - loc.getX();
        double dZ = dest.getZ() - loc.getZ();
        double dY = dest.getY() - loc.getY();
        double xzDistance = Math.sqrt(dX * dX + dZ * dZ);
        if (Math.abs(dY) < 1.0 && xzDistance <= this.params.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.current = null;
            return false;
        }
        if (this.params.debug()) {
            this.npc.getEntity().getWorld().playEffect(dest, Effect.ENDER_SIGNAL, 0);
        }
        if (this.npc.getEntity() instanceof LivingEntity && this.npc.getEntity().getType() != EntityType.ARMOR_STAND) {
            NMS.setDestination(this.npc.getEntity(), dest.getX(), dest.getY(), dest.getZ(), this.params.speedModifier());
        } else {
            Vector dir = dest.toVector().subtract(this.npc.getEntity().getLocation().toVector()).normalize().multiply(0.2 * (double)this.params.speedModifier());
            boolean liquidOrInLiquid = MinecraftBlockExaminer.isLiquidOrWaterlogged(loc.getBlock());
            if (dY >= 1.0 && xzDistance <= 0.4 || dY >= 0.2 && liquidOrInLiquid) {
                dir.add(new Vector(0.0, 0.75, 0.0));
            }
            this.npc.getEntity().setVelocity(dir);
            Util.faceLocation(this.npc.getEntity(), dest);
        }
        this.plan.run(this.npc);
        return false;
    }

    private static class AsyncAStarPlanner
    implements PathPlanner {
        private final CompletableFuture<Path> future;
        private Path path;

        public AsyncAStarPlanner(CompletableFuture<Path> future) {
            this.future = future;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public CancelReason tick() {
            if (this.future.isDone()) {
                try {
                    this.path = this.future.join();
                }
                catch (CancellationException cancel) {
                    Messaging.debug("Async navigation cancelled");
                    return null;
                }
                catch (Exception exception) {
                    if (Messaging.isDebugging()) {
                        exception.printStackTrace();
                    }
                    return CancelReason.STUCK;
                }
            }
            return null;
        }
    }

    public static interface PathPlanner {
        public Path getPath();

        public CancelReason tick();
    }

    public static class AStarPlanner
    implements PathPlanner {
        int iterations;
        int iterationsPerTick = Settings.Setting.CITIZENS_PATHFINDER_ASTAR_ITERATIONS_PER_TICK.asInt();
        int maxIterations = Settings.Setting.CITIZENS_PATHFINDER_MAXIMUM_ASTAR_ITERATIONS.asInt();
        NavigatorParameters params;
        Path plan;
        AStarMachine.AStarState<VectorNode> state;

        public AStarPlanner(final NavigatorParameters params, Location from, Location to) {
            this.params = params;
            params.examiner(new BlockExaminer(){

                @Override
                public float getCost(BlockSource source, PathPoint point) {
                    Vector pos = point.getVector();
                    Material above = source.getMaterialAt(pos.getBlockX(), pos.getBlockY() + 1, pos.getBlockZ());
                    return params.avoidWater() && (MinecraftBlockExaminer.isLiquid(above) || MinecraftBlockExaminer.isLiquidOrWaterlogged(source.getMaterialAt(pos), source.getBlockDataAt(pos))) ? 2.0f : 0.0f;
                }

                @Override
                public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
                    return BlockExaminer.PassableState.IGNORE;
                }
            });
            VectorGoal goal = new VectorGoal(to, (float)params.pathDistanceMargin());
            this.state = ASTAR.getStateFor(goal, new VectorNode(goal, from, new NMSChunkBlockSource(from, params.range()), params));
        }

        @Override
        public Path getPath() {
            return this.plan;
        }

        @Override
        public CancelReason tick() {
            this.plan = (Path)ASTAR.run(this.state, this.iterationsPerTick);
            if (this.plan != null) {
                return null;
            }
            if (this.state.isEmpty()) {
                return CancelReason.STUCK;
            }
            if (this.iterationsPerTick > 0 && this.maxIterations > 0) {
                this.iterations += this.iterationsPerTick;
                if (this.iterations > this.maxIterations) {
                    return CancelReason.STUCK;
                }
            }
            return null;
        }
    }
}

