/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.base.Preconditions;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PaymentListener
implements Listener {
    private final Economy provider;

    public PaymentListener(Economy provider) {
        Preconditions.checkNotNull((Object)provider, (Object)"provider cannot be null");
        this.provider = provider;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        String name = event.getCreator().getName();
        boolean hasAccount = this.provider.hasAccount(name);
        if (!hasAccount || event.getCreator().hasPermission("citizens.npc.ignore-cost")) {
            return;
        }
        double cost = Settings.Setting.NPC_COST.asDouble();
        boolean hasEnough = this.provider.has(name, cost);
        String formattedCost = this.provider.format(cost);
        if (!hasEnough) {
            event.setCancelled(true);
            event.setCancelReason(Messaging.tr("citizens.economy.minimum-cost-required-message", formattedCost));
            return;
        }
        this.provider.withdrawPlayer(name, cost);
        String message = Messaging.tr("citizens.economy.money-withdrawn", StringHelper.wrap(formattedCost));
        Messaging.send((CommandSender)event.getCreator(), ChatColor.GREEN + message);
    }
}

