/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.AnimationTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class AnimationTriggerPrompt
extends StringPrompt
implements WaypointTriggerPrompt {
    private final List<PlayerAnimation> animations = Lists.newArrayList();
    private Location at;

    public Prompt acceptInput(ConversationContext context, String input) {
        if (input.equalsIgnoreCase("back")) {
            return (Prompt)context.getSessionData((Object)"previous");
        }
        if (input.startsWith("at ")) {
            try {
                this.at = CommandContext.parseLocation(context.getForWhom() instanceof Player ? ((Player)context.getForWhom()).getLocation() : null, input.replaceFirst("at ", ""));
                Messaging.send((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.animation.at-set", Util.prettyPrintLocation(this.at));
            }
            catch (CommandException e) {
                Messaging.send((CommandSender)context.getForWhom(), e.getMessage());
            }
            return this;
        }
        if (input.equalsIgnoreCase("finish")) {
            context.setSessionData((Object)"created-trigger", (Object)new AnimationTrigger(this.animations, this.at));
            return (Prompt)context.getSessionData((Object)"return-to");
        }
        PlayerAnimation animation = (PlayerAnimation)Util.matchEnum((Enum[])PlayerAnimation.values(), (String)input);
        if (animation == null) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.animation.invalid-animation", input, this.getValidAnimations());
            return this;
        }
        this.animations.add(animation);
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.animation.added", input);
        return this;
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext context, String input) {
        PlayerAnimation anim = (PlayerAnimation)Util.matchEnum((Enum[])PlayerAnimation.values(), (String)input);
        if (anim == null) {
            return null;
        }
        return new AnimationTrigger(Lists.newArrayList((Object[])new PlayerAnimation[]{anim}), this.at);
    }

    public String getPromptText(ConversationContext context) {
        if (context.getSessionData((Object)"said") == Boolean.TRUE) {
            Messaging.send((CommandSender)context.getForWhom(), "Current animations:<br>-   " + Joiner.on((String)"<br>-   ").join(this.animations));
        } else {
            Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.animation.prompt", this.getValidAnimations());
            context.setSessionData((Object)"said", (Object)true);
        }
        return "";
    }

    private String getValidAnimations() {
        return Joiner.on((String)", ").join((Object[])PlayerAnimation.values());
    }
}

