/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R7.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R7.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R7.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilus;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombieNautilus;
import org.bukkit.entity.Entity;

public class ZombieNautilusController
extends MobEntityController {
    public ZombieNautilusController() {
        super(EntityZombieNautilusNPC.class, EntityTypes.bY);
    }

    public org.bukkit.entity.ZombieNautilus getBukkitEntity() {
        return (org.bukkit.entity.ZombieNautilus)super.getBukkitEntity();
    }

    public static class EntityZombieNautilusNPC
    extends ZombieNautilus
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerMove oldMoveController;

        public EntityZombieNautilusNPC(EntityTypes<? extends ZombieNautilus> types, World level) {
            this(types, level, null);
        }

        public EntityZombieNautilusNPC(EntityTypes<? extends ZombieNautilus> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.cp;
                this.cp = new ControllerMove((EntityInsentient)this);
            }
        }

        public void d_() {
            boolean lastInWater = this.ae;
            if (this.npc != null) {
                this.ae = false;
            }
            super.d_();
            if (this.npc != null) {
                this.ae = lastInWater;
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof AbstractBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dW() {
            if (this.npc == null) {
                super.dW();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.cp != this.oldMoveController) {
                    this.cp = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.cp == this.oldMoveController) {
                    this.cp = new ControllerMove((EntityInsentient)this);
                }
            }
            super.a(level);
            if (this.npc != null) {
                this.npc.update();
            }
        }

        protected SoundEffect W() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.W(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ZombieNautilusNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect fd() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.fd(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect h(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.h(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fF() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fF());
        }

        public int cW() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cW());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean S_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.S_(), (EntityInsentient)this);
        }

        public boolean bY() {
            return this.npc == null ? super.bY() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean fl() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.fl();
            }
            return false;
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().aq().equals(this.ao().aq())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void m(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish((NPC)this.npc, (EntityInsentient)this, vec3d)) {
                    super.m(vec3d);
                }
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dN().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class ZombieNautilusNPC
    extends CraftZombieNautilus
    implements ForwardingNPCHolder {
        public ZombieNautilusNPC(EntityZombieNautilusNPC entity) {
            super((CraftServer)Bukkit.getServer(), (ZombieNautilus)entity);
        }
    }
}

