/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.PrioritisableGoal;
import net.citizensnpcs.api.ai.SimpleGoalEntry;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;

public class SimpleGoalController
implements GoalController {
    private final List<Goal> executingGoals = new ArrayList<Goal>();
    private int executingPriority = -1;
    private Goal executingRootGoal;
    private boolean hasPrioritisableGoal;
    private boolean paused;
    private final List<GoalController.GoalEntry> possibleGoals = new ArrayList<GoalController.GoalEntry>();
    private final GoalSelector selector = new SimpleGoalSelector();

    @Override
    public void addBehavior(Behavior behavior, int priority) {
        if (behavior instanceof Goal) {
            this.addGoal((Goal)((Object)behavior), priority);
            return;
        }
        this.addGoal(BehaviorGoalAdapter.create(behavior), priority);
    }

    @Override
    public void addGoal(Goal goal, int priority) {
        Objects.requireNonNull(goal, "goal cannot be null");
        if (priority < 0) {
            throw new IllegalArgumentException("priority must be greater than 0");
        }
        SimpleGoalEntry entry = new SimpleGoalEntry(goal, priority);
        if (this.possibleGoals.contains(entry)) {
            return;
        }
        this.possibleGoals.add(entry);
        Collections.sort(this.possibleGoals);
    }

    private void addGoalToExecution(Goal goal) {
        this.executingGoals.add(goal);
        goal.run(this.selector);
    }

    @Override
    public void addPrioritisableGoal(PrioritisableGoal goal) {
        Objects.requireNonNull(goal, "goal cannot be null");
        this.possibleGoals.add(new SimpleGoalEntry((Goal)goal, () -> goal.getPriority()));
        this.hasPrioritisableGoal = true;
    }

    @Override
    public void cancelCurrentExecution() {
        this.finishCurrentGoalExecution();
    }

    @Override
    public void clear() {
        this.finishCurrentGoalExecution();
        this.possibleGoals.clear();
    }

    private void finishCurrentGoalExecution() {
        if (this.executingRootGoal == null) {
            return;
        }
        this.resetGoalList();
        this.executingPriority = -1;
        this.executingRootGoal = null;
    }

    @Override
    public boolean isExecutingGoal() {
        return this.executingRootGoal != null;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public Iterator<GoalController.GoalEntry> iterator() {
        final Iterator<GoalController.GoalEntry> itr = this.possibleGoals.iterator();
        return new Iterator<GoalController.GoalEntry>(){
            GoalController.GoalEntry cur;

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public GoalController.GoalEntry next() {
                this.cur = (GoalController.GoalEntry)itr.next();
                return this.cur;
            }

            @Override
            public void remove() {
                itr.remove();
                if (this.cur.getGoal() == SimpleGoalController.this.executingRootGoal) {
                    SimpleGoalController.this.finishCurrentGoalExecution();
                }
            }
        };
    }

    @Override
    public void removeBehavior(Behavior behavior) {
        for (int i = 0; i < this.possibleGoals.size(); ++i) {
            Goal test = this.possibleGoals.get(i).getGoal();
            if (!test.equals(behavior)) continue;
            this.possibleGoals.remove(i--);
            if (test != this.executingRootGoal) continue;
            this.finishCurrentGoalExecution();
        }
    }

    @Override
    public void removeGoal(Goal goal) {
        Objects.requireNonNull(goal, "goal cannot be null");
        for (int j = 0; j < this.possibleGoals.size(); ++j) {
            Goal goal2 = this.possibleGoals.get(j).getGoal();
            if (!goal2.equals(goal)) continue;
            this.possibleGoals.remove(j--);
            if (goal2 != this.executingRootGoal) continue;
            this.finishCurrentGoalExecution();
        }
        if (goal instanceof PrioritisableGoal) {
            this.hasPrioritisableGoal = false;
            for (GoalController.GoalEntry goalEntry : this.possibleGoals) {
                if (!(goalEntry.getGoal() instanceof PrioritisableGoal)) continue;
                this.hasPrioritisableGoal = true;
                break;
            }
        }
    }

    private void resetGoalList() {
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            this.executingGoals.get(i).reset();
        }
        this.executingGoals.clear();
    }

    @Override
    public void run() {
        if (this.possibleGoals.isEmpty() || this.paused) {
            return;
        }
        this.trySelectGoal();
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            Goal goal = this.executingGoals.get(i);
            goal.run(this.selector);
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private void setupExecution(GoalController.GoalEntry entry) {
        this.finishCurrentGoalExecution();
        this.executingPriority = entry.getPriority();
        this.executingRootGoal = entry.getGoal();
        this.addGoalToExecution(entry.getGoal());
    }

    private void trySelectGoal() {
        int searchPriority = Math.max(this.executingPriority, 1);
        if (this.hasPrioritisableGoal) {
            Collections.sort(this.possibleGoals);
        }
        for (int hi = this.possibleGoals.size() - 1; hi >= 0; --hi) {
            GoalController.GoalEntry entry = this.possibleGoals.get(hi);
            if (searchPriority > entry.getPriority()) {
                return;
            }
            if (entry.getGoal() == this.executingRootGoal || !entry.getGoal().shouldExecute(this.selector)) continue;
            if (hi == 0) {
                this.setupExecution(entry);
                return;
            }
            for (int lo = hi - 1; lo >= 0; --lo) {
                GoalController.GoalEntry next = this.possibleGoals.get(lo);
                if (next.getPriority() == entry.getPriority() && lo != 0) continue;
                if (next.getPriority() != entry.getPriority()) {
                    ++lo;
                }
                int randomSamePriorityIndex = (int)(Math.random() * (double)(hi + 1 - lo) + (double)lo);
                this.setupExecution(this.possibleGoals.get(randomSamePriorityIndex));
                break;
            }
            return;
        }
    }

    public class SimpleGoalSelector
    implements GoalSelector {
        @Override
        public void finish() {
            SimpleGoalController.this.finishCurrentGoalExecution();
        }

        @Override
        public void finishAndRemove() {
            Goal toRemove = SimpleGoalController.this.executingRootGoal;
            this.finish();
            if (toRemove != null) {
                SimpleGoalController.this.removeGoal(toRemove);
            }
        }

        @Override
        public void select(Goal goal) {
            SimpleGoalController.this.resetGoalList();
            SimpleGoalController.this.addGoalToExecution(goal);
        }

        @Override
        public void selectAdditional(Goal ... goals) {
            for (Goal goal : goals) {
                SimpleGoalController.this.addGoalToExecution(goal);
            }
        }
    }
}

