/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class Loop
extends BehaviorGoalAdapter {
    private final Supplier<Boolean> condition;
    private final Behavior wrapping;

    public Loop(Behavior wrapping, Supplier<Boolean> condition) {
        this.wrapping = wrapping;
        this.condition = condition;
    }

    @Override
    public void reset() {
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus status = this.wrapping.run();
        if (status == BehaviorStatus.SUCCESS) {
            this.wrapping.reset();
            if (this.condition.get().booleanValue() && this.wrapping.shouldExecute()) {
                return BehaviorStatus.RUNNING;
            }
        }
        return status;
    }

    @Override
    public boolean shouldExecute() {
        return this.wrapping.shouldExecute();
    }

    public static Loop createWithCondition(Behavior wrapping, Supplier<Boolean> condition) {
        return new Loop(wrapping, condition);
    }
}

