/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import org.bukkit.util.Vector;

public class FallingExaminer
implements BlockExaminer {
    private final Map<PathPoint, Integer> fall = new HashMap<PathPoint, Integer>();
    private final int maxFallDistance;
    private final MinecraftBlockExaminer mc = new MinecraftBlockExaminer();

    public FallingExaminer(int maxFallDistance) {
        this.maxFallDistance = maxFallDistance;
    }

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        if (!source.isYWithinBounds(pos.getBlockY() - 1)) {
            return BlockExaminer.StandableState.IGNORE;
        }
        if (this.fall.containsKey(point)) {
            return BlockExaminer.StandableState.STANDABLE;
        }
        Vector ppos = point.getParentPoint().getVector();
        if (!MinecraftBlockExaminer.canStandOn(source.getMaterialAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ()), source.getBlockDataAt(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()))) {
            Integer dist = this.fall.get(point.getParentPoint());
            if (dist == null && this.mc.isPassable(source, point.getParentPoint()) == BlockExaminer.PassableState.PASSABLE) {
                this.fall.put(point, 0);
                return BlockExaminer.StandableState.STANDABLE;
            }
            if (dist != null && dist < this.maxFallDistance && pos.getBlockY() < ppos.getBlockY() && pos.getBlockX() == ppos.getBlockX() && pos.getBlockZ() == ppos.getBlockZ() && MinecraftBlockExaminer.canStandIn(source.getMaterialAt(pos), source.getBlockDataAt(ppos))) {
                this.fall.put(point, dist + 1);
                return BlockExaminer.StandableState.STANDABLE;
            }
        }
        return BlockExaminer.StandableState.IGNORE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return this.fall.containsKey(point) ? 0.25f : 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        return this.fall.containsKey(point) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.IGNORE;
    }
}

