/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class Path
implements Plan {
    private List<Block> blockList;
    private int index = 0;
    private final PathEntry[] path;

    public Path(Collection<Vector> vector) {
        this.path = (PathEntry[])Iterables.toArray((Iterable)Iterables.transform(vector, input -> new PathEntry((Vector)input, Collections.emptyList())), PathEntry.class);
    }

    Path(Iterable<VectorNode> unfiltered, Vector goal) {
        List<PathEntry> path = new ArrayList<PathEntry>();
        for (VectorNode node : unfiltered) {
            if (node.getPathVectors() != null) {
                for (Vector vector : node.getPathVectors()) {
                    path.add(new PathEntry(vector, node.callbacks));
                }
                continue;
            }
            path.add(new PathEntry(node.getVector().clone().add(new Vector(0.5, 0.0, 0.5)), node.callbacks));
        }
        PathEntry goalEntry = new PathEntry(goal, ((PathEntry)path.get((int)(path.size() - 1))).callbacks);
        Vector last = ((PathEntry)path.get((int)(path.size() - 1))).vector;
        if (last.getBlockX() == goal.getBlockX() && last.getBlockY() == goal.getBlockY() && last.getBlockZ() == goal.getBlockZ()) {
            path.set(path.size() - 1, goalEntry);
        } else {
            path.add(goalEntry);
        }
        path = Path.ramerDouglasPeucker(path, 0.75);
        this.path = path.toArray(new PathEntry[0]);
    }

    public List<Block> getBlocks(World world) {
        return Arrays.stream(this.path).map(p -> world.getBlockAt(p.vector.getBlockX(), p.vector.getBlockY(), p.vector.getBlockZ())).collect(Collectors.toList());
    }

    public Vector getCurrentVector() {
        return this.path[this.index].vector;
    }

    public Iterable<Vector> getPath() {
        return Iterables.transform(Arrays.asList(this.path), input -> input.vector);
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.path.length;
    }

    public boolean isFinalEntry() {
        return this.index == this.path.length - 1;
    }

    public void run(NPC npc) {
        this.path[this.index].run(npc);
    }

    public String toString() {
        return Arrays.toString(this.path);
    }

    @Override
    public void update(Agent agent) {
        if (this.isComplete()) {
            return;
        }
        this.path[this.index++].onComplete((NPC)agent);
    }

    private static List<PathEntry> ramerDouglasPeucker(List<PathEntry> points, double epsilon) {
        if (points.size() < 3) {
            return points;
        }
        ArrayList<Integer> splitIndices = new ArrayList<Integer>();
        splitIndices.add(0);
        for (int i = 1; i < points.size() - 1; ++i) {
            if (points.get((int)i).callbacks == null || points.get((int)i).callbacks.isEmpty()) continue;
            splitIndices.add(i);
        }
        splitIndices.add(points.size() - 1);
        ArrayList<PathEntry> result = new ArrayList<PathEntry>();
        for (int s = 0; s < splitIndices.size() - 1; ++s) {
            int segStart = (Integer)splitIndices.get(s);
            int segEnd = (Integer)splitIndices.get(s + 1);
            List<PathEntry> segment = points.subList(segStart, segEnd + 1);
            List<PathEntry> simplified = Path.ramerDouglasPeuckerSegment(segment, epsilon);
            if (s == splitIndices.size() - 2) {
                result.addAll(simplified);
                continue;
            }
            result.addAll(simplified.subList(0, simplified.size() - 1));
        }
        return result;
    }

    private static List<PathEntry> ramerDouglasPeuckerSegment(List<PathEntry> points, double epsilon) {
        if (points.size() < 3) {
            return new ArrayList<PathEntry>(points);
        }
        int n = points.size();
        boolean[] keep = new boolean[n];
        keep[0] = true;
        keep[n - 1] = true;
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[]{0, n - 1});
        while (!stack.isEmpty()) {
            int[] range = (int[])stack.pop();
            int start = range[0];
            int end = range[1];
            double dmax = 0.0;
            int found = -1;
            Vector a = points.get((int)start).vector;
            Vector b = points.get((int)end).vector;
            double abx = b.getX() - a.getX();
            double aby = b.getY() - a.getY();
            double abz = b.getZ() - a.getZ();
            double length = abx * abx + aby * aby + abz * abz;
            for (int i = start + 1; i < end; ++i) {
                double d;
                Vector p = points.get((int)i).vector;
                if (length < 1.0E-9) {
                    double dx = p.getX() - a.getX();
                    double dy = p.getY() - a.getY();
                    double dz = p.getZ() - a.getZ();
                    d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                } else {
                    double cz;
                    double cy;
                    double apz;
                    double apx = p.getX() - a.getX();
                    double apy = p.getY() - a.getY();
                    double cx = apy * abz - (apz = p.getZ() - a.getZ()) * aby;
                    double crossProductLength = cx * cx + (cy = apz * abx - apx * abz) * cy + (cz = apx * aby - apy * abx) * cz;
                    if (crossProductLength <= epsilon * epsilon * length) continue;
                    d = Math.sqrt(crossProductLength / length);
                }
                if (!(d > dmax)) continue;
                dmax = d;
                found = i;
            }
            if (!(dmax > epsilon) || found == -1) continue;
            keep[found] = true;
            stack.push(new int[]{start, found});
            stack.push(new int[]{found, end});
        }
        ArrayList<PathEntry> result = new ArrayList<PathEntry>();
        for (int i = 0; i < n; ++i) {
            if (!keep[i]) continue;
            result.add(points.get(i));
        }
        return result;
    }

    private class PathEntry {
        Block cache;
        final List<PathPoint.PathCallback> callbacks;
        final Vector vector;

        private PathEntry(Vector vector, List<PathPoint.PathCallback> callbacks) {
            this.vector = vector;
            this.callbacks = callbacks;
        }

        public void onComplete(NPC npc) {
            if (this.callbacks == null) {
                return;
            }
            if (this.cache == null) {
                this.cache = npc.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            }
            for (PathPoint.PathCallback callback : this.callbacks) {
                callback.onReached(npc, this.cache);
            }
        }

        public void run(NPC npc) {
            if (this.callbacks == null) {
                return;
            }
            if (Path.this.blockList == null) {
                Path.this.blockList = Arrays.stream(Path.this.path).map(input -> npc.getEntity().getWorld().getBlockAt(input.vector.getBlockX(), input.vector.getBlockY(), input.vector.getBlockZ())).collect(Collectors.toList());
                this.cache = npc.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            }
            for (PathPoint.PathCallback callback : this.callbacks) {
                callback.run(npc, this.cache, Path.this.blockList, Path.this.index);
            }
        }

        public String toString() {
            return this.vector.toString();
        }
    }
}

