/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface TraitPersistentVariable {
    public String command() default "";

    public String flag() default "";

    public String msg() default "";

    public static class AnnotationInvocationHandler
    implements InvocationHandler {
        private final Map<String, Object> values;

        public AnnotationInvocationHandler(Map<String, Object> values) {
            this.values = values;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.values.containsKey(method.getName())) {
                return this.values.get(method.getName());
            }
            if ("toString".equals(method.getName())) {
                return "Runtime @" + method.getDeclaringClass().getSimpleName() + this.values.toString();
            }
            throw new UnsupportedOperationException("Method " + method.getName() + " not supported");
        }

        public static <T extends Annotation> T createAnnotationInstance(Class<T> annotationType, Map<String, Object> values) {
            return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new AnnotationInvocationHandler(values)));
        }
    }
}

