/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class SwimmingExaminer
implements BlockExaminer {
    private boolean canSwimInLava;
    private static final Vector UP = new Vector(0, 1, 0);

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material in = source.getMaterialAt(pos);
        if (MinecraftBlockExaminer.isLiquidOrWaterlogged(in, source.getBlockDataAt(pos))) {
            return BlockExaminer.StandableState.STANDABLE;
        }
        return BlockExaminer.StandableState.IGNORE;
    }

    public boolean canSwimInLava() {
        return this.canSwimInLava;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector vector = point.getVector();
        if (!MinecraftBlockExaminer.isLiquidOrWaterlogged(source.getMaterialAt(vector), source.getBlockDataAt(vector))) {
            return BlockExaminer.PassableState.IGNORE;
        }
        Vector above = vector.clone().add(UP);
        Material aboveMat = source.getMaterialAt(above);
        return this.isSwimmableLiquid(aboveMat) || MinecraftBlockExaminer.canStandIn(aboveMat, source.getBlockDataAt(above)) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.IMPASSABLE;
    }

    private boolean isSwimmableLiquid(Material material) {
        if (material == Material.LAVA || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_LAVA")) {
            return this.canSwimInLava();
        }
        return material == Material.WATER || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_WATER");
    }

    public void setCanSwimInLava(boolean canSwimInLava) {
        this.canSwimInLava = canSwimInLava;
    }
}

