/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import org.bukkit.util.Vector;

public class FallingExaminer
implements BlockExaminer.AdditionalNeighbourGenerator {
    private final int maxFallDistance;

    public FallingExaminer(int maxFallDistance) {
        this.maxFallDistance = maxFallDistance;
    }

    @Override
    public void addNeighbours(BlockSource source, PathPoint point, List<PathPoint> neighbours) {
        Vector base = point.getVector();
        if (!source.isYWithinBounds(base.getBlockY() - 1)) {
            return;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            block1: for (int dz = -1; dz <= 1; ++dz) {
                int x = base.getBlockX() + dx;
                int z = base.getBlockZ() + dz;
                if (!MinecraftBlockExaminer.canStandIn(source.getMaterialAt(x, base.getBlockY(), z), source.getBlockDataAt(x, base.getBlockY(), z)) || MinecraftBlockExaminer.canStandOn(source.getMaterialAt(x, base.getBlockY() - 1, z), source.getBlockDataAt(x, base.getBlockY() - 1, z))) continue;
                for (int dy = 2; dy <= this.maxFallDistance && source.isYWithinBounds(base.getBlockY() - dy); ++dy) {
                    if (!MinecraftBlockExaminer.canStandIn(source.getMaterialAt(x, base.getBlockY() - dy + 1, z), source.getBlockDataAt(x, base.getBlockY() - dy + 1, z)) || !MinecraftBlockExaminer.canStandOn(source.getMaterialAt(x, base.getBlockY() - dy, z), source.getBlockDataAt(x, base.getBlockY() - dy, z))) continue;
                    Vector vector = new Vector((double)x + 0.5, (double)(base.getBlockY() - dy), (double)z + 0.5);
                    PathPoint next = point.createAtOffset(vector, (float)(dy + 1) * 2.5f);
                    next.setPathVectors((List<Vector>)ImmutableList.of((Object)new Vector((double)x + 0.5, (double)base.getBlockY(), (double)z + 0.5), (Object)vector));
                    neighbours.add(next);
                    continue block1;
                }
            }
        }
    }

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        return BlockExaminer.StandableState.IGNORE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        return BlockExaminer.PassableState.IGNORE;
    }
}

