/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MoneyAction
extends NPCShopAction {
    @Persist
    public double money;

    public MoneyAction() {
    }

    public MoneyAction(double cost) {
        this.money = cost;
    }

    @Override
    public String describe() {
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        return economy.format(this.money);
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventory) {
        if (!(entity instanceof Player) || this.money <= 0.0) {
            return -1;
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        return (int)Math.floor(economy.getBalance((OfflinePlayer)((Player)entity)) / this.money);
    }

    @Override
    public NPCShopAction.Transaction grant(ShopTrait.NPCShopStorage storage, Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (this.money <= 0.0) {
            return NPCShopAction.Transaction.success();
        }
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        Player player = (Player)entity;
        double amount = this.money * (double)repeats;
        return NPCShopAction.Transaction.create(() -> storage.isUnlimited() || storage.getBalance() - amount >= 0.0, () -> {
            EconomyResponse response = economy.depositPlayer((OfflinePlayer)player, amount);
            if (response != null && (response.type == EconomyResponse.ResponseType.FAILURE || response.type == EconomyResponse.ResponseType.NOT_IMPLEMENTED)) {
                Messaging.severe("Failed to deposit", amount, "to", player, "in NPC shop:", response.errorMessage);
            } else {
                storage.setBalance(storage.getBalance() - amount);
            }
        }, () -> {
            EconomyResponse response = economy.withdrawPlayer((OfflinePlayer)player, amount);
            if (response != null && (response.type == EconomyResponse.ResponseType.FAILURE || response.type == EconomyResponse.ResponseType.NOT_IMPLEMENTED)) {
                Messaging.severe("Failed to withdraw", amount, "from", player, "in NPC shop:", response.errorMessage);
            } else {
                storage.setBalance(storage.getBalance() + amount);
            }
        });
    }

    @Override
    public NPCShopAction.Transaction take(ShopTrait.NPCShopStorage storage, Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (this.money <= 0.0) {
            return NPCShopAction.Transaction.success();
        }
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        Player player = (Player)entity;
        double amount = this.money * (double)repeats;
        return NPCShopAction.Transaction.create(() -> economy.has((OfflinePlayer)player, amount), () -> {
            EconomyResponse response = economy.withdrawPlayer((OfflinePlayer)player, amount);
            if (response != null && (response.type == EconomyResponse.ResponseType.FAILURE || response.type == EconomyResponse.ResponseType.NOT_IMPLEMENTED)) {
                Messaging.severe("Failed to withdraw", amount, "from", player, "in NPC shop:", response.errorMessage);
            } else {
                storage.setBalance(storage.getBalance() + amount);
            }
        }, () -> {
            EconomyResponse response = economy.depositPlayer((OfflinePlayer)player, amount);
            if (response != null && (response.type == EconomyResponse.ResponseType.FAILURE || response.type == EconomyResponse.ResponseType.NOT_IMPLEMENTED)) {
                Messaging.severe("Failed to deposit", amount, "to", player, "in NPC shop:", response.errorMessage);
            } else {
                storage.setBalance(storage.getBalance() - amount);
            }
        });
    }

    public static class MoneyActionGUI
    implements NPCShopAction.GUI {
        private Boolean supported;

        public MoneyActionGUI() {
            try {
                Class.forName("net.milkbowl.vault.economy.Economy");
            }
            catch (ClassNotFoundException e) {
                this.supported = false;
            }
        }

        @Override
        public boolean canUse(HumanEntity entity) {
            return entity.hasPermission("citizens.npc.shop.editor.actions.edit-money");
        }

        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            MoneyAction action = previous == null ? new MoneyAction() : (MoneyAction)previous;
            return InputMenus.filteredStringSetter(() -> Double.toString(action.money), s -> {
                if (s == null) {
                    action.money = 0.0;
                    return false;
                }
                try {
                    double result = Double.parseDouble(Messaging.stripColor(s));
                    if (result < 0.0) {
                        return false;
                    }
                    action.money = result;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                callback.accept(action);
                return true;
            });
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            if (this.supported == null) {
                try {
                    this.supported = Bukkit.getServicesManager().getRegistration(Economy.class) != null && Bukkit.getServicesManager().getRegistration(Economy.class).getProvider() != null;
                }
                catch (Throwable t) {
                    this.supported = false;
                    Messaging.severe("Error fetching shop economy provider, shop economy integration will not work:");
                    t.printStackTrace();
                }
            }
            if (!this.supported.booleanValue()) {
                return null;
            }
            String description = null;
            if (previous != null) {
                MoneyAction old = (MoneyAction)previous;
                description = old.describe();
            }
            return Util.createItem(Material.GOLD_INGOT, "Money", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof MoneyAction;
        }
    }
}

