/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.text.TextAddPrompt;
import net.citizensnpcs.trait.text.TextEditStartPrompt;
import net.citizensnpcs.trait.text.TextRemovePrompt;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

public class StartPrompt
extends StringPrompt {
    private final Text text;

    public StartPrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        CommandSender sender = (CommandSender)context.getForWhom();
        if (input.equalsIgnoreCase("add")) {
            return new TextAddPrompt(this.text);
        }
        if (input.equalsIgnoreCase("edit")) {
            return new TextEditStartPrompt(this.text);
        }
        if (input.equalsIgnoreCase("remove")) {
            return new TextRemovePrompt(this.text);
        }
        if (input.equalsIgnoreCase("random")) {
            Messaging.send(sender, "[[Random talker]] set to [[" + this.text.toggleRandomTalker() + "]].");
        } else if (input.equalsIgnoreCase("realistic looking")) {
            Messaging.send(sender, "[[Realistic looking]] set to [[" + this.text.toggleRealisticLooking() + "]].");
        } else if (input.equalsIgnoreCase("close")) {
            Messaging.send(sender, "[[Close talker]] set to [[" + this.text.toggle() + "]].");
        } else if (input.equalsIgnoreCase("help")) {
            context.setSessionData((Object)"said-text", (Object)false);
            Messaging.send(sender, this.getPromptText(context));
        } else {
            Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-edit-type", new Object[0]);
        }
        return new StartPrompt(this.text);
    }

    public String getPromptText(ConversationContext context) {
        if (context.getSessionData((Object)"said-text") == Boolean.TRUE) {
            return "";
        }
        String text = Messaging.tr("citizens.editors.text.start-prompt", new Object[0]);
        context.setSessionData((Object)"said-text", (Object)Boolean.TRUE);
        return text;
    }
}

