/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.DisguiseTrait;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.EntityMetadataValue;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PacketEventsHook
implements Listener {
    private MethodHandle DESERIALIZE_METHOD;
    private final Map<Integer, DisguiseTrait> disguiseTraits = Maps.newConcurrentMap();
    private final Map<UUID, DisguiseTrait> disguiseTraitsUUID = Maps.newConcurrentMap();
    private Object MINIMESSAGE;
    private final Map<UUID, MirrorTrait> mirrorTraits = Maps.newConcurrentMap();
    private Constructor<WrapperPlayServerPlayerInfo.PlayerData> PLAYERDATA_CONSTRUCTOR;
    private final Map<Integer, RotationTrait> rotationTraits = Maps.newConcurrentMap();

    public PacketEventsHook(final Citizens plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        PacketEvents.getAPI().init();
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListener(){

            private Equipment.EquipmentSlot convert(EquipmentSlot slot) {
                if (slot.name().equals("BODY")) {
                    return Equipment.EquipmentSlot.BODY;
                }
                if (slot.name().equals("SADDLE")) {
                    return Equipment.EquipmentSlot.SADDLE;
                }
                switch (slot) {
                    case CHEST_PLATE: {
                        return Equipment.EquipmentSlot.CHESTPLATE;
                    }
                    case BOOTS: {
                        return Equipment.EquipmentSlot.BOOTS;
                    }
                    case HELMET: {
                        return Equipment.EquipmentSlot.HELMET;
                    }
                    case LEGGINGS: {
                        return Equipment.EquipmentSlot.LEGGINGS;
                    }
                    case MAIN_HAND: {
                        return Equipment.EquipmentSlot.HAND;
                    }
                    case OFF_HAND: {
                        return Equipment.EquipmentSlot.OFF_HAND;
                    }
                }
                return null;
            }

            public void onPacketSend(PacketSendEvent event) {
                if (event.getPacketType() != PacketType.Play.Server.ENTITY_EQUIPMENT) {
                    return;
                }
                WrapperPlayServerEntityEquipment packet = new WrapperPlayServerEntityEquipment(event);
                Entity entity = SpigotConversionUtil.getEntityById((World)((Player)event.getPlayer()).getWorld(), (int)packet.getEntityId());
                NPC npc = plugin.getNPCRegistry().getNPC(entity);
                if (npc == null) {
                    return;
                }
                MirrorTrait mirror = npc.getTraitNullable(MirrorTrait.class);
                if (mirror != null && mirror.getEquipmentFunction() != null && mirror.isMirroring((Player)event.getPlayer())) {
                    ArrayList<com.github.retrooper.packetevents.protocol.player.Equipment> equipment = new ArrayList<com.github.retrooper.packetevents.protocol.player.Equipment>();
                    equipment.add(new com.github.retrooper.packetevents.protocol.player.Equipment(EquipmentSlot.CHEST_PLATE, SpigotConversionUtil.fromBukkitItemStack((ItemStack)mirror.getEquipmentFunction().apply((Player)event.getPlayer(), Equipment.EquipmentSlot.CHESTPLATE))));
                    equipment.add(new com.github.retrooper.packetevents.protocol.player.Equipment(EquipmentSlot.BOOTS, SpigotConversionUtil.fromBukkitItemStack((ItemStack)mirror.getEquipmentFunction().apply((Player)event.getPlayer(), Equipment.EquipmentSlot.BOOTS))));
                    equipment.add(new com.github.retrooper.packetevents.protocol.player.Equipment(EquipmentSlot.HELMET, SpigotConversionUtil.fromBukkitItemStack((ItemStack)mirror.getEquipmentFunction().apply((Player)event.getPlayer(), Equipment.EquipmentSlot.HELMET))));
                    equipment.add(new com.github.retrooper.packetevents.protocol.player.Equipment(EquipmentSlot.LEGGINGS, SpigotConversionUtil.fromBukkitItemStack((ItemStack)mirror.getEquipmentFunction().apply((Player)event.getPlayer(), Equipment.EquipmentSlot.LEGGINGS))));
                    equipment.add(new com.github.retrooper.packetevents.protocol.player.Equipment(EquipmentSlot.MAIN_HAND, SpigotConversionUtil.fromBukkitItemStack((ItemStack)mirror.getEquipmentFunction().apply((Player)event.getPlayer(), Equipment.EquipmentSlot.HAND))));
                    equipment.add(new com.github.retrooper.packetevents.protocol.player.Equipment(EquipmentSlot.MAIN_HAND, SpigotConversionUtil.fromBukkitItemStack((ItemStack)mirror.getEquipmentFunction().apply((Player)event.getPlayer(), Equipment.EquipmentSlot.OFF_HAND))));
                    packet.setEquipment(equipment);
                    packet.write();
                    return;
                }
                Equipment trait = npc.getTraitNullable(Equipment.class);
                if (trait == null) {
                    return;
                }
                boolean modified = false;
                for (com.github.retrooper.packetevents.protocol.player.Equipment equipment : packet.getEquipment()) {
                    ItemStack cosmetic;
                    Equipment.EquipmentSlot converted = this.convert(equipment.getSlot());
                    if (converted == null || (cosmetic = trait.getCosmetic(converted)) == null) continue;
                    equipment.setItem(SpigotConversionUtil.fromBukkitItemStack((ItemStack)cosmetic));
                    modified = true;
                }
                if (modified) {
                    packet.write();
                }
            }
        }, PacketListenerPriority.NORMAL);
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListener(){
            {
                try {
                    Class<?> component = Class.forName("net{}kyori{}adventure.text.Component".replace("{}", "."));
                    PacketEventsHook.this.PLAYERDATA_CONSTRUCTOR = WrapperPlayServerPlayerInfo.PlayerData.class.getConstructor(component, UserProfile.class, GameMode.class, Integer.TYPE);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private List<EntityData<?>> getMetadata(ClientVersion version, Entity player) {
                List<EntityMetadataValue> meta = NMS.getMetadata(player);
                ArrayList result = Lists.newArrayListWithExpectedSize((int)meta.size());
                for (EntityMetadataValue emv : meta) {
                    result.add(new EntityData(emv.id, EntityDataTypes.getById((ClientVersion)version, (int)emv.serializerId), emv.value));
                }
                return result;
            }

            private WrapperPlayServerPlayerInfo.PlayerData getPlayerData(Player player, NPC npc) {
                String fullName = npc.getFullName();
                UserProfile profile = new UserProfile(player.getUniqueId(), fullName);
                SkinProperty base = SkinProperty.fromMojangProfile(NMS.getProfile(player));
                if (base != null) {
                    profile.setTextureProperties((List)Lists.newArrayList((Object[])new TextureProperty[]{new TextureProperty(base.name, base.value, base.signature)}));
                }
                WrapperPlayServerPlayerInfo.PlayerData playerData = null;
                try {
                    playerData = (WrapperPlayServerPlayerInfo.PlayerData)PacketEventsHook.this.PLAYERDATA_CONSTRUCTOR.newInstance(PacketEventsHook.this.minimessage(npc.getFullName()), profile, GameMode.valueOf((String)player.getGameMode().name()), 10);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return playerData;
            }

            private void handleDestroyEntities(PacketSendEvent event) {
                WrapperPlayServerDestroyEntities packet = new WrapperPlayServerDestroyEntities(event);
                for (int eid : packet.getEntityIds()) {
                    DisguiseTrait trait = (DisguiseTrait)PacketEventsHook.this.disguiseTraits.get(eid);
                    if (trait == null || trait.getCosmeticEntity() == null || !(trait.getCosmeticEntity() instanceof Player)) continue;
                    WrapperPlayServerPlayerInfo remove = new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER, new WrapperPlayServerPlayerInfo.PlayerData[]{this.getPlayerData((Player)trait.getCosmeticEntity(), trait.getNPC())});
                    event.getUser().sendPacket((PacketWrapper)remove);
                }
            }

            private void handleEntityMetadata(PacketSendEvent event) {
                WrapperPlayServerEntityMetadata packet = new WrapperPlayServerEntityMetadata(event);
                DisguiseTrait trait = (DisguiseTrait)PacketEventsHook.this.disguiseTraits.get(packet.getEntityId());
                if (trait == null || trait.getCosmeticEntity() == null) {
                    return;
                }
                packet.setEntityMetadata(this.getMetadata(event.getUser().getClientVersion(), trait.getCosmeticEntity()));
                packet.write();
            }

            private void handleSpawnEntity(PacketSendEvent event) {
                WrapperPlayServerSpawnEntity packet = new WrapperPlayServerSpawnEntity(event);
                DisguiseTrait trait = (DisguiseTrait)PacketEventsHook.this.disguiseTraits.get(packet.getEntityId());
                if (trait == null || trait.getCosmeticEntity() == null) {
                    return;
                }
                if (trait.getCosmeticEntity() instanceof Player) {
                    event.setCancelled(true);
                    Player player = (Player)trait.getCosmeticEntity();
                    WrapperPlayServerPlayerInfo.PlayerData playerData = this.getPlayerData(player, trait.getNPC());
                    event.getUser().sendPacket((PacketWrapper)new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.ADD_PLAYER, new WrapperPlayServerPlayerInfo.PlayerData[]{playerData}));
                    event.getUser().sendPacket((PacketWrapper)new WrapperPlayServerSpawnPlayer(packet.getEntityId(), player.getUniqueId(), new Location(packet.getPosition(), packet.getHeadYaw(), packet.getPitch()), version -> this.getMetadata(version, (Entity)player)));
                    WrapperPlayServerPlayerInfo remove = new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER, new WrapperPlayServerPlayerInfo.PlayerData[]{playerData});
                    CitizensAPI.getScheduler().runEntityTaskLater((Entity)event.getPlayer(), () -> event.getUser().sendPacket((PacketWrapper)remove), Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asTicks());
                } else {
                    packet.setEntityType(EntityTypes.getByName((String)trait.getCosmeticEntity().getType().getKey().toString()));
                    packet.write();
                }
            }

            private void handleSpawnPlayer(PacketSendEvent event) {
                WrapperPlayServerSpawnPlayer packet = new WrapperPlayServerSpawnPlayer(event);
                DisguiseTrait trait = (DisguiseTrait)PacketEventsHook.this.disguiseTraits.get(packet.getEntityId());
                if (trait == null || trait.getCosmeticEntity() instanceof Player) {
                    return;
                }
                event.setCancelled(true);
                WrapperPlayServerSpawnEntity spawn = new WrapperPlayServerSpawnEntity(packet.getEntityId(), Optional.of(packet.getUUID()), EntityTypes.getByName((String)trait.getCosmeticEntity().getType().getKey().toString()), packet.getPosition(), packet.getPitch(), packet.getYaw(), packet.getYaw(), 0, Optional.empty());
                event.getUser().sendPacket((PacketWrapper)spawn);
            }

            public void onPacketSend(PacketSendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.SPAWN_ENTITY) {
                    this.handleSpawnEntity(event);
                } else if (event.getPacketType() == PacketType.Play.Server.SPAWN_PLAYER) {
                    this.handleSpawnPlayer(event);
                } else if (event.getPacketType() == PacketType.Play.Server.DESTROY_ENTITIES) {
                    this.handleDestroyEntities(event);
                } else if (event.getPacketType() == PacketType.Play.Server.PLAYER_INFO) {
                    WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(event);
                    Iterator iterator = packet.getPlayerDataList().iterator();
                    while (iterator.hasNext()) {
                        WrapperPlayServerPlayerInfo.PlayerData pd = (WrapperPlayServerPlayerInfo.PlayerData)iterator.next();
                        DisguiseTrait trait = (DisguiseTrait)PacketEventsHook.this.disguiseTraitsUUID.get(pd.getUserProfile().getUUID());
                        if (trait == null || trait.getCosmeticEntity() == null) {
                            return;
                        }
                        if (trait.getCosmeticEntity() instanceof Player) continue;
                        iterator.remove();
                    }
                    packet.write();
                } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_METADATA) {
                    this.handleEntityMetadata(event);
                }
            }
        }, PacketListenerPriority.NORMAL);
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListener(){

            public void onPacketSend(PacketSendEvent event) {
                if (event.getPacketType() != PacketType.Play.Server.ENTITY_METADATA) {
                    return;
                }
                WrapperPlayServerEntityMetadata packet = new WrapperPlayServerEntityMetadata(event);
                Entity entity = SpigotConversionUtil.getEntityById((World)((Player)event.getPlayer()).getWorld(), (int)packet.getEntityId());
                NPC npc = plugin.getNPCRegistry().getNPC(entity);
                if (npc == null || !npc.data().has(NPC.Metadata.HOLOGRAM_RENDERER)) {
                    return;
                }
                int version = event.getUser().getPacketVersion().getProtocolVersion();
                HologramTrait.HologramRenderer hr = (HologramTrait.HologramRenderer)npc.data().get(NPC.Metadata.HOLOGRAM_RENDERER);
                String fakeName = null;
                String suppliedName = hr.getPerPlayerText(npc, (Player)event.getPlayer());
                fakeName = version <= ServerVersion.V_1_12_2.getProtocolVersion() ? suppliedName : Optional.of(PacketEventsHook.this.minimessage(suppliedName));
                boolean sneaking = hr.isSneaking(npc, (Player)event.getPlayer());
                boolean delta = false;
                for (EntityData data : packet.getEntityMetadata()) {
                    if (sneaking && data.getIndex() == 0) {
                        byte b = (byte)(((Number)data.getValue()).byteValue() | 2);
                        data.setValue((Object)b);
                        delta = true;
                        continue;
                    }
                    if (fakeName != null && data.getIndex() == 2) {
                        data.setValue((Object)fakeName);
                        delta = true;
                        continue;
                    }
                    if ((data.getIndex() != 22 || version > ServerVersion.V_1_19_4.getProtocolVersion()) && (data.getIndex() != 23 || version <= ServerVersion.V_1_19_4.getProtocolVersion()) || fakeName == null || npc.getEntity().getType() != EntityType.TEXT_DISPLAY) continue;
                    data.setValue(((Optional)((Object)fakeName)).get());
                    delta = true;
                }
                if (delta) {
                    packet.write();
                }
            }
        }, PacketListenerPriority.HIGHEST);
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListener(){

            public void onPacketSend(PacketSendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.PLAYER_INFO) {
                    WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(event);
                    if (packet.getAction() != WrapperPlayServerPlayerInfo.Action.ADD_PLAYER) {
                        return;
                    }
                    boolean changed = false;
                    UserProfile playerProfile = event.getUser().getProfile();
                    String playerName = Util.possiblyStripBedrockPrefix(((Player)event.getPlayer()).getDisplayName(), playerProfile.getUUID());
                    for (WrapperPlayServerPlayerInfo.PlayerData data : packet.getPlayerDataList()) {
                        MirrorTrait trait = (MirrorTrait)PacketEventsHook.this.mirrorTraits.get(data.getUserProfile().getUUID());
                        if (trait == null || !trait.isMirroring((Player)event.getPlayer())) continue;
                        if (trait.mirrorName()) {
                            data.getUserProfile().setName(playerName);
                            data.getUserProfile().setUUID(playerProfile.getUUID());
                        }
                        data.getUserProfile().setTextureProperties(playerProfile.getTextureProperties());
                        changed = true;
                    }
                    if (changed) {
                        packet.write();
                    }
                } else if (event.getPacketType() == PacketType.Play.Server.PLAYER_INFO_UPDATE) {
                    WrapperPlayServerPlayerInfoUpdate packet = new WrapperPlayServerPlayerInfoUpdate(event);
                    if (!packet.getActions().contains(WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER)) {
                        return;
                    }
                    boolean changed = false;
                    UserProfile playerProfile = event.getUser().getProfile();
                    String playerName = Util.possiblyStripBedrockPrefix(((Player)event.getPlayer()).getDisplayName(), playerProfile.getUUID());
                    for (WrapperPlayServerPlayerInfoUpdate.PlayerInfo data : packet.getEntries()) {
                        MirrorTrait trait = (MirrorTrait)PacketEventsHook.this.mirrorTraits.get(data.getGameProfile().getUUID());
                        if (trait == null || !trait.isMirroring((Player)event.getPlayer())) continue;
                        if (trait.mirrorName()) {
                            data.getGameProfile().setName(playerName);
                            data.getGameProfile().setUUID(playerProfile.getUUID());
                        }
                        data.setListed(trait.getNPC().shouldRemoveFromTabList());
                        data.getGameProfile().setTextureProperties(playerProfile.getTextureProperties());
                        changed = true;
                    }
                    if (changed) {
                        packet.write();
                    }
                }
            }
        }, PacketListenerPriority.HIGHEST);
        final EnumSet<PacketType.Play.Server> rotation = EnumSet.of(PacketType.Play.Server.ENTITY_HEAD_LOOK, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION, PacketType.Play.Server.ENTITY_ROTATION);
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListener(){

            private RotationTrait.PacketRotationSession getSession(int eid, Player player) {
                RotationTrait trait = (RotationTrait)PacketEventsHook.this.rotationTraits.get(eid);
                if (trait == null) {
                    return null;
                }
                RotationTrait.PacketRotationSession session = trait.getPacketSession(player);
                if (session == null || !session.isActive()) {
                    return null;
                }
                return session;
            }

            public void onPacketSend(PacketSendEvent event) {
                if (!rotation.contains(event.getPacketType())) {
                    return;
                }
                PacketTypeCommon type = event.getPacketType();
                RotationTrait.PacketRotationSession session = null;
                if (type == PacketType.Play.Server.ENTITY_HEAD_LOOK) {
                    WrapperPlayServerEntityHeadLook packet = new WrapperPlayServerEntityHeadLook(event);
                    session = this.getSession(packet.getEntityId(), (Player)event.getPlayer());
                    if (session == null) {
                        return;
                    }
                    packet.setHeadYaw(session.getHeadYaw());
                    packet.write();
                } else if (type == PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION) {
                    WrapperPlayServerEntityRelativeMoveAndRotation packet = new WrapperPlayServerEntityRelativeMoveAndRotation(event);
                    session = this.getSession(packet.getEntityId(), (Player)event.getPlayer());
                    if (session == null) {
                        return;
                    }
                    packet.setYaw(session.getBodyYaw());
                    packet.setPitch(session.getPitch());
                    packet.write();
                } else if (type == PacketType.Play.Server.ENTITY_ROTATION) {
                    WrapperPlayServerEntityRotation packet = new WrapperPlayServerEntityRotation(event);
                    session = this.getSession(packet.getEntityId(), (Player)event.getPlayer());
                    if (session == null) {
                        return;
                    }
                    packet.setYaw(session.getBodyYaw());
                    packet.setPitch(session.getPitch());
                    packet.write();
                } else if (type == PacketType.Play.Server.ENTITY_TELEPORT) {
                    WrapperPlayServerEntityTeleport packet = new WrapperPlayServerEntityTeleport(event);
                    session = this.getSession(packet.getEntityId(), (Player)event.getPlayer());
                    if (session == null) {
                        return;
                    }
                    packet.setYaw(session.getBodyYaw());
                    packet.setPitch(session.getPitch());
                    packet.write();
                }
                session.onPacketOverwritten();
            }
        }, PacketListenerPriority.HIGHEST);
    }

    private Object minimessage(String raw) {
        if (this.MINIMESSAGE == null) {
            try {
                this.MINIMESSAGE = NMS.getMethodHandle(Class.forName("net{}kyori{}adventure.text.minimessage.MiniMessage".replace("{}", ".")), "miniMessage", true, new Class[0]).invoke();
                this.DESERIALIZE_METHOD = NMS.getMethodHandle(this.MINIMESSAGE.getClass(), "deserialize", true, String.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            return this.DESERIALIZE_METHOD.invoke(this.MINIMESSAGE, Messaging.convertLegacyCodes(raw).replace("<csr>", ""));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        this.rotationTraits.remove(event.getEntity().getEntityId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCDespawn(NPCDespawnEvent event) {
        if (event.getNPC().getEntity() == null) {
            return;
        }
        this.rotationTraits.remove(event.getNPC().getEntity().getEntityId());
        this.mirrorTraits.remove(event.getNPC().getEntity().getUniqueId());
        this.disguiseTraits.remove(event.getNPC().getEntity().getEntityId());
        this.disguiseTraits.remove(event.getNPC().getEntity().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCSpawn(NPCSpawnEvent event) {
        this.onSpawn(event);
    }

    private void onSpawn(NPCEvent event) {
        if (event.getNPC().hasTrait(RotationTrait.class)) {
            this.rotationTraits.put(event.getNPC().getEntity().getEntityId(), event.getNPC().getTraitNullable(RotationTrait.class));
        }
        if (event.getNPC().hasTrait(DisguiseTrait.class)) {
            this.disguiseTraits.put(event.getNPC().getEntity().getEntityId(), event.getNPC().getTraitNullable(DisguiseTrait.class));
            this.disguiseTraitsUUID.put(event.getNPC().getEntity().getUniqueId(), event.getNPC().getTraitNullable(DisguiseTrait.class));
        }
        if (event.getNPC().hasTrait(MirrorTrait.class) && event.getNPC().getOrAddTrait(MobType.class).getType() == EntityType.PLAYER) {
            this.mirrorTraits.put(event.getNPC().getEntity().getUniqueId(), event.getNPC().getTraitNullable(MirrorTrait.class));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTraitAdd(NPCAddTraitEvent event) {
        if (event.getNPC().getEntity() == null) {
            return;
        }
        this.onSpawn(event);
    }
}

