/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command.command;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandConfigurable;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.NoPermissionsException;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;

@Requirements(selected=true, ownership=true)
public class TraitCommands {
    @Command(aliases={"trait", "tr"}, usage="add [trait name]...", desc="Adds traits to the NPC", modifiers={"add", "a"}, min=1, permission="npc.trait")
    public void add(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList added = Lists.newArrayList();
        ArrayList failed = Lists.newArrayList();
        for (String traitName : Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(0))) {
            Class<? extends Trait> clazz;
            if (!sender.hasPermission("citizens.npc.trait." + traitName)) {
                failed.add(String.format("%s: No permission", traitName));
            }
            if ((clazz = CitizensAPI.getTraitFactory().getTraitClass(traitName)) == null) {
                failed.add(String.format("%s: Trait not found", traitName));
                continue;
            }
            if (npc.hasTrait(clazz)) {
                failed.add(String.format("%s: Already added", traitName));
                continue;
            }
            npc.addTrait(clazz);
            added.add(StringHelper.wrap(traitName));
        }
        if (added.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.added", Joiner.on((String)", ").join((Iterable)added));
        }
        if (failed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.failed-to-add", Joiner.on((String)", ").join((Iterable)failed));
        }
    }

    @Command(aliases={"traitc", "trc"}, usage="[trait name] (flags)", desc="Configures a trait", modifiers={"*"}, min=1, flags="*", permission="npc.trait-configure")
    public void configure(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String traitName = args.getString(0);
        if (!sender.hasPermission("citizens.npc.trait-configure." + traitName)) {
            throw new NoPermissionsException();
        }
        Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(args.getString(0));
        if (clazz == null) {
            throw new CommandException("citizens.commands.traitc.missing");
        }
        if (!clazz.isAssignableFrom(CommandConfigurable.class)) {
            throw new CommandException("citizens.commands.traitc.not-configurable");
        }
        if (!npc.hasTrait(clazz)) {
            throw new CommandException("citizens.commands.traitc.not-on-npc");
        }
        CommandConfigurable trait = (CommandConfigurable)((Object)npc.getTrait(clazz));
        trait.configure(args);
    }

    @Command(aliases={"trait", "tr"}, usage="remove [trait name]...", desc="Removes traits on the NPC", modifiers={"remove", "rem", "r"}, min=1, permission="npc.trait")
    public void remove(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList removed = Lists.newArrayList();
        ArrayList failed = Lists.newArrayList();
        for (String traitName : Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(0))) {
            Class<? extends Trait> clazz;
            if (!sender.hasPermission("citizens.npc.trait." + traitName)) {
                failed.add(String.format("%s: No permission", traitName));
            }
            if ((clazz = CitizensAPI.getTraitFactory().getTraitClass(traitName)) == null) {
                failed.add(String.format("%s: Trait not found", traitName));
                continue;
            }
            boolean hasTrait = npc.hasTrait(clazz);
            if (!hasTrait) {
                failed.add(String.format("%s: Trait not attached", traitName));
                continue;
            }
            npc.removeTrait(clazz);
            removed.add(StringHelper.wrap(traitName));
        }
        if (removed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.removed", Joiner.on((String)", ").join((Iterable)removed));
        }
        if (failed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.failed-to-remove", Joiner.on((String)", ").join((Iterable)failed));
        }
    }

    @Command(aliases={"trait", "tr"}, usage="[trait name], [trait name]...", desc="Toggles traits on the NPC", modifiers={"*"}, min=1, permission="npc.trait")
    public void toggle(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList added = Lists.newArrayList();
        ArrayList removed = Lists.newArrayList();
        ArrayList failed = Lists.newArrayList();
        for (String traitName : Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(0))) {
            Class<? extends Trait> clazz;
            if (!sender.hasPermission("citizens.npc.trait." + traitName)) {
                failed.add(String.format("%s: No permission", traitName));
            }
            if ((clazz = CitizensAPI.getTraitFactory().getTraitClass(traitName)) == null) {
                failed.add(String.format("%s: Trait not found", traitName));
                continue;
            }
            boolean remove = npc.hasTrait(clazz);
            if (remove) {
                npc.removeTrait(clazz);
                removed.add(StringHelper.wrap(traitName));
                continue;
            }
            npc.addTrait(clazz);
            added.add(StringHelper.wrap(traitName));
        }
        if (added.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.added", Joiner.on((String)", ").join((Iterable)added));
        }
        if (removed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.removed", Joiner.on((String)", ").join((Iterable)removed));
        }
        if (failed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.failed-to-change", Joiner.on((String)", ").join((Iterable)failed));
        }
    }
}

