/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import net.citizensnpcs.EventListen;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public abstract class CitizensNPC
extends AbstractNPC {
    protected EntityLiving mcEntity;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private static final String NPC_METADATA_MARKER = "NPC";

    protected CitizensNPC(int id, String name) {
        super(id, name);
    }

    protected abstract EntityLiving createHandle(Location var1);

    @Override
    public boolean despawn() {
        if (!this.isSpawned()) {
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCDespawnEvent(this));
        boolean keepSelected = this.getTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        for (Trait trait : this.traits.values()) {
            trait.onDespawn();
        }
        this.getBukkitEntity().remove();
        this.mcEntity = null;
        return true;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        if (this.getHandle() == null) {
            return null;
        }
        return (LivingEntity)this.getHandle().getBukkitEntity();
    }

    public EntityLiving getHandle() {
        return this.mcEntity;
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public Trait getTraitFor(Class<? extends Trait> clazz) {
        return CitizensAPI.getTraitFactory().getTrait(clazz);
    }

    @Override
    public boolean isSpawned() {
        return this.getHandle() != null;
    }

    public void load(DataKey root) {
        Location spawnLoc;
        this.metadata.loadFrom(root.getRelative("metadata"));
        for (DataKey traitKey : root.getRelative("traits").getSubKeys()) {
            Trait trait;
            if (traitKey.keyExists("enabled") && !traitKey.getBoolean("enabled")) continue;
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
            if (this.hasTrait(clazz)) {
                trait = this.getTrait(clazz);
            } else {
                trait = CitizensAPI.getTraitFactory().getTrait(clazz);
                if (trait == null) {
                    Messaging.severeTr("citizens.notifications.skipping-broken-trait", traitKey.name(), this.getId());
                    continue;
                }
                this.addTrait(trait);
            }
            try {
                trait.load(traitKey);
                PersistenceLoader.load(trait, traitKey);
            }
            catch (NPCLoadException ex) {
                Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
            }
        }
        if (this.getTrait(Spawned.class).shouldSpawn() && (spawnLoc = this.getTrait(CurrentLocation.class).getLocation()) != null) {
            this.spawn(spawnLoc);
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    public void save(DataKey root) {
        root.setString("name", this.getFullName());
        this.metadata.saveTo(root.getRelative("metadata"));
        this.navigator.save(root.getRelative("navigator"));
        for (Trait trait : this.traits.values()) {
            DataKey traitKey = root.getRelative("traits." + trait.getName());
            trait.save(traitKey);
            PersistenceLoader.save(trait, traitKey);
        }
    }

    @Override
    public boolean spawn(Location loc) {
        Validate.notNull((Object)loc, (String)"location cannot be null");
        if (this.isSpawned()) {
            return false;
        }
        this.mcEntity = this.createHandle(loc);
        boolean couldSpawn = this.mcEntity.world.addEntity((Entity)this.mcEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        if (!couldSpawn) {
            this.mcEntity = null;
            EventListen.add(loc, this.getId());
            return true;
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, loc);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            this.mcEntity = null;
            return false;
        }
        this.getBukkitEntity().setMetadata(NPC_METADATA_MARKER, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        this.getTrait(CurrentLocation.class).setLocation(loc);
        this.getTrait(Spawned.class).setSpawned(true);
        this.navigator.onSpawn();
        for (Trait trait : this.traits.values()) {
            trait.onSpawn();
        }
        return true;
    }

    @Override
    public void update() {
        try {
            super.update();
            if (this.isSpawned()) {
                NMS.trySwim(this.getHandle());
                this.navigator.update();
            }
        }
        catch (Exception ex) {
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), ex.getMessage());
            ex.printStackTrace();
        }
    }
}

