/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TeleportStuckAction
implements StuckAction {
    public static TeleportStuckAction INSTANCE = new TeleportStuckAction();
    private static int MAX_ITERATIONS = 10;
    private static final double RANGE = 10.0;
    private static Set<Material> TELEPORTABLE_BLOCKS = EnumSet.of(Material.AIR, new Material[]{Material.BIRCH_WOOD_STAIRS, Material.BRICK_STAIRS, Material.CAKE_BLOCK, Material.COBBLESTONE_STAIRS, Material.DEAD_BUSH, Material.JUNGLE_WOOD_STAIRS, Material.LADDER, Material.LONG_GRASS, Material.RAILS, Material.POWERED_RAIL, Material.REDSTONE_WIRE, Material.REDSTONE_TORCH_ON, Material.REDSTONE_TORCH_OFF, Material.TRAP_DOOR, Material.TRIPWIRE, Material.TRIPWIRE_HOOK, Material.VINE, Material.WALL_SIGN, Material.WATER, Material.WOOD_STAIRS, Material.WOOD_STEP, Material.WOODEN_DOOR, Material.YELLOW_FLOWER, Material.RED_ROSE, Material.SIGN, Material.SIGN_POST, Material.WATER});

    private TeleportStuckAction() {
    }

    private boolean canStand(Block block) {
        return TELEPORTABLE_BLOCKS.contains(block.getType()) && TELEPORTABLE_BLOCKS.contains(block.getRelative(BlockFace.UP).getType());
    }

    @Override
    public boolean run(NPC npc, Navigator navigator) {
        if (!npc.isSpawned()) {
            return false;
        }
        Location base = navigator.getTargetAsLocation();
        if (npc.getBukkitEntity().getLocation().distanceSquared(base) <= 10.0) {
            return true;
        }
        Block block = base.getBlock();
        int iterations = 0;
        while (!this.canStand(block)) {
            if (iterations++ >= MAX_ITERATIONS) {
                block = base.getBlock();
                break;
            }
            block = block.getRelative(BlockFace.UP);
        }
        npc.getBukkitEntity().teleport(block.getLocation());
        return false;
    }
}

