/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.StringHelper;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CitizensHumanNPC
extends CitizensNPC
implements Equipable {
    public CitizensHumanNPC(int id, String name) {
        super(id, name);
    }

    @Override
    protected EntityLiving createHandle(final Location loc) {
        WorldServer ws = ((CraftWorld)loc.getWorld()).getHandle();
        final EntityHumanNPC handle = new EntityHumanNPC(ws.getServer().getServer(), (World)ws, StringHelper.parseColors(this.getFullName()), new ItemInWorldManager(ws), this);
        handle.getBukkitEntity().teleport(loc);
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                handle.as = loc.getYaw() % 360.0f;
                boolean removeFromPlayerList = Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean();
                NMS.addOrRemoveFromPlayerList((LivingEntity)CitizensHumanNPC.this.getBukkitEntity(), removeFromPlayerList || CitizensHumanNPC.this.data().getPersistent("removefromplayerlist", removeFromPlayerList) != false);
            }
        }, 5L);
        handle.getBukkitEntity().setSleepingIgnored(true);
        return handle;
    }

    @Override
    public void equip(Player equipper, ItemStack hand) {
        Equipment trait = this.getTrait(Equipment.class);
        int slot = 0;
        Material type = hand == null ? Material.AIR : hand.getType();
        switch (type) {
            case PUMPKIN: 
            case JACK_O_LANTERN: 
            case LEATHER_HELMET: 
            case CHAINMAIL_HELMET: 
            case GOLD_HELMET: 
            case IRON_HELMET: 
            case DIAMOND_HELMET: {
                if (equipper.isSneaking()) break;
                slot = 1;
                break;
            }
            case LEATHER_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case GOLD_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: {
                if (equipper.isSneaking()) break;
                slot = 2;
                break;
            }
            case LEATHER_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case GOLD_LEGGINGS: 
            case IRON_LEGGINGS: 
            case DIAMOND_LEGGINGS: {
                if (equipper.isSneaking()) break;
                slot = 3;
                break;
            }
            case LEATHER_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case GOLD_BOOTS: 
            case IRON_BOOTS: 
            case DIAMOND_BOOTS: {
                if (equipper.isSneaking()) break;
                slot = 4;
                break;
            }
            case AIR: {
                for (int i = 0; i < 5; ++i) {
                    if (trait.get(i) == null || trait.get(i).getType() == Material.AIR) continue;
                    equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), trait.get(i));
                    trait.set(i, null);
                }
                Messaging.sendTr((CommandSender)equipper, "citizens.editors.equipment.all-items-removed", this.getName());
            }
        }
        ItemStack equippedItem = trait.get(slot);
        if (equippedItem != null && equippedItem.getType() != Material.AIR) {
            equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), equippedItem);
        }
        if (type != Material.AIR) {
            ItemStack clone = hand.clone();
            clone.setAmount(1);
            trait.set(slot, clone);
            hand.setAmount(hand.getAmount() - 1);
        }
    }

    public Player getBukkitEntity() {
        if (this.getHandle() == null) {
            return null;
        }
        return this.getHandle().getBukkitEntity();
    }

    public EntityHumanNPC getHandle() {
        return (EntityHumanNPC)this.mcEntity;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        Location prev = this.getBukkitEntity().getLocation();
        this.despawn();
        this.spawn(prev);
    }

    @Override
    public void update() {
        super.update();
        if (this.isSpawned() && this.getBukkitEntity().getLocation().getChunk().isLoaded()) {
            this.mcEntity.move(0.0, -0.2, 0.0);
            NMS.trySwim((EntityLiving)this.getHandle());
        }
    }
}

